/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.jaxrs2.integration.ServletConfigContextUtils;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.integration.GenericOpenApiContext;
import io.swagger.v3.oas.integration.OpenApiContextLocator;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import javax.servlet.ServletConfig;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;

public class OpenApiCustomizedResource
extends OpenApiResource {
    private final OpenApiCustomizer customizer;

    public OpenApiCustomizedResource(OpenApiCustomizer customizer) {
        this.customizer = customizer;
    }

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @Operation(hidden=true)
    public Response getOpenApi(@Context ServletConfig config, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="type") String type) throws Exception {
        if (this.customizer != null) {
            OpenAPIConfiguration configuration = this.customizer.customize(this.getOpenApiConfiguration());
            this.setOpenApiConfiguration(configuration);
            String ctxId = ServletConfigContextUtils.getContextIdFromServletConfig((ServletConfig)config);
            OpenApiContext ctx = OpenApiContextLocator.getInstance().getOpenApiContext(ctxId);
            if (ctx instanceof GenericOpenApiContext) {
                ((GenericOpenApiContext)ctx).getOpenApiReader().setConfiguration(configuration);
                this.customizer.customize(ctx.read());
            }
        }
        return super.getOpenApi(headers, uriInfo, type);
    }
}

