/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.swagger.ApplicationBeanConfig;
import org.apache.cxf.jaxrs.swagger.DefaultSwagger2Serializers;
import org.apache.cxf.jaxrs.swagger.DelegatingServletConfig;
import org.apache.cxf.jaxrs.swagger.Swagger2ApiListingResource;
import org.apache.cxf.jaxrs.swagger.Swagger2Customizer;
import org.apache.cxf.jaxrs.swagger.Swagger2Serializers;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResolver;
import org.apache.cxf.jaxrs.swagger.SyntheticServletConfig;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;

@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class Swagger2Feature
extends AbstractSwaggerFeature {
    private String host;
    private String[] schemes;
    private boolean prettyPrint;
    private boolean scanAllResources;
    private String ignoreRoutes;
    private Swagger2Serializers swagger2Serializers;
    private boolean supportSwaggerUi = true;
    private String swaggerUiVersion;
    private String swaggerUiMavenGroupAndArtifact;
    private Map<String, String> swaggerUiMediaTypes;
    private boolean usePathBasedConfig;
    private boolean dynamicBasePath;
    private Map<String, SecuritySchemeDefinition> securityDefinitions;
    private Swagger2Customizer customizer;

    @Override
    protected void calculateDefaultBasePath(Server server) {
        this.dynamicBasePath = true;
        super.calculateDefaultBasePath(server);
    }

    @Override
    protected void addSwaggerResource(Server server, Bus bus) {
        String swaggerUiRoot;
        ServerProviderFactory factory;
        JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        ApplicationInfo appInfo = null;
        if (!this.isScan() && (appInfo = (factory = (ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).getApplicationProvider()) == null) {
            HashSet serviceClasses = new HashSet();
            for (ClassResourceInfo cri : sfb.getClassResourceInfo()) {
                serviceClasses.add(cri.getServiceClass());
            }
            appInfo = new ApplicationInfo((Application)new DefaultApplication(serviceClasses), bus);
            server.getEndpoint().put((Object)Application.class.getName(), (Object)appInfo);
        }
        LinkedList<Object> swaggerResources = new LinkedList<Object>();
        Swagger2ApiListingResource apiListingResource = new Swagger2ApiListingResource(this.customizer);
        swaggerResources.add((Object)apiListingResource);
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.runAsFilter) {
            providers.add((Object)new SwaggerContainerRequestFilter(appInfo == null ? null : (Application)appInfo.getProvider()));
        }
        if (this.supportSwaggerUi && (swaggerUiRoot = SwaggerUiResolver.findSwaggerUiRoot(this.swaggerUiMavenGroupAndArtifact, this.swaggerUiVersion)) != null) {
            SwaggerUIService swaggerUiService = new SwaggerUIService(swaggerUiRoot, this.swaggerUiMediaTypes);
            if (!this.runAsFilter) {
                swaggerResources.add(swaggerUiService);
            } else {
                providers.add(new SwaggerUIServiceFilter(swaggerUiService));
            }
            providers.add(new SwaggerUIResourceFilter());
            bus.setProperty("swagger.service.ui.available", (Object)"true");
        }
        sfb.setResourceClassesFromBeans(swaggerResources);
        List cris = sfb.getClassResourceInfo();
        if (!this.runAsFilter) {
            for (ClassResourceInfo cri : cris) {
                if (!ApiListingResource.class.isAssignableFrom(cri.getResourceClass())) continue;
                InjectionUtils.injectContextProxies((AbstractResourceInfo)cri, (Object)((Object)apiListingResource));
            }
        }
        if (this.customizer == null) {
            if (this.swagger2Serializers == null) {
                this.swagger2Serializers = new DefaultSwagger2Serializers();
            }
            this.swagger2Serializers.setClassResourceInfos(cris);
            this.swagger2Serializers.setDynamicBasePath(this.dynamicBasePath);
            providers.add(this.swagger2Serializers);
        } else {
            this.customizer.setClassResourceInfos(cris);
            this.customizer.setDynamicBasePath(this.dynamicBasePath);
        }
        providers.add(new ReaderConfigFilter());
        if (this.usePathBasedConfig) {
            providers.add(new ServletConfigProvider());
        }
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = appInfo == null ? new BeanConfig() : new ApplicationBeanConfig((Application)appInfo.getProvider());
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setUsePathBasedConfig(this.isUsePathBasedConfig());
        beanConfig.setVersion(this.getVersion());
        String basePath = this.getBasePath();
        beanConfig.setBasePath(basePath);
        beanConfig.setHost(this.getHost());
        beanConfig.setSchemes(this.getSchemes());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setTermsOfServiceUrl(this.getTermsOfServiceUrl());
        beanConfig.setScan(this.isScan());
        beanConfig.setPrettyPrint(this.isPrettyPrint());
        beanConfig.setFilterClass(this.getFilterClass());
        Swagger swagger = beanConfig.getSwagger();
        if (swagger != null && this.securityDefinitions != null) {
            swagger.setSecurityDefinitions(this.securityDefinitions);
        }
        if (this.customizer == null) {
            this.swagger2Serializers.setBeanConfig(beanConfig);
        } else {
            this.customizer.setBeanConfig(beanConfig);
        }
    }

    public boolean isUsePathBasedConfig() {
        return this.usePathBasedConfig;
    }

    public void setUsePathBasedConfig(boolean usePathBasedConfig) {
        this.usePathBasedConfig = usePathBasedConfig;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public Swagger2Customizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(Swagger2Customizer customizer) {
        this.customizer = customizer;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isScanAllResources() {
        return this.scanAllResources;
    }

    public void setScanAllResources(boolean scanAllResources) {
        this.scanAllResources = scanAllResources;
    }

    public String getIgnoreRoutes() {
        return this.ignoreRoutes;
    }

    public void setIgnoreRoutes(String ignoreRoutes) {
        this.ignoreRoutes = ignoreRoutes;
    }

    public void setSwagger2Serializers(Swagger2Serializers swagger2Serializers) {
        this.swagger2Serializers = swagger2Serializers;
    }

    @Override
    protected void setBasePathByAddress(String address) {
        if (!address.startsWith("/")) {
            URI u = URI.create(address);
            this.setBasePath(u.getPath());
            this.setHost(u.getPort() < 0 ? u.getHost() : u.getHost() + ":" + u.getPort());
        } else {
            this.setBasePath(address);
        }
    }

    public void setSwaggerUiMavenGroupAndArtifact(String swaggerUiMavenGroupAndArtifact) {
        this.swaggerUiMavenGroupAndArtifact = swaggerUiMavenGroupAndArtifact;
    }

    public void setSwaggerUiVersion(String swaggerUiVersion) {
        this.swaggerUiVersion = swaggerUiVersion;
    }

    public void setSupportSwaggerUi(boolean supportSwaggerUi) {
        this.supportSwaggerUi = supportSwaggerUi;
    }

    public void setSwaggerUiMediaTypes(Map<String, String> swaggerUiMediaTypes) {
        this.swaggerUiMediaTypes = swaggerUiMediaTypes;
    }

    public void setSecurityDefinitions(Map<String, SecuritySchemeDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    protected static class DefaultApplication
    extends Application {
        Set<Class<?>> serviceClasses;

        DefaultApplication(Set<Class<?>> serviceClasses) {
            this.serviceClasses = serviceClasses;
        }

        public Set<Class<?>> getClasses() {
            return this.serviceClasses;
        }
    }

    @PreMatching
    @Priority(value=5001)
    protected static class SwaggerUIServiceFilter
    implements ContainerRequestFilter {
        private SwaggerUIService uiService;

        SwaggerUIServiceFilter(SwaggerUIService uiService) {
            this.uiService = uiService;
        }

        public void filter(ContainerRequestContext rc) throws IOException {
            UriInfo ui;
            String path;
            int uiPathIndex;
            if ("GET".equals(rc.getRequest().getMethod()) && (uiPathIndex = (path = (ui = rc.getUriInfo()).getPath()).lastIndexOf("api-docs")) >= 0) {
                String resourcePath = uiPathIndex + 8 < path.length() ? path.substring(uiPathIndex + 8) : "";
                rc.abortWith(this.uiService.getResource(ui, resourcePath));
            }
        }
    }

    @PreMatching
    @Priority(value=5000)
    protected static class SwaggerUIResourceFilter
    implements ContainerRequestFilter {
        private static final Pattern PATTERN = Pattern.compile(".*[.]js|.*[.]gz|.*[.]map|oauth2*[.]html|.*[.]png|.*[.]css|.*[.]ico|/css/.*|/images/.*|/lib/.*|/fonts/.*");

        protected SwaggerUIResourceFilter() {
        }

        public void filter(ContainerRequestContext rc) throws IOException {
            if ("GET".equals(rc.getRequest().getMethod())) {
                UriInfo ui = rc.getUriInfo();
                String path = "/" + ui.getPath();
                if (PATTERN.matcher(path).matches()) {
                    rc.setRequestUri(URI.create("api-docs" + path));
                }
            }
        }
    }

    @Path(value="api-docs")
    public static class SwaggerUIService {
        private static final String FAVICON = "favicon";
        private static final Map<String, String> DEFAULT_MEDIA_TYPES = new HashMap<String, String>();
        private final String swaggerUiRoot;
        private final Map<String, String> mediaTypes;

        public SwaggerUIService(String swaggerUiRoot, Map<String, String> mediaTypes) {
            this.swaggerUiRoot = swaggerUiRoot;
            this.mediaTypes = mediaTypes;
        }

        @GET
        @Path(value="{resource:.*}")
        public Response getResource(@Context UriInfo uriInfo, @PathParam(value="resource") String resourcePath) {
            if (StringUtils.isEmpty((String)resourcePath) || "/".equals(resourcePath)) {
                resourcePath = "index.html";
            }
            if (resourcePath.contains(FAVICON)) {
                return Response.status((int)404).build();
            }
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                URL resourceURL = URI.create(this.swaggerUiRoot + resourcePath).toURL();
                String mediaType = null;
                int ind = resourcePath.lastIndexOf(46);
                if (ind != -1 && ind < resourcePath.length()) {
                    String resourceExt = resourcePath.substring(ind + 1);
                    mediaType = this.mediaTypes != null && this.mediaTypes.containsKey(resourceExt) ? this.mediaTypes.get(resourceExt) : DEFAULT_MEDIA_TYPES.get(resourceExt);
                }
                Response.ResponseBuilder rb = Response.ok((Object)resourceURL.openStream());
                if (mediaType != null) {
                    rb.type(mediaType);
                }
                return rb.build();
            }
            catch (IOException ex) {
                throw new NotFoundException((Throwable)ex);
            }
        }

        static {
            DEFAULT_MEDIA_TYPES.put("html", "text/html");
            DEFAULT_MEDIA_TYPES.put("png", "image/png");
            DEFAULT_MEDIA_TYPES.put("gif", "image/gif");
            DEFAULT_MEDIA_TYPES.put("css", "text/css");
            DEFAULT_MEDIA_TYPES.put("js", "application/javascript");
            DEFAULT_MEDIA_TYPES.put("eot", "application/vnd.ms-fontobject");
            DEFAULT_MEDIA_TYPES.put("ttf", "application/font-sfnt");
            DEFAULT_MEDIA_TYPES.put("svg", "image/svg+xml");
            DEFAULT_MEDIA_TYPES.put("woff", "application/font-woff");
            DEFAULT_MEDIA_TYPES.put("woff2", "application/font-woff2");
        }
    }

    protected class ReaderConfigFilter
    implements ContainerRequestFilter {
        @Context
        protected MessageContext mc;

        protected ReaderConfigFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            ServletContext servletContext = this.mc.getServletContext();
            if (servletContext != null && servletContext.getAttribute(ReaderConfig.class.getName()) == null) {
                if (this.mc.getServletConfig() != null && Boolean.valueOf(this.mc.getServletConfig().getInitParameter("scan.all.resources")).booleanValue()) {
                    this.addReaderConfig(this.mc.getServletConfig().getInitParameter("ignore.routes"));
                } else if (Swagger2Feature.this.isScanAllResources()) {
                    this.addReaderConfig(Swagger2Feature.this.getIgnoreRoutes());
                }
            }
        }

        protected void addReaderConfig(String ignoreRoutesParam) {
            DefaultReaderConfig rc = new DefaultReaderConfig();
            rc.setScanAllResources(true);
            if (ignoreRoutesParam != null) {
                LinkedHashSet<String> routes = new LinkedHashSet<String>();
                for (String route : StringUtils.split((String)ignoreRoutesParam, (String)",")) {
                    routes.add(route.trim());
                }
                rc.setIgnoredRoutes(routes);
            }
            this.mc.getServletContext().setAttribute(ReaderConfig.class.getName(), (Object)rc);
        }
    }

    @PreMatching
    protected static class SwaggerContainerRequestFilter
    extends ApiListingResource
    implements ContainerRequestFilter {
        protected static final String APIDOCS_LISTING_PATH_JSON = "swagger.json";
        protected static final String APIDOCS_LISTING_PATH_YAML = "swagger.yaml";
        @Context
        protected MessageContext mc;
        private Application app;

        public SwaggerContainerRequestFilter(Application app) {
            this.app = app;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            Response response = null;
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                response = this.getListingJsonResponse(this.app, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            } else if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                response = this.getListingYamlResponse(this.app, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            }
            if (response != null) {
                requestContext.abortWith(response);
            }
        }
    }

    private class ServletConfigProvider
    implements ContextProvider<ServletConfig> {
        private ServletConfigProvider() {
        }

        public ServletConfig createContext(Message message) {
            ServletConfig sc = (ServletConfig)message.get((Object)"HTTP.CONFIG");
            if (sc == null) {
                ServletContext context = (ServletContext)message.get((Object)"HTTP.CONTEXT");
                if (context != null) {
                    return new SyntheticServletConfig(context);
                }
            } else if (sc != null && sc.getInitParameter("swagger.use.path.based.config") == null) {
                return new DelegatingServletConfig(sc);
            }
            return sc;
        }
    }
}

