/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;

public abstract class AbstractSwaggerFeature
extends AbstractFeature {
    protected static final String SWAGGER_UI_RESOURCE_ROOT;
    private static final boolean SWAGGER_JAXRS_AVAILABLE;
    protected boolean scan = true;
    protected boolean runAsFilter;
    private boolean activateOnlyIfJaxrsSupported;
    private String resourcePackage;
    private String version = "1.0.0";
    private String basePath;
    private String title = "Sample REST Application";
    private String description = "The Application";
    private String contact = "users@cxf.apache.org";
    private String license = "Apache 2.0 License";
    private String licenseUrl = "http://www.apache.org/licenses/LICENSE-2.0.html";
    private String termsOfServiceUrl;
    private String filterClass;

    private static boolean isSwaggerJaxRsAvailable() {
        try {
            Class.forName("io.swagger.jaxrs.DefaultParameterExtension");
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static String checkSwaggerUiResourceRoot() {
        try {
            ClassLoader cl = AbstractSwaggerFeature.class.getClassLoader();
            if (cl instanceof URLClassLoader) {
                String resourcesRootStart = "META-INF/resources/webjars/swagger-ui/";
                for (URL url : ((URLClassLoader)cl).getURLs()) {
                    String urlStr = url.toString();
                    if (!urlStr.contains("/swagger-ui") || !urlStr.toString().endsWith(".jar")) continue;
                    urlStr = urlStr.substring(0, urlStr.length() - 4);
                    String version = urlStr.substring(urlStr.lastIndexOf("/swagger-ui") + 12);
                    return "jar:" + url.toString() + "!/" + "META-INF/resources/webjars/swagger-ui/" + version + "/";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void initialize(Server server, Bus bus) {
        if (!this.activateOnlyIfJaxrsSupported || SWAGGER_JAXRS_AVAILABLE) {
            this.calculateDefaultResourcePackage(server);
            this.calculateDefaultBasePath(server);
            this.addSwaggerResource(server, bus);
            this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
            bus.setProperty("swagger.service.description.available", (Object)"true");
        }
    }

    protected abstract void addSwaggerResource(Server var1, Bus var2);

    protected abstract void setBasePathByAddress(String var1);

    private void calculateDefaultResourcePackage(Server server) {
        if (!StringUtils.isEmpty((CharSequence)this.getResourcePackage())) {
            return;
        }
        JAXRSServiceFactoryBean serviceFactoryBean = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        List resourceInfos = serviceFactoryBean.getClassResourceInfo();
        if (resourceInfos.size() == 1) {
            this.setResourcePackage(((ClassResourceInfo)resourceInfos.get(0)).getServiceClass().getPackage().getName());
        } else {
            ArrayList<Class> serviceClasses = new ArrayList<Class>(resourceInfos.size());
            for (ClassResourceInfo cri : resourceInfos) {
                serviceClasses.add(cri.getServiceClass());
            }
            String sharedPackage = PackageUtils.getSharedPackageName(serviceClasses);
            if (!StringUtils.isEmpty((CharSequence)sharedPackage)) {
                this.setResourcePackage(sharedPackage);
            }
        }
    }

    private void calculateDefaultBasePath(Server server) {
        if (this.getBasePath() == null || this.getBasePath().length() == 0) {
            String address = server.getEndpoint().getEndpointInfo().getAddress();
            this.setBasePathByAddress(address);
        }
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public boolean isRunAsFilter() {
        return this.runAsFilter;
    }

    public void setRunAsFilter(boolean runAsFilter) {
        this.runAsFilter = runAsFilter;
    }

    public boolean isActivateOnlyIfJaxrsSupported() {
        return this.activateOnlyIfJaxrsSupported;
    }

    public void setActivateOnlyIfJaxrsSupported(boolean activateOnlyIfJaxrsSupported) {
        this.activateOnlyIfJaxrsSupported = activateOnlyIfJaxrsSupported;
    }

    static {
        SWAGGER_JAXRS_AVAILABLE = AbstractSwaggerFeature.isSwaggerJaxRsAvailable();
        SWAGGER_UI_RESOURCE_ROOT = AbstractSwaggerFeature.checkSwaggerUiResourceRoot();
    }
}

