/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.swagger.Swagger2Serializers;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class Swagger2Feature
extends AbstractSwaggerFeature {
    protected boolean dynamicBasePath;
    protected boolean replaceTags;
    protected DocumentationProvider javadocProvider;
    private String host;
    private String[] schemes;
    private boolean prettyPrint;
    private boolean scanAllResources;
    private String ignoreRoutes;
    private boolean supportSwaggerUi = true;

    @Override
    protected void addSwaggerResource(Server server, Bus bus) {
        LinkedList<Object> swaggerResources = new LinkedList<Object>();
        ApiListingResource apiListingResource = new ApiListingResource();
        swaggerResources.add(apiListingResource);
        if (SWAGGER_UI_RESOURCE_ROOT != null && this.supportSwaggerUi) {
            swaggerResources.add(new SwaggerUIService());
            bus.setProperty("swagger.service.ui.available", (Object)"true");
        }
        JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        sfb.setResourceClassesFromBeans(swaggerResources);
        List cris = sfb.getClassResourceInfo();
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.runAsFilter) {
            providers.add((Object)new SwaggerContainerRequestFilter());
        } else {
            for (ClassResourceInfo cri : cris) {
                if (ApiListingResource.class != cri.getResourceClass()) continue;
                InjectionUtils.injectContextProxies((AbstractResourceInfo)cri, (Object)apiListingResource);
            }
        }
        if (SWAGGER_UI_RESOURCE_ROOT != null && this.supportSwaggerUi) {
            providers.add(new SwaggerUIFilter());
        }
        providers.add((Object)new Swagger2Serializers(this.dynamicBasePath, this.replaceTags, this.javadocProvider, cris));
        providers.add(new ReaderConfigFilter());
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        String basePath = this.getBasePath();
        beanConfig.setBasePath(basePath);
        beanConfig.setHost(this.getHost());
        beanConfig.setSchemes(this.getSchemes());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setTermsOfServiceUrl(this.getTermsOfServiceUrl());
        beanConfig.setScan(this.isScan());
        beanConfig.setPrettyPrint(this.isPrettyPrint());
        beanConfig.setFilterClass(this.getFilterClass());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isScanAllResources() {
        return this.scanAllResources;
    }

    public void setScanAllResources(boolean scanAllResources) {
        this.scanAllResources = scanAllResources;
    }

    public String getIgnoreRoutes() {
        return this.ignoreRoutes;
    }

    public void setIgnoreRoutes(String ignoreRoutes) {
        this.ignoreRoutes = ignoreRoutes;
    }

    public void setDynamicBasePath(boolean dynamicBasePath) {
        this.dynamicBasePath = dynamicBasePath;
    }

    public void setReplaceTags(boolean replaceTags) {
        this.replaceTags = replaceTags;
    }

    public void setJavaDocPath(String javaDocPath) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPath);
    }

    public void setJavaDocPaths(String ... javaDocPaths) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPaths);
    }

    public void setJavaDocURLs(URL[] javaDocURLs) {
        this.javadocProvider = new JavaDocProvider(javaDocURLs);
    }

    @Override
    protected void setBasePathByAddress(String address) {
        if (!address.startsWith("/")) {
            URI u = URI.create(address);
            this.setBasePath(u.getPath());
            this.setHost(u.getPort() < 0 ? u.getHost() : u.getHost() + ":" + u.getPort());
        } else {
            this.setBasePath(address);
        }
    }

    @PreMatching
    protected static class SwaggerUIFilter
    implements ContainerRequestFilter {
        private static final Pattern PATTERN = Pattern.compile(".*[.]js|/css/.*|/images/.*|/lib/.*|.*ico|/fonts/.*");

        protected SwaggerUIFilter() {
        }

        public void filter(ContainerRequestContext rc) throws IOException {
            if ("GET".equals(rc.getRequest().getMethod())) {
                UriInfo ui = rc.getUriInfo();
                String path = "/" + ui.getPath();
                if (PATTERN.matcher(path).matches()) {
                    rc.setRequestUri(URI.create("api-docs" + path));
                }
            }
        }
    }

    @Path(value="api-docs")
    public static class SwaggerUIService {
        private static final String FAVICON = "favicon";

        @GET
        @Path(value="{resource:.*}")
        public Response getResource(@Context UriInfo uriInfo, @PathParam(value="resource") String resourcePath) {
            if (resourcePath.contains(FAVICON)) {
                return Response.status((int)404).build();
            }
            if (StringUtils.isEmpty((String)resourcePath) || "/".equals(resourcePath)) {
                resourcePath = "index.html";
            }
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                URL resourceURL = URI.create(AbstractSwaggerFeature.SWAGGER_UI_RESOURCE_ROOT + resourcePath).toURL();
                return Response.ok((Object)resourceURL.openStream()).build();
            }
            catch (IOException ex) {
                throw new NotFoundException((Throwable)ex);
            }
        }
    }

    protected class ReaderConfigFilter
    implements ContainerRequestFilter {
        @Context
        protected MessageContext mc;

        protected ReaderConfigFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            ServletContext servletContext = this.mc.getServletContext();
            if (servletContext != null && servletContext.getAttribute(ReaderConfig.class.getName()) == null) {
                if (this.mc.getServletConfig() != null && Boolean.valueOf(this.mc.getServletConfig().getInitParameter("scan.all.resources")).booleanValue()) {
                    this.addReaderConfig(this.mc.getServletConfig().getInitParameter("ignore.routes"));
                } else if (Swagger2Feature.this.isScanAllResources()) {
                    this.addReaderConfig(Swagger2Feature.this.getIgnoreRoutes());
                }
            }
        }

        protected void addReaderConfig(String ignoreRoutesParam) {
            DefaultReaderConfig rc = new DefaultReaderConfig();
            rc.setScanAllResources(true);
            if (ignoreRoutesParam != null) {
                LinkedHashSet<String> routes = new LinkedHashSet<String>();
                for (String route : StringUtils.split((String)ignoreRoutesParam, (String)",")) {
                    routes.add(route.trim());
                }
                rc.setIgnoredRoutes(routes);
            }
            this.mc.getServletContext().setAttribute(ReaderConfig.class.getName(), (Object)rc);
        }
    }

    @PreMatching
    protected static class SwaggerContainerRequestFilter
    extends ApiListingResource
    implements ContainerRequestFilter {
        protected static final MediaType APPLICATION_YAML_TYPE = JAXRSUtils.toMediaType((String)"application/yaml");
        protected static final String APIDOCS_LISTING_PATH = "swagger";
        protected static final String APIDOCS_LISTING_PATH_JSON = "swagger.json";
        protected static final String APIDOCS_LISTING_PATH_YAML = "swagger.yaml";
        @Context
        protected MessageContext mc;

        protected SwaggerContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            List mediaTypes = this.mc.getHttpHeaders().getAcceptableMediaTypes();
            Response response = null;
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH) && !JAXRSUtils.intersectMimeTypes((List)mediaTypes, (MediaType)MediaType.APPLICATION_JSON_TYPE).isEmpty() || ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                response = this.getListingJsonResponse(null, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            } else if (ui.getPath().endsWith(APIDOCS_LISTING_PATH) && !JAXRSUtils.intersectMimeTypes((List)mediaTypes, (MediaType)APPLICATION_YAML_TYPE).isEmpty() || ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                response = this.getListingYamlResponse(null, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            }
            if (response != null) {
                requestContext.abortWith(response);
            }
        }
    }
}

