/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.swagger.ApplicationBeanConfig;
import org.apache.cxf.jaxrs.swagger.DelegatingServletConfig;
import org.apache.cxf.jaxrs.swagger.Swagger2ApiListingResource;
import org.apache.cxf.jaxrs.swagger.Swagger2Customizer;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResolver;
import org.apache.cxf.jaxrs.swagger.SyntheticServletConfig;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class Swagger2Feature
extends AbstractSwaggerFeature {
    private static final String DEFAULT_LICENSE_VALUE = "Apache 2.0 License";
    private static final String DEFAULT_LICENSE_URL = "http://www.apache.org/licenses/LICENSE-2.0.html";
    private static final String DEFAULT_PROPS_LOCATION = "/swagger.properties";
    private static final String RESOURCE_PACKAGE_PROPERTY = "resource.package";
    private static final String TITLE_PROPERTY = "title";
    private static final String SCHEMES_PROPERTY = "schemes";
    private static final String VERSION_PROPERTY = "version";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CONTACT_PROPERTY = "contact";
    private static final String LICENSE_PROPERTY = "license";
    private static final String LICENSE_URL_PROPERTY = "license.url";
    private static final String TERMS_URL_PROPERTY = "terms.url";
    private static final String PRETTY_PRINT_PROPERTY = "pretty.print";
    private static final String FILTER_CLASS_PROPERTY = "filter.class";
    private static final String HOST_PROPERTY = "host";
    private static final String USE_PATH_CFG_PROPERTY = "use.path.based.config";
    private static final String SUPPORT_UI_PROPERTY = "support.swagger.ui";
    private boolean scan;
    private boolean scanAllResources;
    private String ignoreRoutes;
    private Boolean supportSwaggerUi;
    private String swaggerUiVersion;
    private String swaggerUiMavenGroupAndArtifact;
    private Map<String, String> swaggerUiMediaTypes;
    private boolean dynamicBasePath;
    private Map<String, SecuritySchemeDefinition> securityDefinitions;
    private Swagger2Customizer customizer;
    private String host;
    private String[] schemes;
    private Boolean prettyPrint;
    private Boolean usePathBasedConfig;
    private String propertiesLocation = "/swagger.properties";

    @Override
    protected void calculateDefaultBasePath(Server server) {
        this.dynamicBasePath = true;
        super.calculateDefaultBasePath(server);
    }

    @Override
    protected void addSwaggerResource(Server server, Bus bus) {
        String swaggerUiRoot;
        Properties swaggerProps;
        JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        ServerProviderFactory factory = (ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName());
        ApplicationInfo appInfo = null;
        if (!this.isScan() && (appInfo = factory.getApplicationProvider()) == null) {
            HashSet serviceClasses = new HashSet();
            for (ClassResourceInfo cri : sfb.getClassResourceInfo()) {
                serviceClasses.add(cri.getServiceClass());
            }
            appInfo = new ApplicationInfo((Application)new DefaultApplication(serviceClasses), bus);
            server.getEndpoint().put((Object)Application.class.getName(), (Object)appInfo);
        }
        LinkedList<Object> swaggerResources = new LinkedList<Object>();
        if (this.customizer == null) {
            this.customizer = new Swagger2Customizer();
        }
        Swagger2ApiListingResource apiListingResource = new Swagger2ApiListingResource(this.customizer);
        swaggerResources.add((Object)apiListingResource);
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.isRunAsFilter()) {
            providers.add((Object)new SwaggerContainerRequestFilter(appInfo == null ? null : (Application)appInfo.getProvider(), this.customizer));
        }
        if (this.checkSupportSwaggerUiProp(swaggerProps = this.getSwaggerProperties(bus)) && (swaggerUiRoot = SwaggerUiResolver.findSwaggerUiRoot(this.swaggerUiMavenGroupAndArtifact, this.swaggerUiVersion)) != null) {
            SwaggerUIService swaggerUiService = new SwaggerUIService(swaggerUiRoot, this.swaggerUiMediaTypes);
            if (!this.isRunAsFilter()) {
                swaggerResources.add(swaggerUiService);
            } else {
                providers.add(new SwaggerUIServiceFilter(swaggerUiService));
            }
            providers.add(new SwaggerUIResourceFilter());
            bus.setProperty("swagger.service.ui.available", (Object)"true");
        }
        sfb.setResourceClassesFromBeans(swaggerResources);
        List cris = sfb.getClassResourceInfo();
        if (!this.isRunAsFilter()) {
            for (ClassResourceInfo cri : cris) {
                if (!ApiListingResource.class.isAssignableFrom(cri.getResourceClass())) continue;
                InjectionUtils.injectContextProxies((AbstractResourceInfo)cri, (Object)((Object)apiListingResource));
            }
        }
        this.customizer.setClassResourceInfos(cris);
        this.customizer.setDynamicBasePath(this.dynamicBasePath);
        BeanConfig beanConfig = appInfo == null ? new BeanConfig() : new ApplicationBeanConfig((Application)appInfo.getProvider());
        this.initBeanConfig(beanConfig, swaggerProps);
        Swagger swagger = beanConfig.getSwagger();
        if (swagger != null && this.securityDefinitions != null) {
            swagger.setSecurityDefinitions(this.securityDefinitions);
        }
        this.customizer.setBeanConfig(beanConfig);
        providers.add(new ReaderConfigFilter());
        if (beanConfig.isUsePathBasedConfig()) {
            providers.add(new ServletConfigProvider());
        }
        factory.setUserProviders(providers);
    }

    protected boolean checkSupportSwaggerUiProp(Properties props) {
        Boolean theSupportSwaggerUI = this.supportSwaggerUi;
        if (theSupportSwaggerUI == null && props != null && props.containsKey(SUPPORT_UI_PROPERTY)) {
            theSupportSwaggerUI = PropertyUtils.isTrue((Object)props.get(SUPPORT_UI_PROPERTY));
        }
        if (theSupportSwaggerUI == null) {
            theSupportSwaggerUI = true;
        }
        return theSupportSwaggerUI;
    }

    protected Properties getSwaggerProperties(Bus bus) {
        InputStream is = ResourceUtils.getClasspathResourceStream((String)this.propertiesLocation, AbstractSwaggerFeature.class, (Bus)bus);
        Properties props = null;
        if (is != null) {
            props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException ex) {
                props = null;
            }
        }
        return props;
    }

    protected void initBeanConfig(BeanConfig beanConfig, Properties props) {
        String theResourcePackage = this.getResourcePackage();
        if (theResourcePackage == null && props != null) {
            theResourcePackage = props.getProperty(RESOURCE_PACKAGE_PROPERTY);
        }
        beanConfig.setResourcePackage(theResourcePackage);
        Boolean theUsePathBasedConfig = this.isUsePathBasedConfig();
        if (theUsePathBasedConfig == null && props != null) {
            theUsePathBasedConfig = PropertyUtils.isTrue((Object)props.get(USE_PATH_CFG_PROPERTY));
        }
        if (theUsePathBasedConfig == null) {
            theUsePathBasedConfig = false;
        }
        beanConfig.setUsePathBasedConfig(theUsePathBasedConfig.booleanValue());
        String theVersion = this.getVersion();
        if (theVersion == null && props != null) {
            theVersion = props.getProperty(VERSION_PROPERTY);
        }
        beanConfig.setVersion(theVersion);
        String theHost = this.getHost();
        if (theHost == null && props != null) {
            theHost = props.getProperty(HOST_PROPERTY);
        }
        beanConfig.setHost(theHost);
        String[] theSchemes = this.getSchemes();
        if (theSchemes == null && props != null && props.containsKey(SCHEMES_PROPERTY)) {
            theSchemes = props.getProperty(SCHEMES_PROPERTY).split(",");
        }
        beanConfig.setSchemes(theSchemes);
        String theTitle = this.getTitle();
        if (theTitle == null && props != null) {
            theTitle = props.getProperty(TITLE_PROPERTY);
        }
        beanConfig.setTitle(theTitle);
        String theDescription = this.getDescription();
        if (theDescription == null && props != null) {
            theDescription = props.getProperty(DESCRIPTION_PROPERTY);
        }
        beanConfig.setDescription(theDescription);
        String theContact = this.getContact();
        if (theContact == null && props != null) {
            theContact = props.getProperty(CONTACT_PROPERTY);
        }
        beanConfig.setContact(theContact);
        String theLicense = this.getLicense();
        if (theLicense == null && !this.licenseWasSet) {
            if (props != null) {
                theLicense = props.getProperty(LICENSE_PROPERTY);
                if (theLicense != null && theLicense.isEmpty()) {
                    theLicense = null;
                }
            } else {
                theLicense = DEFAULT_LICENSE_VALUE;
            }
        }
        beanConfig.setLicense(theLicense);
        String theLicenseUrl = this.getLicenseUrl();
        if (theLicenseUrl == null && props != null) {
            theLicenseUrl = props.getProperty(LICENSE_URL_PROPERTY);
        }
        if (theLicenseUrl == null && DEFAULT_LICENSE_VALUE.equals(theLicense)) {
            theLicenseUrl = DEFAULT_LICENSE_URL;
        }
        beanConfig.setLicenseUrl(theLicenseUrl);
        String theTermsUrl = this.getTermsOfServiceUrl();
        if (theTermsUrl == null && props != null) {
            theTermsUrl = props.getProperty(TERMS_URL_PROPERTY);
        }
        beanConfig.setTermsOfServiceUrl(theTermsUrl);
        Boolean thePrettyPrint = this.isPrettyPrint();
        if (thePrettyPrint == null && props != null) {
            thePrettyPrint = PropertyUtils.isTrue((Object)props.get(PRETTY_PRINT_PROPERTY));
        }
        if (thePrettyPrint == null) {
            thePrettyPrint = false;
        }
        beanConfig.setPrettyPrint(thePrettyPrint.booleanValue());
        String theFilterClass = this.getFilterClass();
        if (theFilterClass == null && props != null) {
            theFilterClass = props.getProperty(FILTER_CLASS_PROPERTY);
        }
        beanConfig.setFilterClass(theFilterClass);
        beanConfig.setScan(this.isScan());
        beanConfig.setBasePath(this.getBasePath());
    }

    public Boolean isUsePathBasedConfig() {
        return this.usePathBasedConfig;
    }

    public void setUsePathBasedConfig(Boolean usePathBasedConfig) {
        this.usePathBasedConfig = usePathBasedConfig;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public Boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Swagger2Customizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(Swagger2Customizer customizer) {
        this.customizer = customizer;
    }

    public boolean isScanAllResources() {
        return this.scanAllResources;
    }

    public void setScanAllResources(boolean scanAllResources) {
        this.scanAllResources = scanAllResources;
    }

    public String getIgnoreRoutes() {
        return this.ignoreRoutes;
    }

    public void setIgnoreRoutes(String ignoreRoutes) {
        this.ignoreRoutes = ignoreRoutes;
    }

    @Override
    protected void setBasePathByAddress(String address) {
        if (!address.startsWith("/")) {
            URI u = URI.create(address);
            this.setBasePath(u.getPath());
            if (this.getHost() == null) {
                this.setHost(u.getPort() < 0 ? u.getHost() : u.getHost() + ":" + u.getPort());
            }
        } else {
            this.setBasePath(address);
        }
    }

    public void setSwaggerUiMavenGroupAndArtifact(String swaggerUiMavenGroupAndArtifact) {
        this.swaggerUiMavenGroupAndArtifact = swaggerUiMavenGroupAndArtifact;
    }

    public void setSwaggerUiVersion(String swaggerUiVersion) {
        this.swaggerUiVersion = swaggerUiVersion;
    }

    public void setSupportSwaggerUi(boolean supportSwaggerUi) {
        this.supportSwaggerUi = supportSwaggerUi;
    }

    public void setSwaggerUiMediaTypes(Map<String, String> swaggerUiMediaTypes) {
        this.swaggerUiMediaTypes = swaggerUiMediaTypes;
    }

    public void setSecurityDefinitions(Map<String, SecuritySchemeDefinition> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public String getPropertiesLocation() {
        return this.propertiesLocation;
    }

    public void setPropertiesLocation(String propertiesLocation) {
        this.propertiesLocation = propertiesLocation;
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    protected static class DefaultApplication
    extends Application {
        Set<Class<?>> serviceClasses;

        DefaultApplication(Set<Class<?>> serviceClasses) {
            this.serviceClasses = serviceClasses;
        }

        public Set<Class<?>> getClasses() {
            return this.serviceClasses;
        }
    }

    @PreMatching
    @Priority(value=5001)
    protected static class SwaggerUIServiceFilter
    implements ContainerRequestFilter {
        private SwaggerUIService uiService;

        SwaggerUIServiceFilter(SwaggerUIService uiService) {
            this.uiService = uiService;
        }

        public void filter(ContainerRequestContext rc) throws IOException {
            UriInfo ui;
            String path;
            int uiPathIndex;
            if ("GET".equals(rc.getRequest().getMethod()) && (uiPathIndex = (path = (ui = rc.getUriInfo()).getPath()).lastIndexOf("api-docs")) >= 0) {
                String resourcePath = uiPathIndex + 8 < path.length() ? path.substring(uiPathIndex + 8) : "";
                rc.abortWith(this.uiService.getResource(ui, resourcePath));
            }
        }
    }

    @PreMatching
    @Priority(value=5000)
    protected static class SwaggerUIResourceFilter
    implements ContainerRequestFilter {
        private static final Pattern PATTERN = Pattern.compile(".*[.]js|.*[.]gz|.*[.]map|oauth2*[.]html|.*[.]png|.*[.]css|.*[.]ico|/css/.*|/images/.*|/lib/.*|/fonts/.*");

        protected SwaggerUIResourceFilter() {
        }

        public void filter(ContainerRequestContext rc) throws IOException {
            if ("GET".equals(rc.getRequest().getMethod())) {
                UriInfo ui = rc.getUriInfo();
                String path = "/" + ui.getPath();
                if (PATTERN.matcher(path).matches()) {
                    rc.setRequestUri(URI.create("api-docs" + path));
                }
            }
        }
    }

    @Path(value="api-docs")
    public static class SwaggerUIService {
        private static final String FAVICON = "favicon";
        private static final Map<String, String> DEFAULT_MEDIA_TYPES = new HashMap<String, String>();
        private final String swaggerUiRoot;
        private final Map<String, String> mediaTypes;

        public SwaggerUIService(String swaggerUiRoot, Map<String, String> mediaTypes) {
            this.swaggerUiRoot = swaggerUiRoot;
            this.mediaTypes = mediaTypes;
        }

        @GET
        @Path(value="{resource:.*}")
        public Response getResource(@Context UriInfo uriInfo, @PathParam(value="resource") String resourcePath) {
            if (StringUtils.isEmpty((String)resourcePath) || "/".equals(resourcePath)) {
                resourcePath = "index.html";
            }
            if (resourcePath.contains(FAVICON)) {
                return Response.status((int)404).build();
            }
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                URL resourceURL = URI.create(this.swaggerUiRoot + resourcePath).toURL();
                String mediaType = null;
                int ind = resourcePath.lastIndexOf(46);
                if (ind != -1 && ind < resourcePath.length()) {
                    String resourceExt = resourcePath.substring(ind + 1);
                    mediaType = this.mediaTypes != null && this.mediaTypes.containsKey(resourceExt) ? this.mediaTypes.get(resourceExt) : DEFAULT_MEDIA_TYPES.get(resourceExt);
                }
                Response.ResponseBuilder rb = Response.ok((Object)resourceURL.openStream());
                if (mediaType != null) {
                    rb.type(mediaType);
                }
                return rb.build();
            }
            catch (IOException ex) {
                throw new NotFoundException((Throwable)ex);
            }
        }

        static {
            DEFAULT_MEDIA_TYPES.put("html", "text/html");
            DEFAULT_MEDIA_TYPES.put("png", "image/png");
            DEFAULT_MEDIA_TYPES.put("gif", "image/gif");
            DEFAULT_MEDIA_TYPES.put("css", "text/css");
            DEFAULT_MEDIA_TYPES.put("js", "application/javascript");
            DEFAULT_MEDIA_TYPES.put("eot", "application/vnd.ms-fontobject");
            DEFAULT_MEDIA_TYPES.put("ttf", "application/font-sfnt");
            DEFAULT_MEDIA_TYPES.put("svg", "image/svg+xml");
            DEFAULT_MEDIA_TYPES.put("woff", "application/font-woff");
            DEFAULT_MEDIA_TYPES.put("woff2", "application/font-woff2");
        }
    }

    protected class ReaderConfigFilter
    implements ContainerRequestFilter {
        @Context
        protected MessageContext mc;

        protected ReaderConfigFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            ServletContext servletContext = this.mc.getServletContext();
            if (servletContext != null && servletContext.getAttribute(ReaderConfig.class.getName()) == null) {
                if (this.mc.getServletConfig() != null && Boolean.valueOf(this.mc.getServletConfig().getInitParameter("scan.all.resources")).booleanValue()) {
                    this.addReaderConfig(this.mc.getServletConfig().getInitParameter("ignore.routes"));
                } else if (Swagger2Feature.this.isScanAllResources()) {
                    this.addReaderConfig(Swagger2Feature.this.getIgnoreRoutes());
                }
            }
        }

        protected void addReaderConfig(String ignoreRoutesParam) {
            DefaultReaderConfig rc = new DefaultReaderConfig();
            rc.setScanAllResources(true);
            if (ignoreRoutesParam != null) {
                LinkedHashSet<String> routes = new LinkedHashSet<String>();
                for (String route : StringUtils.split((String)ignoreRoutesParam, (String)",")) {
                    routes.add(route.trim());
                }
                rc.setIgnoredRoutes(routes);
            }
            this.mc.getServletContext().setAttribute(ReaderConfig.class.getName(), (Object)rc);
        }
    }

    @PreMatching
    protected static class SwaggerContainerRequestFilter
    extends Swagger2ApiListingResource
    implements ContainerRequestFilter {
        protected static final String APIDOCS_LISTING_PATH_JSON = "swagger.json";
        protected static final String APIDOCS_LISTING_PATH_YAML = "swagger.yaml";
        @Context
        protected MessageContext mc;
        private Application app;

        public SwaggerContainerRequestFilter(Application app, Swagger2Customizer customizer) {
            super(customizer);
            this.app = app;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            Response response = null;
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                response = this.getListingJsonResponse(this.app, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            } else if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                response = this.getListingYamlResponse(this.app, this.mc.getServletContext(), this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
            }
            if (response != null) {
                requestContext.abortWith(response);
            }
        }
    }

    private class ServletConfigProvider
    implements ContextProvider<ServletConfig> {
        private ServletConfigProvider() {
        }

        public ServletConfig createContext(Message message) {
            ServletConfig sc = (ServletConfig)message.get((Object)"HTTP.CONFIG");
            if (sc == null) {
                ServletContext context = (ServletContext)message.get((Object)"HTTP.CONTEXT");
                if (context != null) {
                    return new SyntheticServletConfig(context);
                }
            } else if (sc != null && sc.getInitParameter("swagger.use.path.based.config") == null) {
                return new DelegatingServletConfig(sc);
            }
            return sc;
        }
    }
}

