/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

public class SwaggerUiResolver {
    protected static final String UI_RESOURCES_ROOT_START = "META-INF/resources/webjars/swagger-ui/";
    private final ClassLoader cl;

    public SwaggerUiResolver(ClassLoader cl) {
        this.cl = cl;
    }

    public String findSwaggerUiRootInternal(String swaggerUiMavenGroupAndArtifact, String swaggerUiVersion) {
        try {
            if (this.cl instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)this.cl).getURLs()) {
                    String root = SwaggerUiResolver.checkUiRoot(url.toString(), swaggerUiVersion);
                    if (root == null) continue;
                    return root;
                }
            }
            Enumeration<URL> urls = this.cl.getResources(UI_RESOURCES_ROOT_START);
            while (urls.hasMoreElements()) {
                String urlStr = urls.nextElement().toString().replace(UI_RESOURCES_ROOT_START, "");
                String root = SwaggerUiResolver.checkUiRoot(urlStr, swaggerUiVersion);
                if (root == null) continue;
                return root;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected static String checkUiRoot(String urlStr, String swaggerUiVersion) {
        boolean urlEndsWithJarSep;
        int swaggerUiIndex = urlStr.lastIndexOf("/swagger-ui-");
        if (swaggerUiIndex != -1 && ((urlEndsWithJarSep = urlStr.endsWith(".jar!/")) || urlStr.endsWith(".jar"))) {
            int offset = urlEndsWithJarSep ? 6 : 4;
            String version = urlStr.substring(swaggerUiIndex + 12, urlStr.length() - offset);
            if (swaggerUiVersion != null && !swaggerUiVersion.equals(version)) {
                return null;
            }
            if (!urlEndsWithJarSep) {
                urlStr = "jar:" + urlStr + "!/";
            }
            return urlStr + UI_RESOURCES_ROOT_START + version + "/";
        }
        return null;
    }
}

