/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.swagger.SwaggerUiResourceLocator;

@Path(value="api-docs")
public class SwaggerUiService {
    private static final String FAVICON = "favicon";
    private static final Map<String, String> DEFAULT_MEDIA_TYPES = new HashMap<String, String>();
    private final SwaggerUiResourceLocator locator;
    private final Map<String, String> mediaTypes;

    public SwaggerUiService(SwaggerUiResourceLocator locator, Map<String, String> mediaTypes) {
        this.locator = locator;
        this.mediaTypes = mediaTypes;
    }

    @GET
    @Path(value="{resource:.*}")
    public Response getResource(@Context UriInfo uriInfo, @PathParam(value="resource") String resourcePath) {
        if (resourcePath.contains(FAVICON)) {
            return Response.status((int)404).build();
        }
        try {
            URL resourceURL = this.locator.locate(resourcePath);
            String mediaType = null;
            int ind = resourcePath.lastIndexOf(46);
            if (ind != -1 && ind < resourcePath.length()) {
                String resourceExt = resourcePath.substring(ind + 1);
                mediaType = this.mediaTypes != null && this.mediaTypes.containsKey(resourceExt) ? this.mediaTypes.get(resourceExt) : DEFAULT_MEDIA_TYPES.get(resourceExt);
            }
            Response.ResponseBuilder rb = Response.ok((Object)resourceURL.openStream());
            if (mediaType != null) {
                rb.type(mediaType);
            }
            return rb.build();
        }
        catch (IOException ex) {
            throw new NotFoundException((Throwable)ex);
        }
    }

    static {
        DEFAULT_MEDIA_TYPES.put("html", "text/html");
        DEFAULT_MEDIA_TYPES.put("png", "image/png");
        DEFAULT_MEDIA_TYPES.put("gif", "image/gif");
        DEFAULT_MEDIA_TYPES.put("css", "text/css");
        DEFAULT_MEDIA_TYPES.put("js", "application/javascript");
        DEFAULT_MEDIA_TYPES.put("eot", "application/vnd.ms-fontobject");
        DEFAULT_MEDIA_TYPES.put("ttf", "application/font-sfnt");
        DEFAULT_MEDIA_TYPES.put("svg", "image/svg+xml");
        DEFAULT_MEDIA_TYPES.put("woff", "application/font-woff");
        DEFAULT_MEDIA_TYPES.put("woff2", "application/font-woff2");
    }
}

