/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model.wadl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.jaxb.JAXBBeanInfo;
import org.apache.cxf.common.jaxb.JAXBContextProxy;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.XmlSchemaPrimitiveUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.ext.Oneway;
import org.apache.cxf.jaxrs.ext.ResponseStatus;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.xml.XMLName;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ResourceTypes;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.apache.cxf.jaxrs.model.wadl.Descriptions;
import org.apache.cxf.jaxrs.model.wadl.DocumentationProvider;
import org.apache.cxf.jaxrs.model.wadl.ElementQNameResolver;
import org.apache.cxf.jaxrs.model.wadl.JavaDocProvider;
import org.apache.cxf.jaxrs.model.wadl.ResourceIdGenerator;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class WadlGenerator
implements ContainerRequestFilter {
    public static final String WADL_QUERY = "_wadl";
    public static final MediaType WADL_TYPE = JAXRSUtils.toMediaType((String)"application/vnd.sun.wadl+xml");
    public static final String WADL_NS = "http://wadl.dev.java.net/2009/02";
    private static final Logger LOG = LogUtils.getL7dLogger(WadlGenerator.class);
    private static final String XLS_NS = "http://www.w3.org/1999/XSL/Transform";
    private static final String JAXB_DEFAULT_NAMESPACE = "##default";
    private static final String JAXB_DEFAULT_NAME = "##default";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String DEFAULT_NS_PREFIX = "prefix";
    private static final Map<ParameterType, Class<? extends Annotation>> PARAMETER_TYPE_MAP = new HashMap<ParameterType, Class<? extends Annotation>>();
    private String wadlNamespace;
    private boolean ignoreMessageWriters = true;
    private boolean singleResourceMultipleMethods = true;
    private boolean useSingleSlashResource;
    private boolean ignoreForwardSlash;
    private boolean ignoreRequests;
    private boolean linkAnyMediaTypeToXmlSchema;
    private boolean useJaxbContextForQnames = true;
    private boolean supportCollections = true;
    private boolean supportJaxbXmlType = true;
    private boolean supportJaxbSubstitutions = true;
    private boolean ignoreOverloadedMethods;
    private boolean checkAbsolutePathSlash;
    private boolean keepRelativeDocLinks;
    private List<String> externalSchemasCache;
    private List<URI> externalSchemaLinks;
    private Map<String, List<String>> externalQnamesMap;
    private ConcurrentHashMap<String, String> docLocationMap = new ConcurrentHashMap();
    private ElementQNameResolver resolver;
    private List<String> privateAddresses;
    private String applicationTitle;
    private String nsPrefix = "prefix";
    private MediaType defaultWadlResponseMediaType = MediaType.APPLICATION_XML_TYPE;
    private MediaType defaultRepMediaType = MediaType.WILDCARD_TYPE;
    private String stylesheetReference;
    private boolean applyStylesheetLocally;
    private Bus bus;
    private List<DocumentationProvider> docProviders = new LinkedList<DocumentationProvider>();
    private ResourceIdGenerator idGenerator;

    public WadlGenerator() {
    }

    public WadlGenerator(Bus bus) {
        this.bus = bus;
    }

    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        this.doFilter(context, m);
    }

    protected void doFilter(ContainerRequestContext context, Message m) {
        if (!"GET".equals(m.get((Object)"org.apache.cxf.request.method"))) {
            return;
        }
        UriInfo ui = context.getUriInfo();
        if (!ui.getQueryParameters().containsKey((Object)WADL_QUERY)) {
            if (this.stylesheetReference != null || !this.docLocationMap.isEmpty()) {
                String path = ui.getPath(false);
                if (path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (this.stylesheetReference != null && path.endsWith(".xsl") || this.docLocationMap.containsKey(path)) {
                    context.abortWith(this.getExistingResource(m, ui, path));
                }
            }
            return;
        }
        if (this.ignoreRequests) {
            context.abortWith(Response.status((int)404).build());
            return;
        }
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        List accepts = headers.getAcceptableMediaTypes();
        MediaType type = accepts.contains(WADL_TYPE) ? WADL_TYPE : (accepts.contains(MediaType.APPLICATION_JSON_TYPE) ? MediaType.APPLICATION_JSON_TYPE : this.defaultWadlResponseMediaType);
        Response response = this.getExistingWadl(m, ui, type);
        if (response != null) {
            context.abortWith(response);
            return;
        }
        boolean isJson = this.isJson(type);
        StringBuilder sbMain = this.generateWADL(this.getBaseURI(m, ui), this.getResourcesList(m, ui), isJson, m, ui);
        m.getExchange().put((Object)"ignore.message.writers", (Object)(!isJson && this.ignoreMessageWriters ? 1 : 0));
        Response r = Response.ok().type(type).entity(this.createResponseEntity(m, ui, sbMain.toString(), isJson)).build();
        context.abortWith(r);
    }

    private boolean isJson(MediaType mt) {
        return mt == MediaType.APPLICATION_JSON_TYPE;
    }

    private String getStylesheetInstructionData(Message m, UriInfo ui) {
        String theStylesheetReference = this.stylesheetReference;
        if (!this.keepRelativeDocLinks) {
            theStylesheetReference = UriBuilder.fromUri((String)this.getBaseURI(m, ui)).path(theStylesheetReference).build(new Object[0]).toString();
        }
        return "type=\"text/xsl\" href=\"" + theStylesheetReference + "\"";
    }

    public StringBuilder generateWADL(String baseURI, List<ClassResourceInfo> cris, boolean isJson, Message m, UriInfo ui) {
        SchemaWriter schemaWriter;
        StringBuilder sbMain = new StringBuilder();
        if (!isJson && this.stylesheetReference != null && !this.applyStylesheetLocally) {
            sbMain.append("<?xml-stylesheet " + this.getStylesheetInstructionData(m, ui) + "?>");
        }
        sbMain.append("<application");
        if (!isJson) {
            sbMain.append(" xmlns=\"").append(this.getNamespace()).append("\" xmlns:xs=\"").append("http://www.w3.org/2001/XMLSchema").append("\"");
        }
        StringBuilder sbGrammars = new StringBuilder();
        sbGrammars.append("<grammars>");
        StringBuilder sbResources = new StringBuilder();
        sbResources.append("<resources base=\"").append(baseURI).append("\">");
        MessageBodyWriter jaxbWriter = m != null && this.useJaxbContextForQnames ? ServerProviderFactory.getInstance((Message)m).getRegisteredJaxbWriter() : null;
        ResourceTypes resourceTypes = ResourceUtils.getAllRequestResponseTypes(cris, (boolean)this.useJaxbContextForQnames, (MessageBodyWriter)jaxbWriter);
        this.checkXmlSeeAlso(resourceTypes);
        Set<Class<?>> allTypes = resourceTypes.getAllTypes().keySet();
        JAXBContext jaxbContext = null;
        if (this.useJaxbContextForQnames && !allTypes.isEmpty() && (jaxbContext = ResourceUtils.createJaxbContext(new HashSet(allTypes), null, null)) == null) {
            LOG.warning("JAXB Context is null: possibly due to one of input classes being not accepted");
        }
        ElementQNameResolver qnameResolver = (schemaWriter = this.createSchemaWriter(resourceTypes, jaxbContext, ui)) == null ? null : this.createElementQNameResolver(jaxbContext);
        IdentityHashMap clsMap = new IdentityHashMap();
        LinkedHashSet<ClassResourceInfo> visitedResources = new LinkedHashSet<ClassResourceInfo>();
        for (ClassResourceInfo cri : cris) {
            this.startResourceTag(sbResources, cri, cri.getURITemplate().getValue());
            Annotation description = AnnotationUtils.getClassAnnotation((Class)cri.getServiceClass(), Description.class);
            if (description == null) {
                description = AnnotationUtils.getClassAnnotation((Class)cri.getServiceClass(), Descriptions.class);
            }
            if (description != null) {
                this.handleDocs(new Annotation[]{description}, sbResources, "resource", true, isJson);
            } else {
                this.handleClassJavaDocs(cri, sbResources);
            }
            this.handleResource(sbResources, allTypes, qnameResolver, clsMap, cri, visitedResources, isJson);
            sbResources.append("</resource>");
        }
        sbResources.append("</resources>");
        this.handleGrammars(sbMain, sbGrammars, schemaWriter, clsMap);
        sbGrammars.append("</grammars>");
        sbMain.append(">");
        this.handleApplicationDocs(sbMain);
        sbMain.append(sbGrammars.toString());
        sbMain.append(sbResources.toString());
        sbMain.append("</application>");
        return sbMain;
    }

    private Object createResponseEntity(Message m, UriInfo ui, String entity, boolean isJson) {
        try {
            if (!isJson) {
                if (this.stylesheetReference != null && this.applyStylesheetLocally) {
                    return this.transformLocally(m, ui, new StreamSource(new StringReader(entity)));
                }
                return entity;
            }
            return StaxUtils.read((Reader)new StringReader(entity));
        }
        catch (Exception ex) {
            throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
        }
    }

    private String getBaseURI(Message m, UriInfo ui) {
        EndpointInfo ei = m.getExchange().getEndpoint().getEndpointInfo();
        String publishedEndpointUrl = (String)ei.getProperty("publishedEndpointUrl");
        if (publishedEndpointUrl == null) {
            return ui.getBaseUri().toString();
        }
        return publishedEndpointUrl;
    }

    protected void handleGrammars(StringBuilder sbApp, StringBuilder sbGrammars, SchemaWriter writer, Map<Class<?>, QName> clsMap) {
        if (writer == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (QName qName : clsMap.values()) {
            map.put(qName.getPrefix(), qName.getNamespaceURI());
        }
        for (Map.Entry entry : map.entrySet()) {
            sbApp.append(" xmlns:").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        writer.write(sbGrammars);
    }

    protected void handleResource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, ClassResourceInfo cri, Set<ClassResourceInfo> visitedResources, boolean isJson) {
        visitedResources.add(cri);
        Map<Parameter, Object> classParams = this.getClassParameters(cri);
        List<OperationResourceInfo> sortedOps = this.sortOperationsByPath(cri.getMethodDispatcher().getOperationResourceInfos());
        boolean resourceTagOpened = false;
        for (int i = 0; i < sortedOps.size(); ++i) {
            OperationResourceInfo ori = sortedOps.get(i);
            if (i > 0 && this.ignoreOverloadedMethods && ori.getMethodToInvoke().getName().equals(sortedOps.get(i - 1).getMethodToInvoke().getName())) continue;
            if (ori.getHttpMethod() == null) {
                Class<?> cls = this.getMethod(ori).getReturnType();
                ClassResourceInfo subcri = cri.findResource(cls, cls);
                if (subcri != null && !visitedResources.contains(subcri)) {
                    this.startResourceTag(sb, subcri, ori.getURITemplate().getValue());
                    this.handleDocs(subcri.getServiceClass().getAnnotations(), sb, "resource", true, isJson);
                    this.handlePathAndMatrixParams(sb, ori, isJson);
                    this.handleResource(sb, jaxbTypes, qnameResolver, clsMap, subcri, visitedResources, isJson);
                    sb.append("</resource>");
                    continue;
                }
                this.handleDynamicSubresource(sb, jaxbTypes, qnameResolver, clsMap, ori, subcri, isJson);
                continue;
            }
            OperationResourceInfo nextOp = i + 1 < sortedOps.size() ? sortedOps.get(i + 1) : null;
            resourceTagOpened = this.handleOperation(sb, jaxbTypes, qnameResolver, clsMap, ori, classParams, nextOp, resourceTagOpened, isJson, i);
        }
    }

    private Map<Parameter, Object> getClassParameters(ClassResourceInfo cri) {
        LinkedHashMap<Parameter, Object> classParams = new LinkedHashMap<Parameter, Object>();
        List paramMethods = cri.getParameterMethods();
        for (Method m : paramMethods) {
            classParams.put(ResourceUtils.getParameter((int)0, (Annotation[])m.getAnnotations(), m.getParameterTypes()[0]), m);
        }
        List fieldParams = cri.getParameterFields();
        for (Field f : fieldParams) {
            classParams.put(ResourceUtils.getParameter((int)0, (Annotation[])f.getAnnotations(), f.getType()), f);
        }
        return classParams;
    }

    protected void startResourceTag(StringBuilder sb, ClassResourceInfo cri, String path) {
        sb.append("<resource path=\"").append(this.getPath(path)).append("\"");
        if (this.idGenerator != null) {
            String id = this.idGenerator.getClassResourceId(cri);
            sb.append(" id=\"").append(id).append("\"");
        }
        sb.append(">");
    }

    protected String getPath(String path) {
        String thePath = null;
        thePath = this.ignoreForwardSlash && path.startsWith("/") && path.length() > 0 ? path.substring(1) : path;
        return this.xmlEncodeIfNeeded(thePath);
    }

    private void checkXmlSeeAlso(ResourceTypes resourceTypes) {
        if (!this.useJaxbContextForQnames) {
            return;
        }
        LinkedList extraClasses = new LinkedList();
        for (Class cls : resourceTypes.getAllTypes().keySet()) {
            XmlSeeAlso seeAlsoAnn;
            if (this.isXmlRoot(cls) && !Modifier.isAbstract(cls.getModifiers()) || (seeAlsoAnn = cls.getAnnotation(XmlSeeAlso.class)) == null) continue;
            List seeAlsoList = CastUtils.cast(Arrays.asList(seeAlsoAnn.value()));
            if (this.supportJaxbSubstitutions) {
                for (Class seeAlsoCls : seeAlsoList) {
                    resourceTypes.getSubstitutions().put(seeAlsoCls, cls);
                }
            }
            extraClasses.addAll(seeAlsoList);
        }
        for (Class cls : extraClasses) {
            resourceTypes.getAllTypes().put(cls, cls);
        }
    }

    private String xmlEncodeIfNeeded(String value) {
        StringBuilder builder = new StringBuilder(value.length());
        boolean change = false;
        for (int x = 0; x < value.length(); ++x) {
            char ch = value.charAt(x);
            String ap = null;
            switch (ch) {
                case '\"': {
                    ap = "&quot;";
                    break;
                }
                case '\'': {
                    ap = "&apos;";
                    break;
                }
                case '<': {
                    ap = "&lt;";
                    break;
                }
                case '>': {
                    ap = "&gt;";
                    break;
                }
                case '&': {
                    ap = "&amp;";
                    break;
                }
                default: {
                    ap = null;
                }
            }
            if (ap != null) {
                change = true;
                builder.append(ap);
                continue;
            }
            builder.append(ch);
        }
        return change ? builder.toString() : value;
    }

    protected void startMethodTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("<method name=\"").append(ori.getHttpMethod()).append("\"");
        if (this.idGenerator != null) {
            String id = this.idGenerator.getMethodResourceId(ori);
            sb.append(" id=\"").append(id).append("\"");
        }
        sb.append(">");
    }

    protected void endMethodTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("</method>");
    }

    protected void startMethodRequestTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("<request>");
    }

    protected void startMethodResponseTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("<response");
    }

    protected void endMethodRequestTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("</request>");
    }

    protected void endMethodResponseTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("</response>");
    }

    protected void startResourceTag(StringBuilder sb, OperationResourceInfo ori, String path) {
        sb.append("<resource path=\"").append(path).append("\">");
    }

    protected void endResourceTag(StringBuilder sb, OperationResourceInfo ori) {
        sb.append("</resource>");
    }

    protected boolean handleOperation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Map<Parameter, Object> classParams, OperationResourceInfo nextOp, boolean resourceTagOpened, boolean isJson, int index) {
        Annotation[] anns = this.getMethod(ori).getAnnotations();
        boolean samePathOperationFollows = this.singleResourceMultipleMethods && this.compareOperations(ori, nextOp);
        String path = ori.getURITemplate().getValue();
        if (!resourceTagOpened && this.openResource(path)) {
            String parentPath;
            resourceTagOpened = true;
            URITemplate template = ori.getClassResourceInfo().getURITemplate();
            if (template != null && (parentPath = template.getValue()).endsWith("/") && path.startsWith("/") && path.length() > 1) {
                path = path.substring(1);
            }
            this.startResourceTag(sb, ori, this.getPath(path));
            this.handleDocs(anns, sb, "resource", false, isJson);
            this.handlePathAndMatrixClassParams(ori, sb, classParams, isJson);
            this.handlePathAndMatrixParams(sb, ori, isJson);
        } else if (index == 0) {
            this.handlePathAndMatrixClassParams(ori, sb, classParams, isJson);
            this.handlePathAndMatrixParams(sb, ori, isJson);
        }
        this.startMethodTag(sb, ori);
        if (!this.handleDocs(anns, sb, "method", true, isJson)) {
            this.handleOperJavaDocs(ori, sb);
        }
        if (this.getMethod(ori).getParameterTypes().length != 0 || classParams.size() != 0) {
            this.startMethodRequestTag(sb, ori);
            this.handleDocs(anns, sb, "request", false, isJson);
            boolean isForm = this.isFormRequest(ori);
            this.doHandleClassParams(ori, sb, classParams, isJson, ParameterType.QUERY, ParameterType.HEADER);
            this.doHandleJaxrsBeanParamClassParams(ori, sb, classParams, isJson, ParameterType.QUERY, ParameterType.HEADER);
            for (Parameter p : ori.getParameters()) {
                if (isForm && p.getType() == ParameterType.REQUEST_BODY) continue;
                this.handleParameter(sb, jaxbTypes, qnameResolver, clsMap, ori, p, isJson);
            }
            if (isForm) {
                this.handleFormRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, this.getFormClass(ori), isJson);
            }
            this.endMethodRequestTag(sb, ori);
        }
        this.startMethodResponseTag(sb, ori);
        Class<?> returnType = this.getMethod(ori).getReturnType();
        boolean isVoid = Void.TYPE == returnType;
        ResponseStatus responseStatus = this.getMethod(ori).getAnnotation(ResponseStatus.class);
        if (responseStatus != null) {
            this.setResponseStatus(sb, responseStatus.value());
        } else if (isVoid) {
            boolean oneway = this.getMethod(ori).getAnnotation(Oneway.class) != null;
            this.setResponseStatus(sb, oneway ? Response.Status.ACCEPTED : Response.Status.NO_CONTENT);
        }
        sb.append(">");
        this.handleDocs(anns, sb, "response", false, isJson);
        if (!isVoid) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, returnType, isJson, false);
        }
        this.endMethodResponseTag(sb, ori);
        this.endMethodTag(sb, ori);
        if (resourceTagOpened && !samePathOperationFollows) {
            this.endResourceTag(sb, ori);
            resourceTagOpened = false;
        }
        return resourceTagOpened;
    }

    private void setResponseStatus(StringBuilder sb, Response.Status ... statuses) {
        sb.append(" status=\"");
        for (int i = 0; i < statuses.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(statuses[i].getStatusCode());
        }
        sb.append("\"");
    }

    protected boolean compareOperations(OperationResourceInfo ori1, OperationResourceInfo ori2) {
        if (ori1 == null || ori2 == null || !ori1.getURITemplate().getValue().equals(ori2.getURITemplate().getValue()) || ori1.getHttpMethod() != null && ori2.getHttpMethod() == null || ori2.getHttpMethod() != null && ori1.getHttpMethod() == null) {
            return false;
        }
        int ori1PathParams = 0;
        int ori1MatrixParams = 0;
        for (Parameter p : ori1.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori1PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori1MatrixParams;
        }
        int ori2PathParams = 0;
        int ori2MatrixParams = 0;
        for (Parameter p : ori2.getParameters()) {
            if (p.getType() == ParameterType.PATH) {
                ++ori2PathParams;
                continue;
            }
            if (p.getType() != ParameterType.MATRIX) continue;
            ++ori2MatrixParams;
        }
        return ori1PathParams == ori2PathParams && ori1MatrixParams == ori2MatrixParams;
    }

    private boolean openResource(String path) {
        if ("/".equals(path)) {
            return this.useSingleSlashResource;
        }
        return true;
    }

    protected void handleDynamicSubresource(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, ClassResourceInfo subcri, boolean isJson) {
        if (!isJson) {
            if (subcri != null) {
                sb.append("<!-- Recursive subresource -->");
            } else {
                sb.append("<!-- Dynamic subresource -->");
            }
        }
        this.startResourceTag(sb, subcri, ori.getURITemplate().getValue());
        this.handlePathAndMatrixParams(sb, ori, isJson);
        sb.append("</resource>");
    }

    protected void handlePathAndMatrixClassParams(OperationResourceInfo ori, StringBuilder sb, Map<Parameter, Object> params, boolean isJson) {
        this.doHandleClassParams(ori, sb, params, isJson, ParameterType.PATH);
        this.doHandleClassParams(ori, sb, params, isJson, ParameterType.MATRIX);
        this.doHandleJaxrsBeanParamClassParams(ori, sb, params, isJson, ParameterType.PATH, ParameterType.MATRIX);
    }

    protected void doHandleClassParams(OperationResourceInfo ori, StringBuilder sb, Map<Parameter, Object> params, boolean isJson, ParameterType ... pType) {
        LinkedHashSet<ParameterType> pTypes = new LinkedHashSet<ParameterType>(Arrays.asList(pType));
        for (Map.Entry<Parameter, Object> entry : params.entrySet()) {
            Parameter pm = entry.getKey();
            Object obj = entry.getValue();
            if (!pTypes.contains(pm.getType())) continue;
            Class<?> cls = obj instanceof Method ? ((Method)obj).getParameterTypes()[0] : ((Field)obj).getType();
            Type type = obj instanceof Method ? ((Method)obj).getGenericParameterTypes()[0] : ((Field)obj).getGenericType();
            Annotation[] ann = obj instanceof Method ? ((Method)obj).getParameterAnnotations()[0] : ((Field)obj).getAnnotations();
            this.doWriteParam(ori, sb, pm, cls, type, pm.getName(), ann, isJson);
        }
    }

    protected void doHandleJaxrsBeanParamClassParams(OperationResourceInfo ori, StringBuilder sb, Map<Parameter, Object> params, boolean isJson, ParameterType ... pType) {
        for (Map.Entry<Parameter, Object> entry : params.entrySet()) {
            Parameter pm = entry.getKey();
            Object obj = entry.getValue();
            if (pm.getType() != ParameterType.BEAN) continue;
            Class<?> cls = obj instanceof Method ? ((Method)obj).getParameterTypes()[0] : ((Field)obj).getType();
            this.doWriteJaxrsBeanParam(sb, ori, cls, isJson, pType);
        }
    }

    protected void handlePathAndMatrixParams(StringBuilder sb, OperationResourceInfo ori, boolean isJson) {
        this.handleParams(sb, ori, ParameterType.PATH, isJson);
        this.handleParams(sb, ori, ParameterType.MATRIX, isJson);
        this.doWriteJaxrsBeanParams(sb, ori, isJson, ParameterType.PATH, ParameterType.MATRIX);
    }

    protected void handleParameter(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Parameter pm, boolean isJson) {
        Class<?> cls = this.getMethod(ori).getParameterTypes()[pm.getIndex()];
        if (pm.getType() == ParameterType.REQUEST_BODY) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, cls, isJson, true);
            return;
        }
        if (pm.getType() == ParameterType.PATH || pm.getType() == ParameterType.MATRIX) {
            return;
        }
        if (pm.getType() == ParameterType.HEADER || pm.getType() == ParameterType.QUERY) {
            this.writeParam(sb, pm, ori, isJson);
            return;
        }
        if (pm.getType() == ParameterType.BEAN) {
            this.doWriteJaxrsBeanParams(sb, ori, isJson, ParameterType.HEADER, ParameterType.QUERY);
        }
    }

    protected void handleParams(StringBuilder sb, OperationResourceInfo ori, ParameterType type, boolean isJson) {
        for (Parameter pm : ori.getParameters()) {
            if (pm.getType() != type) continue;
            this.writeParam(sb, pm, ori, isJson);
        }
    }

    private Annotation[] getBodyAnnotations(OperationResourceInfo ori, boolean inbound) {
        Method opMethod = this.getMethod(ori);
        if (inbound) {
            for (Parameter pm : ori.getParameters()) {
                if (pm.getType() != ParameterType.REQUEST_BODY) continue;
                return opMethod.getParameterAnnotations()[pm.getIndex()];
            }
            return new Annotation[0];
        }
        return opMethod.getDeclaredAnnotations();
    }

    private void writeParam(StringBuilder sb, Parameter pm, OperationResourceInfo ori, boolean isJson) {
        Method method = this.getMethod(ori);
        Class<?> type = method.getParameterTypes()[pm.getIndex()];
        if (!"".equals(pm.getName())) {
            this.doWriteParam(ori, sb, pm, type, method.getGenericParameterTypes()[pm.getIndex()], pm.getName(), method.getParameterAnnotations()[pm.getIndex()], isJson);
        } else {
            LinkedList parentBeanClasses = new LinkedList();
            parentBeanClasses.add(type);
            this.doWriteBeanParam(ori, sb, type, pm, null, parentBeanClasses, isJson);
            parentBeanClasses.remove(type);
        }
    }

    private void doWriteJaxrsBeanParams(StringBuilder sb, OperationResourceInfo ori, boolean isJson, ParameterType ... parameterTypes) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.BEAN) continue;
            Method method = this.getMethod(ori);
            Class<?> type = method.getParameterTypes()[p.getIndex()];
            this.doWriteJaxrsBeanParam(sb, ori, type, isJson, parameterTypes);
        }
    }

    private void doWriteJaxrsBeanParam(StringBuilder sb, OperationResourceInfo ori, Class<?> beanType, boolean isJson, ParameterType ... parameterTypes) {
        for (Method m : beanType.getMethods()) {
            if (!m.getName().startsWith("set")) continue;
            for (ParameterType parameterType : parameterTypes) {
                Class<? extends Annotation> annClass = this.getAnnotationFromParamType(parameterType);
                Annotation annotation = m.getAnnotation(annClass);
                if (annotation == null) continue;
                String propertyName = StringUtils.uncapitalize((String)m.getName().substring(3));
                Parameter pm = new Parameter(parameterType, propertyName);
                pm.setEncoded(m.getAnnotation(Encoded.class) != null);
                DefaultValue dv = m.getAnnotation(DefaultValue.class);
                if (dv != null) {
                    pm.setDefaultValue(dv.value());
                }
                this.doWriteParam(ori, sb, pm, m.getParameterTypes()[0], m.getGenericParameterTypes()[0], propertyName, new Annotation[0], isJson);
            }
        }
    }

    private Class<? extends Annotation> getAnnotationFromParamType(ParameterType pt) {
        return PARAMETER_TYPE_MAP.get(pt);
    }

    private void doWriteBeanParam(OperationResourceInfo ori, StringBuilder sb, Class<?> type, Parameter pm, String parentName, List<Class<?>> parentBeanClasses, boolean isJson) {
        Map pms = InjectionUtils.getParametersFromBeanClass(type, (ParameterType)pm.getType(), (boolean)true);
        for (Map.Entry entry : pms.entrySet()) {
            Class paramCls;
            boolean isPrimitive;
            String name = ((Parameter)entry.getKey()).getName();
            if (parentName != null) {
                name = parentName + "." + name;
            }
            boolean bl = isPrimitive = InjectionUtils.isPrimitive((Class)(paramCls = (Class)entry.getValue())) || paramCls.isEnum();
            if (isPrimitive || Date.class.isAssignableFrom(paramCls) || InjectionUtils.isSupportedCollectionOrArray((Class)paramCls)) {
                this.doWriteParam(ori, sb, (Parameter)entry.getKey(), paramCls, paramCls, name, new Annotation[0], isJson);
                continue;
            }
            if (parentBeanClasses.contains(paramCls)) continue;
            parentBeanClasses.add(paramCls);
            this.doWriteBeanParam(ori, sb, paramCls, (Parameter)entry.getKey(), name, parentBeanClasses, isJson);
            parentBeanClasses.remove(paramCls);
        }
    }

    protected void doWriteParam(OperationResourceInfo ori, StringBuilder sb, Parameter pm, Class<?> type, Type genericType, String paramName, Annotation[] anns, boolean isJson) {
        String value;
        Multipart m;
        ParameterType pType = pm.getType();
        boolean isForm = this.isFormParameter(pm, type, anns);
        if (paramName == null && isForm && (m = (Multipart)AnnotationUtils.getAnnotation((Annotation[])anns, Multipart.class)) != null) {
            paramName = m.value();
        }
        sb.append("<param name=\"").append(paramName).append("\" ");
        String style = ParameterType.PATH == pType ? "template" : (isForm ? "query" : (ParameterType.REQUEST_BODY == pType ? "plain" : pType.toString().toLowerCase()));
        sb.append("style=\"").append(style).append("\"");
        if (pm.getDefaultValue() != null) {
            sb.append(" default=\"").append(this.xmlEncodeIfNeeded(pm.getDefaultValue())).append("\"");
        }
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            type = InjectionUtils.getActualType((Type)genericType);
            sb.append(" repeating=\"true\"");
        }
        if ((value = XmlSchemaPrimitiveUtils.getSchemaRepresentation(type)) == null) {
            if (type.isEnum()) {
                value = "xs:string";
            } else if (type == InputStream.class) {
                value = "xs:anyType";
            }
        }
        if (value != null) {
            if (isJson) {
                value = value.substring(3);
            }
            sb.append(" type=\"").append(value).append("\"");
        }
        if (type.isEnum()) {
            sb.append(">");
            this.handleDocs(anns, sb, "param", true, isJson);
            this.setEnumOptions(sb, type);
            sb.append("</param>");
        } else {
            this.addDocsAndCloseElement(ori, pm.getIndex(), sb, anns, "param", "param", true, isJson);
        }
    }

    private void setEnumOptions(StringBuilder sb, Class<?> enumClass) {
        try {
            Method m = enumClass.getMethod("values", new Class[0]);
            Object[] values = (Object[])m.invoke(null, new Object[0]);
            m = enumClass.getMethod("toString", new Class[0]);
            for (Object o : values) {
                String str = (String)m.invoke(o, new Object[0]);
                sb.append("<option value=\"" + str + "\"/>");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addDocsAndCloseElement(OperationResourceInfo ori, int paramIndex, StringBuilder sb, Annotation[] anns, String elementName, String category, boolean allowDefault, boolean isJson) {
        boolean docAnnAvailable = this.isDocAvailable(anns);
        if (docAnnAvailable || ori != null && !this.docProviders.isEmpty()) {
            sb.append(">");
            if (docAnnAvailable) {
                this.handleDocs(anns, sb, category, allowDefault, isJson);
            } else if (category == "return") {
                this.handleOperResponseJavaDocs(ori, sb);
            } else if (category == "param") {
                this.handleOperParamJavaDocs(ori, paramIndex, sb);
            }
            sb.append("</" + elementName + ">");
        } else {
            sb.append("/>");
        }
    }

    private boolean isDocAvailable(Annotation[] anns) {
        return AnnotationUtils.getAnnotation((Annotation[])anns, Description.class) != null || AnnotationUtils.getAnnotation((Annotation[])anns, Descriptions.class) != null;
    }

    protected void handleRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean isJson, boolean inbound) {
        List<MediaType> types;
        List<Object> list = types = inbound ? ori.getConsumeTypes() : ori.getProduceTypes();
        if (MultivaluedMap.class.isAssignableFrom(type)) {
            types = Collections.singletonList(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else if (this.isWildcard(types)) {
            types = Collections.singletonList(this.defaultRepMediaType);
        }
        Method opMethod = this.getMethod(ori);
        boolean isPrimitive = InjectionUtils.isPrimitive(type);
        for (MediaType mt : types) {
            String docCategory;
            Annotation[] anns;
            sb.append("<representation");
            sb.append(" mediaType=\"").append(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0])).append("\"");
            if (isJson && !mt.getSubtype().contains("json")) {
                sb.append("/>");
                continue;
            }
            boolean allowDefault = true;
            int inParamIndex = -1;
            Type genericType = null;
            if (inbound) {
                inParamIndex = this.getRequestBodyParam(ori).getIndex();
                anns = opMethod.getParameterAnnotations()[inParamIndex];
                if (!this.isDocAvailable(anns)) {
                    anns = opMethod.getAnnotations();
                }
                docCategory = "param";
                genericType = opMethod.getGenericParameterTypes()[inParamIndex];
            } else {
                anns = opMethod.getAnnotations();
                docCategory = "return";
                allowDefault = false;
                genericType = opMethod.getGenericReturnType();
            }
            if (isPrimitive) {
                sb.append(">");
                Parameter p = inbound ? this.getRequestBodyParam(ori) : new Parameter(ParameterType.REQUEST_BODY, 0, "result");
                this.doWriteParam(ori, sb, p, type, type, p.getName() == null ? "request" : p.getName(), anns, isJson);
                sb.append("</representation>");
                continue;
            }
            boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            Class theActualType = null;
            theActualType = isCollection ? InjectionUtils.getActualType((Type)genericType) : ResourceUtils.getActualJaxbType(type, (Method)opMethod, (boolean)inbound);
            if (theActualType == Object.class && !(genericType instanceof Class)) {
                Type theType = InjectionUtils.processGenericTypeIfNeeded((Class)ori.getClassResourceInfo().getServiceClass(), Object.class, (Type)genericType);
                theActualType = InjectionUtils.getActualType((Type)theType);
            }
            if (isJson) {
                sb.append(" element=\"").append(theActualType.getSimpleName()).append("\"");
            } else if (qnameResolver != null && (this.linkAnyMediaTypeToXmlSchema || mt.getSubtype().contains("xml")) && jaxbTypes.contains(theActualType)) {
                this.generateQName(sb, qnameResolver, clsMap, theActualType, isCollection, this.getBodyAnnotations(ori, inbound));
            }
            this.addDocsAndCloseElement(ori, inParamIndex, sb, anns, "representation", docCategory, allowDefault, isJson);
        }
    }

    private Parameter getRequestBodyParam(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.REQUEST_BODY) continue;
            return p;
        }
        throw new IllegalStateException();
    }

    private boolean isWildcard(List<MediaType> types) {
        return types.size() == 1 && types.get(0).equals((Object)MediaType.WILDCARD_TYPE);
    }

    private void handleFormRepresentation(StringBuilder sb, Set<Class<?>> jaxbTypes, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, OperationResourceInfo ori, Class<?> type, boolean isJson) {
        if (type != null) {
            this.handleRepresentation(sb, jaxbTypes, qnameResolver, clsMap, ori, type, false, true);
        } else {
            List types = ori.getConsumeTypes();
            MediaType formType = this.isWildcard(types) ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : (MediaType)types.get(0);
            sb.append("<representation");
            sb.append(" mediaType=\"").append(formType).append("\"");
            if (isJson) {
                sb.append("/>");
            } else {
                sb.append(">");
                List params = ori.getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    if (!this.isFormParameter((Parameter)params.get(i), this.getMethod(ori).getParameterTypes()[i], this.getMethod(ori).getParameterAnnotations()[i])) continue;
                    this.writeParam(sb, (Parameter)params.get(i), ori, isJson);
                }
                sb.append("</representation>");
            }
        }
    }

    protected List<OperationResourceInfo> sortOperationsByPath(Set<OperationResourceInfo> ops) {
        LinkedList<OperationResourceInfo> opsWithSamePath = new LinkedList<OperationResourceInfo>(ops);
        Collections.sort(opsWithSamePath, new Comparator<OperationResourceInfo>(){

            @Override
            public int compare(OperationResourceInfo op1, OperationResourceInfo op2) {
                boolean sub2;
                boolean sub1 = op1.getHttpMethod() == null;
                boolean bl = sub2 = op2.getHttpMethod() == null;
                if (sub1 && !sub2) {
                    return 1;
                }
                if (!sub1 && sub2) {
                    return -1;
                }
                URITemplate ut1 = op1.getURITemplate();
                URITemplate ut2 = op2.getURITemplate();
                int result = ut1.getValue().compareTo(ut2.getValue());
                if (!(result != 0 || sub1 && sub2)) {
                    result = op1.getHttpMethod().compareTo(op2.getHttpMethod());
                }
                if (result == 0 && WadlGenerator.this.ignoreOverloadedMethods && op1.getMethodToInvoke().getName().equals(op2.getMethodToInvoke().getName())) {
                    Integer paramLen1 = op1.getMethodToInvoke().getParameterTypes().length;
                    Integer paramLen2 = op2.getMethodToInvoke().getParameterTypes().length;
                    result = paramLen1.compareTo(paramLen2) * -1;
                }
                return result;
            }
        });
        return opsWithSamePath;
    }

    public List<ClassResourceInfo> getResourcesList(Message m, UriInfo ui) {
        boolean absolutePathSlashOn;
        String slash = "/";
        String path = ui.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        List all = ((JAXRSServiceImpl)m.getExchange().getService()).getClassResourceInfos();
        boolean bl = absolutePathSlashOn = this.checkAbsolutePathSlash && ui.getAbsolutePath().getPath().endsWith("/");
        if ("/".equals(path) && !absolutePathSlashOn) {
            return all;
        }
        LinkedList<ClassResourceInfo> cris = new LinkedList<ClassResourceInfo>();
        for (ClassResourceInfo cri : all) {
            MetadataMap map = new MetadataMap();
            if (!cri.getURITemplate().match(path, (MultivaluedMap)map) || !"/".equals(map.getFirst((Object)"FINAL_MATCH_GROUP"))) continue;
            cris.add(cri);
        }
        return cris;
    }

    public Response getExistingWadl(Message m, UriInfo ui, MediaType mt) {
        String loc;
        Endpoint ep = m.getExchange().getEndpoint();
        if (ep != null && (loc = (String)ep.get((Object)"wadl.location")) != null) {
            try {
                InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)((Bus)ep.get((Object)Bus.class.getName())));
                if (is != null) {
                    List resourcesEls;
                    if (this.isJson(mt)) {
                        return Response.ok((Object)is, (MediaType)mt).build();
                    }
                    Document wadlDoc = StaxUtils.read((InputStream)is);
                    Element appEl = wadlDoc.getDocumentElement();
                    List grammarEls = DOMUtils.getChildrenWithName((Element)appEl, (String)WADL_NS, (String)"grammars");
                    if (grammarEls.size() == 1) {
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)((Element)grammarEls.get(0)), (String)WADL_NS, (String)"include"), "href", loc, "", m, ui);
                    }
                    if ((resourcesEls = DOMUtils.getChildrenWithName((Element)appEl, (String)WADL_NS, (String)"resources")).size() == 1) {
                        DOMUtils.setAttribute((Node)((Node)resourcesEls.get(0)), (String)"base", (String)this.getBaseURI(m, ui));
                        List resourceEls = DOMUtils.getChildrenWithName((Element)((Element)resourcesEls.get(0)), (String)WADL_NS, (String)"resource");
                        this.handleExistingDocRefs(resourceEls, "type", loc, "", m, ui);
                        return this.finalizeExistingWadlResponse(wadlDoc, m, ui, mt);
                    }
                }
            }
            catch (Exception ex) {
                throw ExceptionUtils.toInternalServerErrorException((Throwable)ex, null);
            }
        }
        return null;
    }

    private Response finalizeExistingWadlResponse(Document wadlDoc, Message m, UriInfo ui, MediaType mt) throws Exception {
        Object entity = null;
        if (this.stylesheetReference != null) {
            if (!this.applyStylesheetLocally) {
                ProcessingInstruction pi = wadlDoc.createProcessingInstruction("xml-stylesheet", this.getStylesheetInstructionData(m, ui));
                wadlDoc.insertBefore(pi, wadlDoc.getDocumentElement());
                entity = this.copyDOMToString(wadlDoc);
            } else {
                entity = this.transformLocally(m, ui, new DOMSource(wadlDoc));
            }
        } else {
            entity = new DOMSource(wadlDoc);
        }
        return Response.ok((Object)entity, (MediaType)mt).build();
    }

    private String copyDOMToString(Document wadlDoc) throws Exception {
        DOMSource domSource = new DOMSource(wadlDoc);
        StringWriter stringWriter = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.transform(domSource, new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    private String transformLocally(Message m, UriInfo ui, Source source) throws Exception {
        InputStream is = ResourceUtils.getResourceStream((String)this.stylesheetReference, (Bus)m.getExchange().getBus());
        Transformer t = TransformerFactory.newInstance().newTemplates(new StreamSource(is)).newTransformer();
        t.setParameter("base.path", (String)m.get((Object)"http.base.path"));
        StringWriter stringWriter = new StringWriter();
        t.transform(source, new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public Response getExistingResource(Message m, UriInfo ui, String href) {
        try {
            String loc = this.docLocationMap.get(href);
            if (loc != null) {
                InputStream is;
                int fragmentIndex = loc.lastIndexOf("#");
                if (fragmentIndex != -1) {
                    loc = loc.substring(0, fragmentIndex);
                }
                if ((is = ResourceUtils.getResourceStream((String)loc, (Bus)m.getExchange().getBus())) != null) {
                    Element docEl = StaxUtils.read((InputStream)is).getDocumentElement();
                    if (href.endsWith(".xsl")) {
                        List xslImports = DOMUtils.getChildrenWithName((Element)docEl, (String)XLS_NS, (String)"import");
                        this.handleExistingDocRefs(xslImports, "href", loc, href, m, ui);
                        List xslIncludes = DOMUtils.getChildrenWithName((Element)docEl, (String)XLS_NS, (String)"include");
                        this.handleExistingDocRefs(xslIncludes, "href", loc, href, m, ui);
                    } else if (fragmentIndex != -1) {
                        List grammarEls = DOMUtils.getChildrenWithName((Element)docEl, (String)WADL_NS, (String)"grammars");
                        if (grammarEls.size() == 1) {
                            this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)((Element)grammarEls.get(0)), (String)WADL_NS, (String)"include"), "href", loc, href, m, ui);
                        }
                    } else {
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)docEl, (String)"http://www.w3.org/2001/XMLSchema", (String)"import"), "schemaLocation", loc, href, m, ui);
                        this.handleExistingDocRefs(DOMUtils.getChildrenWithName((Element)docEl, (String)"http://www.w3.org/2001/XMLSchema", (String)"include"), "schemaLocation", loc, href, m, ui);
                    }
                    return Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)new DOMSource(docEl)).build();
                }
            } else if (this.stylesheetReference != null && href.endsWith(".xsl")) {
                InputStream is = ResourceUtils.getResourceStream((String)href, (Bus)m.getExchange().getBus());
                return Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)is).build();
            }
        }
        catch (Exception ex) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        return null;
    }

    private void handleExistingDocRefs(List<Element> elements, String attrName, String parentDocLoc, String parentRef, Message m, UriInfo ui) {
        if (this.keepRelativeDocLinks) {
            return;
        }
        int index = parentDocLoc.lastIndexOf(47);
        parentDocLoc = index == -1 ? parentDocLoc : parentDocLoc.substring(0, index + 1);
        index = parentRef.lastIndexOf(47);
        parentRef = index == -1 ? "" : parentRef.substring(0, index + 1);
        for (Element element : elements) {
            String href;
            String originalRef = href = element.getAttribute(attrName);
            if (StringUtils.isEmpty((String)href) || href.startsWith("#")) continue;
            int fragmentIndex = href.lastIndexOf("#");
            String fragment = null;
            if (fragmentIndex != -1) {
                fragment = href.substring(fragmentIndex + 1);
                href = href.substring(0, fragmentIndex);
            }
            String actualRef = parentRef + href;
            this.docLocationMap.put(actualRef, parentDocLoc + originalRef);
            UriBuilder ub = UriBuilder.fromUri((String)this.getBaseURI(m, ui)).path(actualRef).fragment(fragment);
            URI schemaURI = ub.build(new Object[0]);
            DOMUtils.setAttribute((Node)element, (String)attrName, (String)schemaURI.toString());
        }
    }

    private void generateQName(StringBuilder sb, ElementQNameResolver qnameResolver, Map<Class<?>, QName> clsMap, Class<?> type, boolean isCollection, Annotation[] annotations) {
        QName typeQName;
        if (!isCollection && (typeQName = clsMap.get(type)) != null) {
            this.writeQName(sb, typeQName);
            return;
        }
        QName qname = qnameResolver.resolve(type, annotations, Collections.unmodifiableMap(clsMap));
        if (qname != null) {
            if (!isCollection) {
                this.writeQName(sb, qname);
                clsMap.put(type, qname);
            } else {
                XMLName name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])annotations, XMLName.class);
                String localPart = null;
                localPart = name != null ? JAXRSUtils.convertStringToQName((String)name.value()).getLocalPart() : qname.getLocalPart() + "s";
                QName collectionName = new QName(qname.getNamespaceURI(), localPart, qname.getPrefix());
                this.writeQName(sb, collectionName);
            }
        }
    }

    private void writeQName(StringBuilder sb, QName qname) {
        sb.append(" element=\"").append(qname.getPrefix()).append(':').append(qname.getLocalPart()).append("\"");
    }

    private boolean isXmlRoot(Class<?> cls) {
        return cls.getAnnotation(XmlRootElement.class) != null;
    }

    private SchemaCollection getSchemaCollection(ResourceTypes resourceTypes, JAXBContext context) {
        if (context == null) {
            return null;
        }
        SchemaCollection xmlSchemaCollection = new SchemaCollection();
        HashSet<DOMSource> schemas = new HashSet<DOMSource>();
        ArrayList<String> targetNamespaces = new ArrayList<String>();
        try {
            for (DOMResult r : JAXBUtils.generateJaxbSchemas((JAXBContext)context, (Map)CastUtils.cast(Collections.emptyMap(), String.class, DOMResult.class))) {
                QName typeName;
                String tnsDecl;
                Document doc = (Document)r.getNode();
                ElementQNameResolver theResolver = this.createElementQNameResolver(context);
                String tns = doc.getDocumentElement().getAttribute("targetNamespace");
                String tnsPrefix = doc.getDocumentElement().lookupPrefix(tns);
                tnsPrefix = tnsPrefix == null ? ((tnsDecl = doc.getDocumentElement().getAttribute("xmlns:tns")) != null && tnsDecl.equals(tns) ? "tns:" : "") : tnsPrefix + ":";
                if (this.supportJaxbXmlType) {
                    for (Class clazz : resourceTypes.getAllTypes().keySet()) {
                        XmlType root;
                        if (this.isXmlRoot(clazz) || (root = clazz.getAnnotation(XmlType.class)) == null || (typeName = theResolver.resolve(clazz, new Annotation[0], Collections.emptyMap())) == null || !tns.equals(typeName.getNamespaceURI())) continue;
                        QName elementName = (QName)resourceTypes.getXmlNameMap().get(clazz);
                        if (elementName == null) {
                            elementName = typeName;
                        }
                        Element newElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        newElement.setAttribute("name", elementName.getLocalPart());
                        newElement.setAttribute("type", tnsPrefix + typeName.getLocalPart());
                        if (Modifier.isAbstract(clazz.getModifiers()) && resourceTypes.getSubstitutions().values().contains(clazz)) {
                            newElement.setAttribute("abstract", "true");
                        }
                        doc.getDocumentElement().appendChild(newElement);
                    }
                    if (this.supportJaxbSubstitutions) {
                        for (Map.Entry entry : resourceTypes.getSubstitutions().entrySet()) {
                            QName typeName2 = theResolver.resolve((Class)entry.getKey(), new Annotation[0], Collections.emptyMap());
                            for (Element element : DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"element")) {
                                QName groupName;
                                if (!element.getAttribute("name").equals(typeName2.getLocalPart()) || (groupName = theResolver.resolve((Class)entry.getValue(), new Annotation[0], Collections.emptyMap())) == null) continue;
                                element.setAttribute("substitutionGroup", tnsPrefix + groupName.getLocalPart());
                            }
                        }
                    }
                }
                if (this.supportCollections && !resourceTypes.getCollectionMap().isEmpty()) {
                    for (Map.Entry entry : resourceTypes.getCollectionMap().entrySet()) {
                        QName colQName = (QName)entry.getValue();
                        if (colQName == null && (colQName = theResolver.resolve((Class)entry.getKey(), new Annotation[0], Collections.emptyMap())) != null) {
                            colQName = new QName(colQName.getNamespaceURI(), colQName.getLocalPart() + "s", colQName.getPrefix());
                        }
                        if (colQName == null || !tns.equals(colQName.getNamespaceURI()) || (typeName = theResolver.resolve((Class)entry.getKey(), new Annotation[0], Collections.emptyMap())) == null) continue;
                        Element newElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        newElement.setAttribute("name", colQName.getLocalPart());
                        Element ctElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                        newElement.appendChild(ctElement);
                        Element seqElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                        ctElement.appendChild(seqElement);
                        Element xsElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:element");
                        seqElement.appendChild(xsElement);
                        xsElement.setAttribute("ref", tnsPrefix + typeName.getLocalPart());
                        xsElement.setAttribute("minOccurs", "0");
                        xsElement.setAttribute("maxOccurs", "unbounded");
                        doc.getDocumentElement().appendChild(newElement);
                    }
                }
                DOMSource source = new DOMSource(doc, r.getSystemId());
                schemas.add(source);
                if (StringUtils.isEmpty((String)tns)) continue;
                targetNamespaces.add(tns);
            }
        }
        catch (IOException e) {
            LOG.fine("No schema can be generated");
            return null;
        }
        boolean hackAroundEmptyNamespaceIssue = false;
        for (DOMSource r : schemas) {
            hackAroundEmptyNamespaceIssue = this.addSchemaDocument(xmlSchemaCollection, targetNamespaces, (Document)r.getNode(), r.getSystemId(), hackAroundEmptyNamespaceIssue);
        }
        return xmlSchemaCollection;
    }

    private QName getJaxbQName(String name, String namespace, Class<?> type, Map<Class<?>, QName> clsMap) {
        QName qname = this.getQNameFromParts(name, namespace, type, clsMap);
        if (qname != null) {
            return qname;
        }
        String ns = JAXBUtils.getPackageNamespace(type);
        if (ns != null) {
            return this.getQNameFromParts(name, ns, type, clsMap);
        }
        return null;
    }

    private QName getJaxbQName(JAXBContextProxy jaxbProxy, Class<?> type, Map<Class<?>, QName> clsMap) {
        XmlRootElement root = type.getAnnotation(XmlRootElement.class);
        if (root != null) {
            return this.getJaxbQName(root.name(), root.namespace(), type, clsMap);
        }
        try {
            JAXBBeanInfo jaxbInfo;
            JAXBBeanInfo jAXBBeanInfo = jaxbInfo = jaxbProxy == null ? null : JAXBUtils.getBeanInfo((JAXBContextProxy)jaxbProxy, type);
            if (jaxbInfo == null) {
                return null;
            }
            Object instance = type.newInstance();
            return this.getQNameFromParts(jaxbInfo.getElementLocalName(instance), jaxbInfo.getElementNamespaceURI(instance), type, clsMap);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getPrefix(String ns, Map<Class<?>, QName> clsMap) {
        String prefix = null;
        for (QName name : clsMap.values()) {
            if (!name.getNamespaceURI().equals(ns)) continue;
            prefix = name.getPrefix();
            break;
        }
        if (prefix == null) {
            int size = new HashSet<QName>(clsMap.values()).size();
            prefix = this.nsPrefix + (size + 1);
        }
        return prefix;
    }

    private boolean isFormRequest(OperationResourceInfo ori) {
        for (Parameter p : ori.getParameters()) {
            if (p.getType() != ParameterType.FORM && (p.getType() != ParameterType.REQUEST_BODY || this.getMethod(ori).getParameterTypes()[p.getIndex()] != MultivaluedMap.class && AnnotationUtils.getAnnotation((Annotation[])this.getMethod(ori).getParameterAnnotations()[p.getIndex()], Multipart.class) == null)) continue;
            return true;
        }
        return false;
    }

    private Class<?> getFormClass(OperationResourceInfo ori) {
        List params = ori.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            if (!this.isFormParameter((Parameter)params.get(i), this.getMethod(ori).getParameterTypes()[i], this.getMethod(ori).getParameterAnnotations()[i])) continue;
            return null;
        }
        return MultivaluedMap.class;
    }

    private boolean isFormParameter(Parameter pm, Class<?> type, Annotation[] anns) {
        return ParameterType.FORM == pm.getType() || ParameterType.REQUEST_BODY == pm.getType() && AnnotationUtils.getAnnotation((Annotation[])anns, Multipart.class) != null && (InjectionUtils.isPrimitive(type) || type == InputStream.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSchemaDocument(SchemaCollection col, List<String> tnsList, Document d, String systemId, boolean hackAroundEmptyNamespaceIssue) {
        String ns = d.getDocumentElement().getAttribute("targetNamespace");
        if (StringUtils.isEmpty((String)ns)) {
            if (DOMUtils.getFirstElement((Node)d.getDocumentElement()) == null) {
                hackAroundEmptyNamespaceIssue = true;
                return hackAroundEmptyNamespaceIssue;
            }
            d = this.copy(d);
            ns = tnsList.isEmpty() ? "" : tnsList.get(0);
            d.getDocumentElement().setAttribute("targetNamespace", ns);
        }
        if (hackAroundEmptyNamespaceIssue) {
            d = this.doEmptyNamespaceHack(d);
        }
        for (Node n = d.getDocumentElement().getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
            e.removeAttribute("schemaLocation");
        }
        Document document = d;
        synchronized (document) {
            col.read(d, systemId);
        }
        return hackAroundEmptyNamespaceIssue;
    }

    private Document doEmptyNamespaceHack(Document d) {
        boolean hasStuffToRemove = false;
        Element el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
        while (el != null) {
            if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                hasStuffToRemove = true;
                break;
            }
            el = DOMUtils.getNextElement((Element)el);
        }
        if (hasStuffToRemove) {
            d = this.copy(d);
            el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
            while (el != null) {
                if ("import".equals(el.getLocalName()) && StringUtils.isEmpty((String)el.getAttribute("targetNamespace"))) {
                    d.getDocumentElement().removeChild(el);
                    el = DOMUtils.getFirstElement((Node)d.getDocumentElement());
                    continue;
                }
                el = DOMUtils.getNextElement((Element)el);
            }
        }
        return d;
    }

    private Document copy(Document doc) {
        try {
            return StaxUtils.copy((Document)doc);
        }
        catch (XMLStreamException e) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    private QName getQNameFromParts(String name, String namespace, Class<?> type, Map<Class<?>, QName> clsMap) {
        if (namespace == null || "##default".equals(namespace) || namespace.length() == 0) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        if ("##default".equals(name)) {
            name = StringUtils.uncapitalize((String)type.getSimpleName());
        }
        String prefix = this.getPrefix(namespace, clsMap);
        return new QName(namespace, name, prefix);
    }

    public void setIgnoreMessageWriters(boolean ignoreMessageWriters) {
        this.ignoreMessageWriters = ignoreMessageWriters;
    }

    private void handleApplicationDocs(StringBuilder sbApp) {
        if (this.applicationTitle != null) {
            sbApp.append("<doc title=\"" + this.xmlEncodeIfNeeded(this.applicationTitle) + "\"/>");
        }
    }

    protected void handleClassJavaDocs(ClassResourceInfo cri, StringBuilder sb) {
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getClassDoc(cri));
        }
    }

    protected void handleOperJavaDocs(OperationResourceInfo ori, StringBuilder sb) {
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getMethodDoc(ori));
        }
    }

    protected void handleOperResponseJavaDocs(OperationResourceInfo ori, StringBuilder sb) {
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getMethodResponseDoc(ori));
        }
    }

    protected void handleOperParamJavaDocs(OperationResourceInfo ori, int paramIndex, StringBuilder sb) {
        for (DocumentationProvider docProvider : this.docProviders) {
            this.addProvidedDocs(sb, docProvider.getMethodParameterDoc(ori, paramIndex));
        }
    }

    private void addProvidedDocs(StringBuilder sb, String text) {
        if (!StringUtils.isEmpty((String)text)) {
            sb.append("<doc>");
            sb.append(this.xmlEncodeIfNeeded(text));
            sb.append("</doc>");
        }
    }

    protected boolean handleDocs(Annotation[] anns, StringBuilder sb, String category, boolean allowDefault, boolean isJson) {
        for (Annotation a : anns) {
            Description d;
            if (a.annotationType() == Descriptions.class) {
                Descriptions ds = (Descriptions)a;
                return this.handleDocs(ds.value(), sb, category, allowDefault, isJson);
            }
            if (a.annotationType() != Description.class || (d = (Description)a).target().length() == 0 && !allowDefault || d.target().length() > 0 && !d.target().equals(category)) continue;
            sb.append("<doc");
            if (!isJson && d.lang().length() > 0) {
                sb.append(" xml:lang=\"" + d.lang() + "\"");
            }
            if (d.title().length() > 0) {
                sb.append(" title=\"" + this.xmlEncodeIfNeeded(d.title()) + "\"");
            }
            sb.append(">");
            if (d.value().length() > 0) {
                sb.append(this.xmlEncodeIfNeeded(d.value()));
            } else if (d.docuri().length() > 0) {
                String path;
                InputStream is = null;
                if (d.docuri().startsWith(CLASSPATH_PREFIX) && (is = ResourceUtils.getClasspathResourceStream((String)(path = d.docuri().substring(CLASSPATH_PREFIX.length())), SchemaHandler.class, (Bus)(this.bus == null ? BusFactory.getDefaultBus() : this.bus))) != null) {
                    try {
                        sb.append(IOUtils.toString((InputStream)is));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            sb.append("</doc>");
            return true;
        }
        return false;
    }

    private String getNamespace() {
        return this.wadlNamespace != null ? this.wadlNamespace : WADL_NS;
    }

    public void setWadlNamespace(String namespace) {
        this.wadlNamespace = namespace;
    }

    public void setSingleResourceMultipleMethods(boolean singleResourceMultipleMethods) {
        this.singleResourceMultipleMethods = singleResourceMultipleMethods;
    }

    public void setUseSingleSlashResource(boolean useSingleSlashResource) {
        this.useSingleSlashResource = useSingleSlashResource;
    }

    @Deprecated
    public void setLinkJsonToXmlSchema(boolean link) {
        this.setLinkAnyMediaTypeToXmlSchema(link);
    }

    public void setLinkAnyMediaTypeToXmlSchema(boolean link) {
        this.linkAnyMediaTypeToXmlSchema = link;
    }

    public void setSchemaLocations(List<String> locations) {
        this.externalQnamesMap = new HashMap<String, List<String>>();
        this.externalSchemasCache = new ArrayList<String>(locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            String loc = locations.get(i);
            try {
                this.loadSchemasIntoCache(loc);
                continue;
            }
            catch (Exception ex) {
                LOG.warning("No schema resource " + loc + " can be loaded : " + ex.getMessage());
                this.externalSchemasCache = null;
                this.externalQnamesMap = null;
                return;
            }
        }
    }

    private void loadSchemasIntoCache(String loc) throws Exception {
        InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)(this.bus == null ? BusFactory.getDefaultBus() : this.bus));
        if (is == null) {
            return;
        }
        ByteArrayInputStream bis = IOUtils.loadIntoBAIS((InputStream)is);
        XMLSource source = new XMLSource((InputStream)bis);
        source.setBuffering();
        String targetNs = source.getValue("/*/@targetNamespace");
        Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
        String[] elementNames = source.getValues("/*/xs:element/@name", nsMap);
        this.externalQnamesMap.put(targetNs, Arrays.asList(elementNames));
        String schemaValue = (String)source.getNode("/xs:schema", nsMap, String.class);
        this.externalSchemasCache.add(schemaValue);
    }

    public void setUseJaxbContextForQnames(boolean checkJaxbOnly) {
        this.useJaxbContextForQnames = checkJaxbOnly;
    }

    protected ElementQNameResolver createElementQNameResolver(JAXBContext context) {
        if (this.resolver != null) {
            return this.resolver;
        }
        if (this.useJaxbContextForQnames) {
            if (context != null) {
                JAXBContextProxy proxy = JAXBUtils.createJAXBContextProxy((JAXBContext)context);
                return new JaxbContextQNameResolver(proxy);
            }
            return null;
        }
        if (this.externalQnamesMap != null) {
            return new SchemaQNameResolver(this.externalQnamesMap);
        }
        return new XMLNameQNameResolver();
    }

    protected SchemaWriter createSchemaWriter(ResourceTypes resourceTypes, JAXBContext context, UriInfo ui) {
        if (this.externalSchemaLinks != null && this.externalSchemasCache == null) {
            return new ExternalSchemaWriter(this.externalSchemaLinks, ui);
        }
        if (this.externalSchemasCache != null) {
            return new StringSchemaWriter(this.externalSchemasCache, this.externalSchemaLinks, ui);
        }
        SchemaCollection coll = this.getSchemaCollection(resourceTypes, context);
        if (coll != null) {
            return new SchemaCollectionWriter(coll);
        }
        return null;
    }

    public void setExternalLinks(List<String> externalLinks) {
        this.externalSchemaLinks = new LinkedList<URI>();
        for (String s : externalLinks) {
            try {
                String href = s;
                if (href.startsWith(CLASSPATH_PREFIX)) {
                    int index = href.lastIndexOf(47);
                    href = index == -1 ? href.substring(9) : href.substring(index + 1);
                    this.docLocationMap.put(href, s);
                }
                this.externalSchemaLinks.add(URI.create(href));
            }
            catch (Exception ex) {
                LOG.warning("Not a valid URI : " + s);
                this.externalSchemaLinks = null;
                break;
            }
        }
    }

    public void setResolver(ElementQNameResolver resolver) {
        this.resolver = resolver;
    }

    public void setPrivateAddresses(List<String> privateAddresses) {
        this.privateAddresses = privateAddresses;
    }

    public List<String> getPrivateAddresses() {
        return this.privateAddresses;
    }

    public void setAddResourceAndMethodIds(boolean addResourceAndMethodIds) {
        ResourceIdGeneratorImpl idGen = addResourceAndMethodIds ? new ResourceIdGeneratorImpl() : null;
        this.setResourceIdGenerator(idGen);
    }

    public void setResourceIdGenerator(ResourceIdGenerator idGen) {
        this.idGenerator = idGen;
    }

    private Method getMethod(OperationResourceInfo ori) {
        Method annMethod = ori.getAnnotatedMethod();
        return annMethod != null ? annMethod : ori.getMethodToInvoke();
    }

    public void setApplicationTitle(String applicationTitle) {
        this.applicationTitle = applicationTitle;
    }

    public void setNamespacePrefix(String prefix) {
        this.nsPrefix = prefix;
    }

    public void setIgnoreForwardSlash(boolean ignoreForwardSlash) {
        this.ignoreForwardSlash = ignoreForwardSlash;
    }

    public void setIgnoreRequests(boolean ignoreRequests) {
        this.ignoreRequests = ignoreRequests;
    }

    public void setSupportCollections(boolean support) {
        this.supportCollections = support;
    }

    public void setDefaultMediaType(String mt) {
        this.defaultWadlResponseMediaType = JAXRSUtils.toMediaType((String)mt);
    }

    public void setDefaultRepresentationMediaType(String mt) {
        this.defaultWadlResponseMediaType = JAXRSUtils.toMediaType((String)mt);
    }

    public void setSupportJaxbXmlType(boolean supportJaxbXmlType) {
        this.supportJaxbXmlType = supportJaxbXmlType;
    }

    public void setSupportJaxbSubstitutions(boolean supportJaxbSubstitutions) {
        this.supportJaxbSubstitutions = supportJaxbSubstitutions;
    }

    public void setCheckAbsolutePathSlash(boolean checkAbsolutePathSlash) {
        this.checkAbsolutePathSlash = checkAbsolutePathSlash;
    }

    public void setJavaDocPath(String path) throws Exception {
        this.setDocumentationProvider(new JavaDocProvider(this.bus == null ? BusFactory.getDefaultBus() : this.bus, path));
    }

    public void setDocumentationProvider(DocumentationProvider p) {
        this.docProviders.add(p);
    }

    public void setDocumentationProvider(List<DocumentationProvider> ps) {
        this.docProviders.addAll(ps);
    }

    public void setStylesheetReference(String stylesheetReference) {
        this.stylesheetReference = stylesheetReference;
    }

    public void setIgnoreOverloadedMethods(boolean ignore) {
        this.ignoreOverloadedMethods = ignore;
    }

    public void setKeepRelativeDocLinks(boolean keepRelativeDocLinks) {
        this.keepRelativeDocLinks = keepRelativeDocLinks;
    }

    public void setApplyStylesheetLocally(boolean applyStylesheetLocally) {
        this.applyStylesheetLocally = applyStylesheetLocally;
    }

    static {
        PARAMETER_TYPE_MAP.put(ParameterType.FORM, FormParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.QUERY, QueryParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.HEADER, HeaderParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.PATH, PathParam.class);
        PARAMETER_TYPE_MAP.put(ParameterType.MATRIX, MatrixParam.class);
    }

    private class ResourceIdGeneratorImpl
    implements ResourceIdGenerator {
        private ResourceIdGeneratorImpl() {
        }

        @Override
        public String getClassResourceId(ClassResourceInfo cri) {
            Class serviceClass = cri != null ? cri.getServiceClass() : Object.class;
            QName jaxbQname = null;
            if (WadlGenerator.this.useJaxbContextForQnames) {
                jaxbQname = WadlGenerator.this.getJaxbQName(null, serviceClass, new HashMap(0));
            }
            String pName = jaxbQname == null ? PackageUtils.getPackageName((Class)serviceClass) : null;
            String localName = jaxbQname == null ? serviceClass.getSimpleName() : jaxbQname.getLocalPart();
            String nsName = jaxbQname == null ? pName + "." : "";
            return nsName + localName;
        }

        @Override
        public String getMethodResourceId(OperationResourceInfo ori) {
            return WadlGenerator.this.getMethod(ori).getName();
        }
    }

    private static class SchemaConverter
    extends DelegatingXMLStreamWriter {
        private static final String SCHEMA_LOCATION = "schemaLocation";
        private Map<String, String> locsMap;

        public SchemaConverter(XMLStreamWriter writer, Map<String, String> locsMap) {
            super(writer);
            this.locsMap = locsMap;
        }

        public void writeAttribute(String local, String value) throws XMLStreamException {
            if (SCHEMA_LOCATION.equals(local) && this.locsMap.containsKey(value)) {
                value = this.locsMap.get(value);
            }
            super.writeAttribute(local, value);
        }
    }

    private class SchemaQNameResolver
    implements ElementQNameResolver {
        private Map<String, List<String>> map;

        public SchemaQNameResolver(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            String name = type.getSimpleName();
            for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
                String elementName = null;
                if (entry.getValue().contains(name)) {
                    elementName = name;
                } else if (entry.getValue().contains(name.toLowerCase())) {
                    elementName = name.toLowerCase();
                }
                if (elementName == null) continue;
                return WadlGenerator.this.getQNameFromParts(elementName, entry.getKey(), type, clsMap);
            }
            return null;
        }
    }

    private class XMLNameQNameResolver
    implements ElementQNameResolver {
        private XMLNameQNameResolver() {
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            XMLName name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])annotations, XMLName.class);
            if (name == null) {
                name = type.getAnnotation(XMLName.class);
            }
            if (name != null) {
                QName qname = DOMUtils.convertStringToQName((String)name.value(), (String)name.prefix());
                if (qname.getPrefix().length() > 0) {
                    return qname;
                }
                return WadlGenerator.this.getQNameFromParts(qname.getLocalPart(), qname.getNamespaceURI(), type, clsMap);
            }
            return null;
        }
    }

    private class JaxbContextQNameResolver
    implements ElementQNameResolver {
        private JAXBContextProxy proxy;

        public JaxbContextQNameResolver(JAXBContextProxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public QName resolve(Class<?> type, Annotation[] annotations, Map<Class<?>, QName> clsMap) {
            XmlType root;
            QName qname = WadlGenerator.this.getJaxbQName(this.proxy, type, clsMap);
            if (qname == null && WadlGenerator.this.supportJaxbXmlType && (root = type.getAnnotation(XmlType.class)) != null) {
                XMLName name = (XMLName)AnnotationUtils.getAnnotation((Annotation[])annotations, XMLName.class);
                if (name == null) {
                    qname = WadlGenerator.this.getJaxbQName(root.name(), root.namespace(), type, clsMap);
                } else {
                    QName tempQName = JAXRSUtils.convertStringToQName((String)name.value());
                    qname = new QName(tempQName.getNamespaceURI(), tempQName.getLocalPart(), WadlGenerator.this.getPrefix(tempQName.getNamespaceURI(), clsMap));
                }
            }
            return qname;
        }
    }

    private class ExternalSchemaWriter
    implements SchemaWriter {
        private List<URI> links;
        private UriInfo uriInfo;

        public ExternalSchemaWriter(List<URI> links, UriInfo ui) {
            this.links = links;
            this.uriInfo = ui;
        }

        @Override
        public void write(StringBuilder sb) {
            for (URI link : this.links) {
                try {
                    URI value = link.isAbsolute() ? link : this.uriInfo.getBaseUriBuilder().path(link.toString()).build(new Object[0]);
                    sb.append("<include href=\"").append(value.toString()).append("\"/>");
                }
                catch (Exception ex) {
                    LOG.warning("WADL grammar section will be incomplete, this link is not a valid URI : " + link.toString());
                }
            }
        }
    }

    private class SchemaCollectionWriter
    implements SchemaWriter {
        private SchemaCollection coll;

        public SchemaCollectionWriter(SchemaCollection coll) {
            this.coll = coll;
        }

        @Override
        public void write(StringBuilder sb) {
            for (XmlSchema xs : this.coll.getXmlSchemas()) {
                if (xs.getItems().isEmpty() || "http://www.w3.org/2001/XMLSchema".equals(xs.getTargetNamespace())) continue;
                StringWriter writer = new StringWriter();
                xs.write((Writer)writer);
                sb.append(writer.toString());
            }
        }
    }

    private class StringSchemaWriter
    implements SchemaWriter {
        private List<String> theSchemas = new LinkedList<String>();

        public StringSchemaWriter(List<String> schemas, List<URI> links, UriInfo ui) {
            for (String s : schemas) {
                XMLSource source = new XMLSource((InputStream)new ByteArrayInputStream(s.getBytes()));
                source.setBuffering();
                Map<String, String> locs = this.getLocationsMap(source, "import", links, ui);
                locs.putAll(this.getLocationsMap(source, "include", links, ui));
                String actualSchema = !locs.isEmpty() ? this.transformSchema(s, locs) : s;
                this.theSchemas.add(actualSchema);
            }
        }

        private Map<String, String> getLocationsMap(XMLSource source, String elementName, List<URI> links, UriInfo ui) {
            Map<String, String> nsMap = Collections.singletonMap("xs", "http://www.w3.org/2001/XMLSchema");
            String[] locations = source.getValues("/*/xs:" + elementName + "/@schemaLocation", nsMap);
            HashMap<String, String> locs = new HashMap<String, String>();
            if (locations == null) {
                return locs;
            }
            for (String loc : locations) {
                try {
                    URI uri = URI.create(loc);
                    if (uri.isAbsolute()) continue;
                    if (links != null) {
                        for (URI overwriteURI : links) {
                            if (!overwriteURI.toString().endsWith(loc)) continue;
                            if (overwriteURI.isAbsolute()) {
                                locs.put(loc, overwriteURI.toString());
                                break;
                            }
                            locs.put(loc, ui.getBaseUriBuilder().path(overwriteURI.toString()).build(new Object[0]).toString());
                            break;
                        }
                    }
                    if (locs.containsKey(loc)) continue;
                    locs.put(loc, ui.getBaseUriBuilder().path(loc).build(new Object[0]).toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return locs;
        }

        private String transformSchema(String schema, Map<String, String> locs) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SchemaConverter sc = new SchemaConverter(StaxUtils.createXMLStreamWriter((OutputStream)bos), locs);
            try {
                StaxUtils.copy((Source)new StreamSource(new StringReader(schema)), (XMLStreamWriter)((Object)sc));
                sc.flush();
                sc.close();
                return bos.toString();
            }
            catch (Exception ex) {
                return schema;
            }
        }

        @Override
        public void write(StringBuilder sb) {
            for (String s : this.theSchemas) {
                sb.append(s);
            }
        }
    }

    protected static interface SchemaWriter {
        public void write(StringBuilder var1);
    }
}

