/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public class Swagger2Feature
extends AbstractSwaggerFeature {
    @Override
    protected void addSwaggerResource(Server server) {
        if (!this.runAsFilter) {
            ArrayList<ApiListingResource> serviceBeans = new ArrayList<ApiListingResource>();
            ApiListingResource apiListingResource = new ApiListingResource();
            serviceBeans.add(apiListingResource);
            JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
            sfb.setResourceClassesFromBeans(serviceBeans);
            for (ClassResourceInfo cri : sfb.getClassResourceInfo()) {
                if (ApiListingResource.class != cri.getResourceClass()) continue;
                InjectionUtils.injectContextProxiesAndApplication((AbstractResourceInfo)cri, (Object)apiListingResource, null);
            }
        }
        ArrayList<SwaggerContainerRequestFilter> providers = new ArrayList<SwaggerContainerRequestFilter>();
        if (this.runAsFilter) {
            providers.add(new SwaggerContainerRequestFilter());
        }
        providers.add((SwaggerContainerRequestFilter)new SwaggerSerializers());
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setScan(this.isScan());
    }

    @Override
    protected void setBasePathByAddress(String address) {
        if (!address.startsWith("/")) {
            address = URI.create(address).getPath();
        }
        this.setBasePath(address);
    }

    @PreMatching
    private static class SwaggerContainerRequestFilter
    extends ApiListingResource
    implements ContainerRequestFilter {
        private static final String APIDOCS_LISTING_PATH_JSON = "swagger.json";
        private static final String APIDOCS_LISTING_PATH_YAML = "swagger.yaml";
        @Context
        private MessageContext mc;

        private SwaggerContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                Response r = this.getListingJson(null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            } else if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                Response r = this.getListingYaml(null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            }
        }
    }
}

