/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.xacml;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.xacml.RequestComponentBuilder;
import org.apache.cxf.rt.security.xacml.XACMLRequestBuilder;
import org.apache.cxf.security.SecurityContext;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.joda.time.DateTime;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.SubjectType;
import org.w3c.dom.Element;

public class DefaultXACMLRequestBuilder
implements XACMLRequestBuilder {
    private String action = "execute";
    private boolean sendDateTime = true;
    private boolean sendFullRequestURL;

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public String getAction() {
        return this.action;
    }

    @Override
    public RequestType createRequest(Principal principal, List<String> roles, Message message) throws Exception {
        String issuer = this.getIssuer(message);
        String actionToUse = this.getAction(message);
        ArrayList<AttributeType> attributes = new ArrayList<AttributeType>();
        AttributeValueType subjectIdAttributeValue = RequestComponentBuilder.createAttributeValueType(principal.getName());
        AttributeType subjectIdAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:subject:subject-id", "http://www.w3.org/2001/XMLSchema#string", issuer, Collections.singletonList(subjectIdAttributeValue));
        attributes.add(subjectIdAttribute);
        if (roles != null) {
            ArrayList<AttributeValueType> roleAttributes = new ArrayList<AttributeValueType>();
            for (String role : roles) {
                if (role == null) continue;
                AttributeValueType subjectRoleAttributeValue = RequestComponentBuilder.createAttributeValueType(role);
                roleAttributes.add(subjectRoleAttributeValue);
            }
            if (!roleAttributes.isEmpty()) {
                AttributeType subjectRoleAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:2.0:subject:role", "http://www.w3.org/2001/XMLSchema#anyURI", issuer, roleAttributes);
                attributes.add(subjectRoleAttribute);
            }
        }
        SubjectType subjectType = RequestComponentBuilder.createSubjectType(attributes, null);
        ResourceType resourceType = this.createResourceType(message);
        AttributeValueType actionAttributeValue = RequestComponentBuilder.createAttributeValueType(actionToUse);
        AttributeType actionAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:action:action-id", "http://www.w3.org/2001/XMLSchema#string", null, Collections.singletonList(actionAttributeValue));
        attributes.clear();
        attributes.add(actionAttribute);
        ActionType actionType = RequestComponentBuilder.createActionType(attributes);
        attributes.clear();
        if (this.sendDateTime) {
            DateTime dateTime = new DateTime();
            AttributeValueType environmentAttributeValue = RequestComponentBuilder.createAttributeValueType(dateTime.toString());
            AttributeType environmentAttribute = RequestComponentBuilder.createAttributeType("urn:oasis:names:tc:xacml:1.0:environment:current-dateTime", "http://www.w3.org/2001/XMLSchema#dateTime", null, Collections.singletonList(environmentAttributeValue));
            attributes.add(environmentAttribute);
        }
        EnvironmentType environmentType = RequestComponentBuilder.createEnvironmentType(attributes);
        RequestType request = RequestComponentBuilder.createRequestType(Collections.singletonList(subjectType), Collections.singletonList(resourceType), actionType, environmentType);
        return request;
    }

    private ResourceType createResourceType(Message message) {
        ArrayList<AttributeType> attributes = new ArrayList<AttributeType>();
        String resourceId = null;
        boolean isSoapService = this.isSOAPService(message);
        if (isSoapService) {
            QName serviceName = this.getWSDLService(message);
            QName operationName = this.getWSDLOperation(message);
            if (serviceName != null) {
                resourceId = serviceName.toString() + "#";
                resourceId = serviceName.getNamespaceURI() != null && serviceName.getNamespaceURI().equals(operationName.getNamespaceURI()) ? resourceId + operationName.getLocalPart() : resourceId + operationName.toString();
            } else {
                resourceId = operationName.toString();
            }
        } else {
            resourceId = this.getResourceURI(message, this.sendFullRequestURL);
        }
        attributes.add(this.createAttribute("urn:oasis:names:tc:xacml:1.0:resource:resource-id", "http://www.w3.org/2001/XMLSchema#string", null, resourceId));
        if (isSoapService) {
            QName wsdlService = this.getWSDLService(message);
            if (wsdlService != null) {
                attributes.add(this.createAttribute("urn:cxf:apache:org:wsdl:service-id", "http://www.w3.org/2001/XMLSchema#string", null, wsdlService.toString()));
            }
            QName wsdlOperation = this.getWSDLOperation(message);
            attributes.add(this.createAttribute("urn:cxf:apache:org:wsdl:operation-id", "http://www.w3.org/2001/XMLSchema#string", null, wsdlOperation.toString()));
            String endpointURI = this.getResourceURI(message, this.sendFullRequestURL);
            attributes.add(this.createAttribute("urn:cxf:apache:org:wsdl:endpoint", "http://www.w3.org/2001/XMLSchema#string", null, endpointURI));
        }
        return RequestComponentBuilder.createResourceType(attributes, null);
    }

    private String getIssuer(Message message) throws WSSecurityException {
        Element assertionElement;
        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
        if (sc instanceof SAMLSecurityContext && (assertionElement = ((SAMLSecurityContext)sc).getAssertionElement()) != null) {
            AssertionWrapper wrapper = new AssertionWrapper(assertionElement);
            return wrapper.getIssuerString();
        }
        return null;
    }

    public boolean isSendDateTime() {
        return this.sendDateTime;
    }

    public void setSendDateTime(boolean sendDateTime) {
        this.sendDateTime = sendDateTime;
    }

    public boolean isSendFullRequestURL() {
        return this.sendFullRequestURL;
    }

    public void setSendFullRequestURL(boolean sendFullRequestURL) {
        this.sendFullRequestURL = sendFullRequestURL;
    }

    @Override
    public List<String> getResources(Message message) {
        return Collections.emptyList();
    }

    @Override
    public String getResource(Message message) {
        return null;
    }

    private boolean isSOAPService(Message message) {
        return this.getWSDLOperation(message) != null;
    }

    private QName getWSDLOperation(Message message) {
        if (message != null && message.get((Object)"javax.xml.ws.wsdl.operation") != null) {
            return (QName)message.get((Object)"javax.xml.ws.wsdl.operation");
        }
        return null;
    }

    private QName getWSDLService(Message message) {
        if (message != null && message.get((Object)"javax.xml.ws.wsdl.service") != null) {
            return (QName)message.get((Object)"javax.xml.ws.wsdl.service");
        }
        return null;
    }

    private String getResourceURI(Message message, boolean fullRequestURL) {
        String property;
        String string = property = fullRequestURL ? "org.apache.cxf.request.url" : "org.apache.cxf.request.uri";
        if (message != null && message.get((Object)property) != null) {
            return (String)message.get((Object)property);
        }
        return null;
    }

    private String getAction(Message message) {
        String actionToUse = this.action;
        if (message.get((Object)"javax.xml.ws.wsdl.operation") == null && message.get((Object)"org.apache.cxf.request.method") != null) {
            actionToUse = (String)message.get((Object)"org.apache.cxf.request.method");
        }
        return actionToUse;
    }

    private AttributeType createAttribute(String id, String type, String issuer, List<AttributeValueType> values) {
        return RequestComponentBuilder.createAttributeType(id, type, issuer, values);
    }

    private AttributeType createAttribute(String id, String type, String issuer, String value) {
        return this.createAttribute(id, type, issuer, Collections.singletonList(RequestComponentBuilder.createAttributeValueType(value)));
    }
}

