/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient.hc5;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cxf.transport.http.asyncclient.hc5.AsyncHTTPConduit;
import org.apache.cxf.transport.http.asyncclient.hc5.CXFResponseCallback;
import org.apache.cxf.transport.http.asyncclient.hc5.SharedInputBuffer;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;

public class CXFHttpAsyncResponseConsumer
implements AsyncResponseConsumer<Boolean> {
    private final SharedInputBuffer buf;
    private final AsyncHTTPConduit.AsyncWrappedOutputStream outstream;
    private final CXFResponseCallback responseCallback;
    private volatile boolean completed;
    private volatile Exception exception;
    private volatile HttpResponse response;

    public CXFHttpAsyncResponseConsumer(AsyncHTTPConduit.AsyncWrappedOutputStream asyncWrappedOutputStream, SharedInputBuffer buf, CXFResponseCallback responseCallback) {
        this.outstream = asyncWrappedOutputStream;
        this.responseCallback = responseCallback;
        this.buf = buf;
    }

    public void releaseResources() {
        this.buf.close();
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        capacityChannel.update(Integer.MAX_VALUE);
    }

    public void consumeResponse(HttpResponse resp, EntityDetails entityDetails, HttpContext context, FutureCallback<Boolean> resultCallback) throws HttpException, IOException {
        this.response = resp;
        this.responseCallback.responseReceived(this.response);
        resultCallback.completed((Object)true);
    }

    public void consume(ByteBuffer src) throws IOException {
        for (int i = 0; i < 5; ++i) {
            if (this.outstream.retrySetHttpResponse(this.response)) {
                this.buf.consumeContent(src, this.completed);
                break;
            }
            Thread.onSpinWait();
        }
    }

    public void failed(Exception ex) {
        this.completed = true;
        this.exception = ex;
        this.buf.shutdown();
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.completed = true;
        this.buf.close();
    }

    public void informationResponse(HttpResponse resp, HttpContext context) throws HttpException, IOException {
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

