/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient.hc5;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.http.impl.nio.ExpandableBuffer;
import org.apache.hc.core5.http.nio.DataStreamChannel;

public class SharedOutputBuffer
extends ExpandableBuffer {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile DataStreamChannel channel;
    private volatile boolean shutdown;
    private volatile boolean endOfStream;
    private volatile ByteBuffer largeWrapper;

    public SharedOutputBuffer(int buffersize) {
        super(buffersize);
    }

    public void reset() {
        if (this.shutdown) {
            return;
        }
        this.lock.lock();
        try {
            this.clear();
            this.endOfStream = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasData() {
        this.lock.lock();
        try {
            boolean bl = super.hasData();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int capacity() {
        this.lock.lock();
        try {
            int n = super.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int length() {
        this.lock.lock();
        try {
            int n = super.length();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int produceContent(DataStreamChannel stream) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        this.lock.lock();
        try {
            this.channel = stream;
            this.setOutputMode();
            int bytesWritten = 0;
            if (this.largeWrapper != null || super.hasData()) {
                if (!this.buffer().hasRemaining() && this.largeWrapper != null && this.largeWrapper.hasRemaining()) {
                    bytesWritten = this.channel.write(this.largeWrapper);
                } else if (this.buffer().hasRemaining()) {
                    bytesWritten = this.channel.write(this.buffer());
                }
            }
            if (!(this.largeWrapper != null && this.largeWrapper.hasRemaining() || super.hasData() || !this.endOfStream)) {
                this.channel.endStream();
            }
            if (this.largeWrapper == null || !this.largeWrapper.hasRemaining()) {
                this.condition.signalAll();
            }
            int n = bytesWritten;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copy(InputStream in) throws IOException {
        this.lock.lock();
        int total = 0;
        try {
            if (this.shutdown || this.endOfStream) {
                throw new IllegalStateException("Buffer already closed for writing");
            }
            this.setInputMode();
            int i = 0;
            boolean yielded = false;
            while (i != -1) {
                if (!this.buffer().hasRemaining()) {
                    this.flushContent();
                    this.setInputMode();
                }
                if ((i = in.available()) == 0 && !yielded) {
                    if (this.buffer().position() != 0 && this.channel != null) {
                        this.channel.requestOutput();
                    }
                    try {
                        this.condition.awaitNanos(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.setInputMode();
                    yielded = true;
                    continue;
                }
                int p = this.buffer().position();
                i = in.read(this.buffer().array(), this.buffer().position(), this.buffer().remaining());
                yielded = false;
                if (i == -1) continue;
                total += i;
                this.buffer().position(p + i);
            }
        }
        finally {
            this.lock.unlock();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.shutdown || this.endOfStream) {
                throw new IllegalStateException("Buffer already closed for writing");
            }
            this.setInputMode();
            int remaining = len;
            while (remaining > 0) {
                if (!this.buffer().hasRemaining()) {
                    this.flushContent();
                    this.setInputMode();
                }
                if (this.buffer().position() == 0 && this.buffer().remaining() * 2 < remaining) {
                    this.largeWrapper = ByteBuffer.wrap(b, off, remaining);
                    while (this.largeWrapper.hasRemaining()) {
                        this.flushContent();
                    }
                    this.largeWrapper = null;
                    remaining = 0;
                    continue;
                }
                int chunk = Math.min(remaining, this.buffer().remaining());
                this.buffer().put(b, off, chunk);
                remaining -= chunk;
                off += chunk;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer b) throws IOException {
        if (b == null) {
            return 0;
        }
        this.lock.lock();
        try {
            if (this.shutdown || this.endOfStream) {
                throw new IllegalStateException("Buffer already closed for writing");
            }
            this.setInputMode();
            if (!this.buffer().hasRemaining()) {
                this.flushContent();
                this.setInputMode();
            }
            int c = b.limit() - b.position();
            this.largeWrapper = b;
            while (this.largeWrapper.hasRemaining()) {
                this.flushContent();
            }
            this.largeWrapper = null;
            int n = c;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.lock.lock();
        try {
            if (this.shutdown || this.endOfStream) {
                throw new IllegalStateException("Buffer already closed for writing");
            }
            this.setInputMode();
            if (!this.buffer().hasRemaining()) {
                this.flushContent();
                this.setInputMode();
            }
            this.buffer().put((byte)b);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void flush() throws IOException {
    }

    private void flushContent() throws IOException {
        this.lock.lock();
        try {
            try {
                while (this.largeWrapper != null && this.largeWrapper.hasRemaining() || super.hasData()) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Output operation aborted");
                    }
                    if (this.channel != null) {
                        this.channel.requestOutput();
                    }
                    this.condition.await();
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while flushing the content buffer");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void writeCompleted() throws IOException {
        this.lock.lock();
        try {
            if (this.endOfStream) {
                return;
            }
            this.endOfStream = true;
            if (this.channel != null) {
                this.channel.requestOutput();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

