/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.continuations.JettyContinuationProvider;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;
import org.springframework.util.ClassUtils;

public class JettyHTTPDestination
extends AbstractHTTPDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPDestination.class);
    protected JettyHTTPServerEngine engine;
    protected JettyHTTPServerEngineFactory serverEngineFactory;
    protected ServletContext servletContext;
    protected URL nurl;
    protected ClassLoader loader;
    private boolean configFinalized;

    public JettyHTTPDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, JettyHTTPDestination.getAddressValue((EndpointInfo)ei, (boolean)true).getAddress(), true);
        this.serverEngineFactory = serverEngineFactory;
        this.nurl = new URL(this.endpointInfo.getAddress());
        this.loader = (ClassLoader)bus.getExtension(ClassLoader.class);
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
    }

    protected void retrieveEngine() throws GeneralSecurityException, IOException {
        CertificateConstraintsType constraints;
        this.engine = this.serverEngineFactory.retrieveJettyHTTPServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createJettyHTTPServerEngine(this.nurl.getHost(), this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
        TLSServerParameters serverParameters = this.engine.getTlsServerParameters();
        if (serverParameters != null && serverParameters.getCertConstraints() != null && (constraints = serverParameters.getCertConstraints()) != null) {
            this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints((CertificateConstraintsType)constraints);
        }
        if (!this.nurl.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.nurl + "\"");
        }
    }

    public void finalizeConfig() {
        assert (!this.configFinalized);
        try {
            this.retrieveEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.configFinalized = true;
    }

    protected void activate() {
        super.activate();
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        URL url = null;
        try {
            url = new URL(this.endpointInfo.getAddress());
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.engine.addServant(url, new JettyHTTPHandler(this, this.contextMatchOnExact()));
    }

    protected void deactivate() {
        super.deactivate();
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeServant(this.nurl);
    }

    protected String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String removeTrailingSeparator(String addr) {
        if (addr != null && addr.length() > 0 && addr.lastIndexOf(47) == addr.length() - 1) {
            return addr.substring(0, addr.length() - 1);
        }
        return addr;
    }

    private synchronized String updateEndpointAddress(String addr) {
        String address = this.removeTrailingSeparator(this.endpointInfo.getAddress());
        if (this.getBasePathForFullAddress(address).equals(this.removeTrailingSeparator(this.getStem(this.getBasePathForFullAddress(addr))))) {
            this.endpointInfo.setAddress(addr);
        }
        return address;
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(this.servletContext, req, resp);
    }

    static AbstractConnection getConnectionForRequest(Request r) {
        try {
            return (AbstractConnection)r.getClass().getMethod("getConnection", new Class[0]).invoke((Object)r, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setHeadFalse(AbstractConnection con) {
        try {
            Generator gen = (Generator)con.getClass().getMethod("getGenerator", new Class[0]).invoke((Object)con, new Object[0]);
            gen.setHead(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AbstractConnection c;
        Request baseRequest;
        if (context == null) {
            context = this.servletContext;
        }
        Request request = baseRequest = req instanceof Request ? (Request)req : this.getCurrentRequest();
        if (!"HEAD".equals(req.getMethod()) && (c = JettyHTTPDestination.getConnectionForRequest(baseRequest)) != null) {
            this.setHeadFalse(c);
        }
        if (this.getServer().isSetRedirectURL()) {
            resp.sendRedirect(this.getServer().getRedirectURL());
            resp.flushBuffer();
            baseRequest.setHandled(true);
            return;
        }
        QueryHandlerRegistry queryHandlerRegistry = (QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class);
        if (null != req.getQueryString() && queryHandlerRegistry != null) {
            String reqAddr = req.getRequestURL().toString();
            String requestURL = reqAddr + "?" + req.getQueryString();
            String pathInfo = req.getPathInfo();
            for (QueryHandler qh : queryHandlerRegistry.getHandlers()) {
                boolean recognized = qh instanceof StemMatchingQueryHandler ? ((StemMatchingQueryHandler)qh).isRecognizedQuery(requestURL, pathInfo, this.endpointInfo, this.contextMatchOnExact()) : qh.isRecognizedQuery(requestURL, pathInfo, this.endpointInfo);
                if (!recognized) continue;
                String errorMsg = null;
                CachedOutputStream out = new CachedOutputStream();
                try {
                    EndpointInfo endpointInfo = this.endpointInfo;
                    synchronized (endpointInfo) {
                        String oldAddress = this.updateEndpointAddress(reqAddr);
                        resp.setContentType(qh.getResponseContentType(requestURL, pathInfo));
                        try {
                            qh.writeResponse(requestURL, pathInfo, this.endpointInfo, (OutputStream)out);
                        }
                        catch (Exception ex) {
                            LOG.log(Level.WARNING, "writeResponse failed: ", ex);
                            errorMsg = ex.getMessage();
                        }
                        this.endpointInfo.setAddress(oldAddress);
                    }
                    if (errorMsg != null) {
                        resp.sendError(500, errorMsg);
                    } else {
                        out.writeCacheTo((OutputStream)resp.getOutputStream());
                        resp.getOutputStream().flush();
                    }
                }
                finally {
                    out.close();
                }
                baseRequest.setHandled(true);
                return;
            }
        }
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.serviceRequest(context, req, resp);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    protected void serviceRequest(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Message inMessage;
        Request baseRequest;
        Request request = baseRequest = req instanceof Request ? (Request)req : this.getCurrentRequest();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        if ((inMessage = this.retrieveFromContinuation(req)) == null) {
            inMessage = new MessageImpl();
            this.setupMessage(inMessage, context, req, resp);
            ((MessageImpl)inMessage).setDestination((Destination)this);
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setInMessage(inMessage);
            exchange.setSession((Session)new HTTPSession(req));
        }
        try {
            this.incomingObserver.onMessage(inMessage);
            resp.flushBuffer();
            baseRequest.setHandled(true);
        }
        catch (SuspendedInvocationException ex) {
            if (ex.getRuntimeException() != null) {
                throw ex.getRuntimeException();
            }
        }
        catch (Fault ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    public ServerEngine getEngine() {
        return this.engine;
    }

    private String getStem(String baseURI) {
        return baseURI.substring(0, baseURI.lastIndexOf("/"));
    }

    protected Message retrieveFromContinuation(HttpServletRequest req) {
        return (Message)req.getAttribute("cxf.continuation.message");
    }

    protected void setupContinuation(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
        if (this.engine.getContinuationsEnabled()) {
            inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new JettyContinuationProvider(req, resp, inMessage));
        }
    }

    private AbstractConnection getCurrentConnection() {
        Class cls = null;
        try {
            cls = ClassUtils.forName((String)"org.eclipse.jetty.server.AbstractHttpConnection", (ClassLoader)AbstractConnection.class.getClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cls == null) {
            try {
                cls = ClassUtils.forName((String)"org.eclipse.jetty.server.HttpConnection", (ClassLoader)AbstractConnection.class.getClassLoader());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return (AbstractConnection)((Method)ReflectionUtil.setAccessible((AccessibleObject)cls.getMethod("getCurrentConnection", new Class[0]))).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Request getCurrentRequest() {
        AbstractConnection con = this.getCurrentConnection();
        try {
            return (Request)((Method)ReflectionUtil.setAccessible((AccessibleObject)con.getClass().getMethod("getRequest", new Class[0]))).invoke((Object)con, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

