/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import org.apache.cxf.transport.http.netty.client.CxfResponseCallBack;

public class NettyHttpClientRequest {
    private HttpRequest request;
    private HttpResponse response;
    private URI uri;
    private String method;
    private CxfResponseCallBack cxfResponseCallback;
    private int connectionTimeout;
    private int receiveTimeout;

    public NettyHttpClientRequest(URI requestUri, String method) {
        this.uri = requestUri;
        this.method = method;
    }

    public void createRequest(ByteBuf content) {
        this.request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.method), this.uri.getPath().toString(), content);
        this.request.headers().set("Connection", (Object)"keep-alive");
        this.request.headers().set("Host", (Object)(this.uri.getHost() + ":" + this.uri.getPort()));
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setCxfResponseCallback(CxfResponseCallBack callback) {
        this.cxfResponseCallback = callback;
    }

    public CxfResponseCallBack getCxfResponseCallback() {
        return this.cxfResponseCallback;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        this.receiveTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }
}

