/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.http.netty.client.CxfResponseCallBack;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientPipelineFactory;
import org.apache.cxf.transport.http.netty.client.NettyHttpClientRequest;
import org.apache.cxf.transport.http.netty.client.NettyHttpConduitFactory;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class NettyHttpConduit
extends URLConnectionHTTPConduit
implements BusLifeCycleListener {
    public static final String USE_ASYNC = "use.async.http.conduit";
    final NettyHttpConduitFactory factory;
    private Bootstrap bootstrap;

    public NettyHttpConduit(Bus b, EndpointInfo ei, EndpointReferenceType t, NettyHttpConduitFactory conduitFactory) throws IOException {
        super(b, ei, t);
        this.factory = conduitFactory;
        this.bootstrap = new Bootstrap();
        EventLoopGroup eventLoopGroup = (EventLoopGroup)this.bus.getExtension(EventLoopGroup.class);
        this.bootstrap.group(eventLoopGroup);
        this.bootstrap.channel(NioSocketChannel.class);
    }

    public NettyHttpConduitFactory getNettyHttpConduitFactory() {
        return this.factory;
    }

    protected void setupConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        String s;
        URI uri = address.getURI();
        boolean addressChanged = false;
        String uriString = uri.toString();
        if (uriString.startsWith("netty://")) {
            try {
                uriString = uriString.substring(8);
                uri = new URI(uriString);
                addressChanged = true;
            }
            catch (URISyntaxException ex) {
                throw new MalformedURLException("unsupport uri: " + uriString);
            }
        }
        if (!"http".equals(s = uri.getScheme()) && !"https".equals(s)) {
            throw new MalformedURLException("unknown protocol: " + s);
        }
        Object o = message.getContextualProperty(USE_ASYNC);
        if (o == null) {
            o = this.factory.getUseAsyncPolicy();
        }
        switch (NettyHttpConduitFactory.UseAsyncPolicy.getPolicy(o)) {
            case ALWAYS: {
                o = true;
                break;
            }
            case NEVER: {
                o = false;
                break;
            }
            default: {
                o = !message.getExchange().isSynchronous();
            }
        }
        TLSClientParameters clientParameters = (TLSClientParameters)message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        if ("https".equals(uri.getScheme()) && clientParameters != null && clientParameters.getSSLSocketFactory() != null) {
            o = false;
        }
        if (!PropertyUtils.isTrue((Object)o)) {
            message.put((Object)USE_ASYNC, (Object)Boolean.FALSE);
            super.setupConnection(message, addressChanged ? new Address(uriString, uri) : address, csPolicy);
            return;
        }
        message.put((Object)USE_ASYNC, (Object)Boolean.TRUE);
        if (StringUtils.isEmpty((String)uri.getPath())) {
            uri = uri.resolve("/");
        }
        message.put((Object)"http.scheme", (Object)uri.getScheme());
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put((Object)"org.apache.cxf.request.method", (Object)httpRequestMethod);
        }
        NettyHttpClientRequest request = new NettyHttpClientRequest(uri, httpRequestMethod);
        int ctimeout = NettyHttpConduit.determineConnectionTimeout((Message)message, (HTTPClientPolicy)csPolicy);
        int rtimeout = NettyHttpConduit.determineReceiveTimeout((Message)message, (HTTPClientPolicy)csPolicy);
        request.setConnectionTimeout(ctimeout);
        request.setReceiveTimeout(rtimeout);
        message.put(NettyHttpClientRequest.class, (Object)request);
    }

    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        if (Boolean.TRUE.equals(message.get((Object)USE_ASYNC))) {
            NettyHttpClientRequest entity = (NettyHttpClientRequest)message.get(NettyHttpClientRequest.class);
            NettyWrappedOutputStream out = new NettyWrappedOutputStream(message, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName(), entity.getUri());
            entity.createRequest(out.getOutBuffer());
            entity.getRequest().headers().set("Content-Type", message.get((Object)"Content-Type"));
            return out;
        }
        return super.createOutputStream(message, needToCacheRequest, isChunking, chunkThreshold);
    }

    public void initComplete() {
    }

    public void postShutdown() {
        this.close();
    }

    public void preShutdown() {
    }

    public class NettyWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream {
        final HTTPClientPolicy csPolicy;
        NettyHttpClientRequest entity;
        volatile HttpResponse httpResponse;
        volatile Throwable exception;
        volatile Channel channel;
        volatile SSLSession session;
        boolean isAsync;
        ByteBuf outBuffer;
        OutputStream outputStream;

        protected NettyWrappedOutputStream(Message message, boolean possibleRetransmit, boolean isChunking, int chunkThreshold, String conduitName, URI url) {
            super((HTTPConduit)NettyHttpConduit.this, message, possibleRetransmit, isChunking, chunkThreshold, conduitName, url);
            this.csPolicy = NettyHttpConduit.this.getClient(message);
            this.entity = (NettyHttpClientRequest)message.get(NettyHttpClientRequest.class);
            int bufSize = this.csPolicy.getChunkLength() > 0 ? this.csPolicy.getChunkLength() : 16320;
            this.outBuffer = Unpooled.buffer((int)bufSize);
            this.outputStream = new ByteBufOutputStream(this.outBuffer);
        }

        protected ByteBuf getOutBuffer() {
            return this.outBuffer;
        }

        protected synchronized HttpResponse getHttpResponse() throws IOException {
            while (this.httpResponse == null) {
                if (this.exception == null) {
                    try {
                        ((Object)((Object)this)).wait(this.entity.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.httpResponse != null) continue;
                if (this.exception != null) {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new IOException(this.exception);
                }
                throw new SocketTimeoutException("Read Timeout");
            }
            return this.httpResponse;
        }

        protected HttpContent getHttpResponseContent() throws IOException {
            return (HttpContent)this.getHttpResponse();
        }

        protected synchronized Channel getChannel() throws IOException {
            while (this.channel == null) {
                if (this.exception == null) {
                    try {
                        ((Object)((Object)this)).wait(this.entity.getConnectionTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.channel != null) continue;
                if (this.exception != null) {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new IOException(this.exception);
                }
                throw new SocketTimeoutException("Connection Timeout");
            }
            return this.channel;
        }

        protected void setupWrappedStream() throws IOException {
            this.connect(true);
            this.wrappedStream = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    NettyWrappedOutputStream.this.outputStream.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    NettyWrappedOutputStream.this.outputStream.write(b);
                }

                @Override
                public void close() throws IOException {
                    ChannelFutureListener listener = new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                NettyWrappedOutputStream.this.setException(future.cause());
                            }
                        }
                    };
                    ChannelFuture channelFuture = NettyWrappedOutputStream.this.getChannel().write((Object)NettyWrappedOutputStream.this.entity);
                    channelFuture.addListener((GenericFutureListener)listener);
                    NettyWrappedOutputStream.this.outputStream.close();
                }
            };
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.wrappedStream);
                this.wrappedStream = this.cachedStream;
            }
        }

        protected TLSClientParameters findTLSClientParameters() {
            TLSClientParameters clientParameters = (TLSClientParameters)this.outMessage.get(TLSClientParameters.class);
            if (clientParameters == null) {
                clientParameters = NettyHttpConduit.this.getTlsClientParameters();
            }
            if (clientParameters == null) {
                clientParameters = new TLSClientParameters();
            }
            return clientParameters;
        }

        protected void connect(boolean output) {
            if ("https".equals(this.url.getScheme())) {
                TLSClientParameters clientParameters = this.findTLSClientParameters();
                NettyHttpConduit.this.bootstrap.handler((ChannelHandler)new NettyHttpClientPipelineFactory(clientParameters));
            } else {
                NettyHttpConduit.this.bootstrap.handler((ChannelHandler)new NettyHttpClientPipelineFactory(null));
            }
            ChannelFuture connFuture = NettyHttpConduit.this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.url.getHost(), this.url.getPort() != -1 ? this.url.getPort() : ("http".equals(this.url.getScheme()) ? 80 : 443)));
            ChannelFutureListener listener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        NettyWrappedOutputStream.this.setChannel(future.channel());
                        SslHandler sslHandler = (SslHandler)NettyWrappedOutputStream.this.channel.pipeline().get(SslHandler.class);
                        if (sslHandler != null) {
                            NettyWrappedOutputStream.this.session = sslHandler.engine().getSession();
                        }
                    } else {
                        NettyWrappedOutputStream.this.setException(future.cause());
                    }
                }
            };
            connFuture.addListener((GenericFutureListener)listener);
            if (!output) {
                this.entity.getRequest().headers().remove("Transfer-Encoding");
                this.entity.getRequest().headers().remove("Content-Type");
                this.entity.getRequest().headers().remove(null);
            }
            CxfResponseCallBack callBack = new CxfResponseCallBack(){

                @Override
                public void responseReceived(HttpResponse response) {
                    NettyWrappedOutputStream.this.setHttpResponse(response);
                }
            };
            this.entity.setCxfResponseCallback(callBack);
        }

        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            if ("http".equals(this.outMessage.get((Object)"http.scheme"))) {
                return null;
            }
            this.connect(true);
            HostnameVerifier verifier = SSLUtils.getHostnameVerifier((TLSClientParameters)this.findTLSClientParameters());
            if (!verifier.verify(this.url.getHost(), this.session)) {
                throw new IOException("Could not verify host " + this.url.getHost());
            }
            String method = (String)this.outMessage.get((Object)"org.apache.cxf.request.method");
            String cipherSuite = null;
            Certificate[] localCerts = null;
            Principal principal = null;
            Certificate[] serverCerts = null;
            Principal peer = null;
            if (this.session != null) {
                cipherSuite = this.session.getCipherSuite();
                localCerts = this.session.getLocalCertificates();
                principal = this.session.getLocalPrincipal();
                serverCerts = this.session.getPeerCertificates();
                peer = this.session.getPeerPrincipal();
            }
            return new HttpsURLConnectionInfo(this.url, method, cipherSuite, localCerts, principal, serverCerts, peer);
        }

        protected void setProtocolHeaders() throws IOException {
            Headers h = new Headers(this.outMessage);
            this.entity.getRequest().headers().set("Content-Type", (Object)h.determineContentType());
            boolean addHeaders = MessageUtils.getContextualBoolean((Message)this.outMessage, (String)"org.apache.cxf.http.add-headers", (boolean)false);
            for (Map.Entry header : h.headerMap().entrySet()) {
                if ("Content-Type".equalsIgnoreCase((String)header.getKey())) continue;
                if (addHeaders || "Cookie".equalsIgnoreCase((String)header.getKey())) {
                    for (String s : (List)header.getValue()) {
                        this.entity.getRequest().headers().add("Cookie", (Object)s);
                    }
                } else if (!"Content-Length".equalsIgnoreCase((String)header.getKey())) {
                    StringBuilder b = new StringBuilder();
                    for (int i = 0; i < ((List)header.getValue()).size(); ++i) {
                        b.append((String)((List)header.getValue()).get(i));
                        if (i + 1 >= ((List)header.getValue()).size()) continue;
                        b.append(',');
                    }
                    this.entity.getRequest().headers().set((String)header.getKey(), (Object)b.toString());
                }
                if (this.entity.getRequest().headers().contains("User-Agent")) continue;
                this.entity.getRequest().headers().set("User-Agent", (Object)Version.getCompleteVersionString());
            }
        }

        protected void setFixedLengthStreamingMode(int i) {
            this.entity.getRequest().headers().set("Content-Length", (Object)i);
        }

        protected int getResponseCode() throws IOException {
            return this.getHttpResponse().status().code();
        }

        protected String getResponseMessage() throws IOException {
            return this.getHttpResponse().status().reasonPhrase();
        }

        protected void updateResponseHeaders(Message inMessage) throws IOException {
            Headers h = new Headers(inMessage);
            inMessage.put((Object)"Content-Type", (Object)this.readHeaders(h));
            NettyHttpConduit.this.cookies.readFromHeaders(h);
        }

        private String readHeaders(Headers h) throws IOException {
            Set headerNames = this.getHttpResponse().headers().names();
            String ct = null;
            for (String name : headerNames) {
                List s = this.getHttpResponse().headers().getAll(name);
                h.headerMap().put(name, s);
                if (!"Content-Type".equalsIgnoreCase(name)) continue;
                ct = this.getHttpResponse().headers().get(name);
            }
            return ct;
        }

        protected void handleResponseAsync() throws IOException {
            this.isAsync = true;
        }

        protected void closeInputStream() throws IOException {
            this.getHttpResponseContent().content().clear();
        }

        protected boolean usingProxy() {
            return false;
        }

        protected InputStream getInputStream() throws IOException {
            return new ByteBufInputStream(this.getHttpResponseContent().content());
        }

        protected InputStream getPartialResponse() throws IOException {
            InputStream in = null;
            int responseCode = this.getResponseCode();
            if (responseCode == 202 || responseCode == 200) {
                boolean isEofTerminated;
                String head = this.httpResponse.headers().get("Content-Length");
                int cli = 0;
                if (head != null) {
                    cli = Integer.parseInt(head);
                }
                boolean isChunked = (head = this.httpResponse.headers().get("Transfer-Encoding")) != null && "chunked".equalsIgnoreCase(head);
                head = this.httpResponse.headers().get("Connection");
                boolean bl = isEofTerminated = head != null && "close".equalsIgnoreCase(head);
                if (cli > 0) {
                    in = this.getInputStream();
                } else if (isChunked || isEofTerminated) {
                    try {
                        PushbackInputStream pin = new PushbackInputStream(this.getInputStream());
                        int c = pin.read();
                        if (c != -1) {
                            pin.unread((byte)c);
                            in = pin;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return in;
        }

        protected void setupNewConnection(String newURL) throws IOException {
            this.httpResponse = null;
            this.isAsync = false;
            this.exception = null;
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            try {
                Address address;
                if (NettyHttpConduit.this.defaultAddress.getString().equals(newURL)) {
                    address = NettyHttpConduit.this.defaultAddress;
                    this.url = NettyHttpConduit.this.defaultAddress.getURI();
                } else {
                    this.url = new URI(newURL);
                    address = new Address(newURL, this.url);
                }
                NettyHttpConduit.this.setupConnection(this.outMessage, address, this.csPolicy);
                this.entity = (NettyHttpClientRequest)this.outMessage.get(NettyHttpClientRequest.class);
                this.outBuffer.clear();
                this.outputStream = new ByteBufOutputStream(this.outBuffer);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        protected void retransmitStream() throws IOException {
            this.cachingForRetransmission = false;
            this.setupWrappedStream();
            this.cachedStream.writeCacheTo(this.wrappedStream);
            this.wrappedStream.flush();
            this.wrappedStream.close();
        }

        protected void updateCookiesBeforeRetransmit() throws IOException {
            Headers h = new Headers();
            this.readHeaders(h);
            NettyHttpConduit.this.cookies.readFromHeaders(h);
        }

        public void thresholdReached() throws IOException {
        }

        protected synchronized void setHttpResponse(HttpResponse r) {
            this.httpResponse = r;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((Object)((Object)this)).notifyAll();
        }

        protected synchronized void setException(Throwable ex) {
            this.exception = ex;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            ((Object)((Object)this)).notifyAll();
        }

        protected synchronized void setChannel(Channel ch) {
            this.channel = ch;
            ((Object)((Object)this)).notifyAll();
        }
    }
}

