/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow;

import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.SSLSessionInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.Headers;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http_undertow.UndertowHTTPDestination;

public class UndertowHTTPHandler
implements HttpHandler {
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "javax.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final String METHOD_TRACE = "TRACE";
    protected UndertowHTTPDestination undertowHTTPDestination;
    protected ServletContext servletContext;
    private boolean contextMatchExact;
    private String urlName;
    private Bus bus;

    public UndertowHTTPHandler(UndertowHTTPDestination uhd, boolean cmt) {
        this.undertowHTTPDestination = uhd;
        this.contextMatchExact = cmt;
    }

    public UndertowHTTPHandler(Bus bus) {
        this.bus = bus;
    }

    public boolean isContextMatchExact() {
        return this.contextMatchExact;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
        if (this.undertowHTTPDestination != null) {
            this.undertowHTTPDestination.setServletContext(sc);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setName(String name) {
        this.urlName = name;
    }

    public String getName() {
        return this.urlName;
    }

    public Bus getBus() {
        return this.undertowHTTPDestination != null ? this.undertowHTTPDestination.getBus() : this.bus;
    }

    public void handleRequest(HttpServerExchange undertowExchange) throws Exception {
        block7: {
            try {
                if (undertowExchange.isInIoThread()) {
                    undertowExchange.dispatch((HttpHandler)this);
                    return;
                }
                HttpServletResponseImpl response = new HttpServletResponseImpl(undertowExchange, (ServletContextImpl)this.servletContext);
                HttpServletRequestImpl request = new HttpServletRequestImpl(undertowExchange, (ServletContextImpl)this.servletContext);
                if (request.getMethod().equals(METHOD_TRACE)) {
                    response.setStatus(405);
                    return;
                }
                ServletRequestContext servletRequestContext = new ServletRequestContext(((ServletContextImpl)this.servletContext).getDeployment(), request, response, null);
                undertowExchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, (Object)servletRequestContext);
                request.setAttribute("HTTP_HANDLER", (Object)this);
                request.setAttribute("UNDERTOW_DESTINATION", (Object)this.undertowHTTPDestination);
                SSLSessionInfo ssl = undertowExchange.getConnection().getSslSessionInfo();
                if (ssl != null) {
                    request.setAttribute(SSL_CIPHER_SUITE_ATTRIBUTE, (Object)ssl.getCipherSuite());
                    try {
                        request.setAttribute(SSL_PEER_CERT_CHAIN_ATTRIBUTE, (Object)ssl.getPeerCertificates());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.undertowHTTPDestination.doService(this.servletContext, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (!undertowExchange.isResponseChannelAvailable()) break block7;
                undertowExchange.setStatusCode(500);
                String errorPage = "<html><head><title>Error</title></head><body>Internal Error 500" + t.getMessage() + "</body></html>";
                undertowExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + errorPage.length());
                undertowExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                Sender sender = undertowExchange.getResponseSender();
                sender.send(errorPage);
            }
        }
    }
}

