/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.servlet.ServletTransportFactory;

public class ServletDestination
extends AbstractHTTPDestination {
    static final Logger LOG = LogUtils.getL7dLogger(ServletDestination.class);
    private static final long serialVersionUID = 1L;
    final ServletTransportFactory factory;
    final String path;

    public ServletDestination(Bus b, ConduitInitiator ci, EndpointInfo ei, ServletTransportFactory fact, String p) throws IOException {
        super(b, ci, ei, false);
        this.factory = fact;
        this.path = p;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void invoke(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MessageImpl inMessage = new MessageImpl();
        this.setupMessage((Message)inMessage, context, req, resp);
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setInMessage((Message)inMessage);
        exchange.setSession((Session)new HTTPSession(req));
        inMessage.setDestination((Destination)this);
        this.incomingObserver.onMessage((Message)inMessage);
    }

    protected String getBasePath(String contextPath) throws IOException {
        return contextPath + this.getAddress().getAddress().getValue();
    }

    public void shutdown() {
        this.factory.removeDestination(this.path);
        super.shutdown();
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }
}

