/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpAuthSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestAuthSupplier
extends HttpAuthSupplier {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final MessageDigest MD5_HELPER;
    Map<URL, DigestInfo> authInfo = new ConcurrentHashMap<URL, DigestInfo>();

    @Override
    public boolean requiresRequestCaching() {
        return true;
    }

    static Map<String, String> parseHeader(String fullHeader) {
        HashMap<String, String> map = new HashMap<String, String>();
        fullHeader = fullHeader.substring(7);
        try {
            StreamTokenizer tok = new StreamTokenizer(new StringReader(fullHeader));
            tok.quoteChar(34);
            tok.quoteChar(39);
            tok.whitespaceChars(61, 61);
            tok.whitespaceChars(44, 44);
            while (tok.nextToken() != -1) {
                String key = tok.sval;
                if (tok.nextToken() == -1) {
                    map.put(key, null);
                    return map;
                }
                String value = tok.sval;
                if (value.charAt(0) == '\"') {
                    value = value.substring(1, value.length() - 1);
                }
                map.put(key, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    @Override
    public String getAuthorizationForRealm(HTTPConduit conduit, URL currentURL, Message message, String realm, String fullHeader) {
        Map<String, String> map;
        if (fullHeader.startsWith("Digest ") && ("auth".equals((map = DigestAuthSupplier.parseHeader(fullHeader)).get("qop")) || !map.containsKey("qop"))) {
            DigestInfo di = new DigestInfo();
            di.qop = map.get("qop");
            di.realm = map.get("realm");
            di.nonce = map.get("nonce");
            di.opaque = map.get("opaque");
            if (map.containsKey("algorithm")) {
                di.algorithm = map.get("algorithm");
            }
            if (map.containsKey("charset")) {
                di.charset = map.get("charset");
            }
            di.method = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
            if (di.method == null) {
                di.method = "POST";
            }
            this.authInfo.put(currentURL, di);
            return di.generateAuth(currentURL.getFile(), this.getUsername(conduit, message), this.getPassword(conduit, message));
        }
        return null;
    }

    @Override
    public String getPreemptiveAuthorization(HTTPConduit conduit, URL currentURL, Message message) {
        DigestInfo di = this.authInfo.get(currentURL);
        if (di != null) {
            return di.generateAuth(currentURL.getFile(), this.getUsername(conduit, message), this.getPassword(conduit, message));
        }
        return null;
    }

    private String getPassword(HTTPConduit conduit, Message message) {
        AuthorizationPolicy policy = this.getPolicy(conduit, message);
        return policy != null ? policy.getPassword() : null;
    }

    private String getUsername(HTTPConduit conduit, Message message) {
        AuthorizationPolicy policy = this.getPolicy(conduit, message);
        return policy != null ? policy.getUserName() : null;
    }

    private AuthorizationPolicy getPolicy(HTTPConduit conduit, Message message) {
        AuthorizationPolicy policy = (AuthorizationPolicy)message.getContextualProperty(AuthorizationPolicy.class.getName());
        if (policy == null) {
            policy = conduit.getAuthorization();
        }
        if (policy != null && (!policy.isSetAuthorizationType() || "Digest".equals(policy.getAuthorizationType()))) {
            return policy;
        }
        return null;
    }

    public static String createCnonce() throws UnsupportedEncodingException {
        String cnonce = Long.toString(System.currentTimeMillis());
        return DigestAuthSupplier.encode(MD5_HELPER.digest(cnonce.getBytes("US-ASCII")));
    }

    private static String encode(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    static {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            md = null;
        }
        MD5_HELPER = md;
    }

    class DigestInfo {
        String qop;
        String realm;
        String nonce;
        String opaque;
        int nc;
        String algorithm = "MD5";
        String charset = "ISO-8859-1";
        String method = "POST";

        DigestInfo() {
        }

        synchronized String generateAuth(String uri, String username, String password) {
            try {
                ++this.nc;
                String ncstring = Integer.toString(this.nc);
                while (ncstring.length() < 8) {
                    ncstring = "0" + ncstring;
                }
                String cnonce = DigestAuthSupplier.createCnonce();
                String digAlg = this.algorithm;
                if (digAlg.equalsIgnoreCase("MD5-sess")) {
                    digAlg = "MD5";
                }
                MessageDigest digester = MessageDigest.getInstance(digAlg);
                String a1 = username + ":" + this.realm + ":" + password;
                if ("MD5-sess".equalsIgnoreCase(this.algorithm)) {
                    this.algorithm = "MD5";
                    String tmp2 = DigestAuthSupplier.encode(digester.digest(a1.getBytes(this.charset)));
                    StringBuilder tmp3 = new StringBuilder(tmp2.length() + this.nonce.length() + cnonce.length() + 2);
                    tmp3.append(tmp2);
                    tmp3.append(':');
                    tmp3.append(this.nonce);
                    tmp3.append(':');
                    tmp3.append(cnonce);
                    a1 = tmp3.toString();
                }
                String hasha1 = DigestAuthSupplier.encode(digester.digest(a1.getBytes(this.charset)));
                String a2 = this.method + ":" + uri;
                String hasha2 = DigestAuthSupplier.encode(digester.digest(a2.getBytes("US-ASCII")));
                String serverDigestValue = null;
                serverDigestValue = this.qop == null ? hasha1 + ":" + this.nonce + ":" + hasha2 : hasha1 + ":" + this.nonce + ":" + ncstring + ":" + cnonce + ":" + this.qop + ":" + hasha2;
                serverDigestValue = DigestAuthSupplier.encode(digester.digest(serverDigestValue.getBytes("US-ASCII")));
                StringBuilder builder = new StringBuilder("Digest ");
                if (this.qop != null) {
                    builder.append("qop=\"auth\", ");
                }
                builder.append("realm=\"").append(this.realm);
                if (this.opaque != null) {
                    builder.append("\", opaque=\"").append(this.opaque);
                }
                builder.append("\", nonce=\"").append(this.nonce).append("\", uri=\"").append(uri).append("\", username=\"").append(username).append("\", nc=").append(ncstring).append(", cnonce=\"").append(cnonce).append("\", response=\"").append(serverDigestValue).append("\"");
                return builder.toString();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

