/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.util.StringUtils;

public abstract class AbstractServletController {
    protected static final String DEFAULT_LISTINGS_CLASSIFIER = "/services";
    protected boolean isHideServiceList;
    protected boolean disableAddressUpdates;
    protected String forcedBaseAddress;
    protected String serviceListStyleSheet;
    protected String title;
    protected String serviceListRelativePath = "/services";

    protected AbstractServletController() {
    }

    protected AbstractServletController(ServletConfig config) {
        this.init(config);
    }

    public void setHideServiceList(boolean generate) {
        this.isHideServiceList = generate;
    }

    public void setServiceListRelativePath(String relativePath) {
        this.serviceListRelativePath = relativePath;
    }

    public void setDisableAddressUpdates(boolean noupdates) {
        this.disableAddressUpdates = noupdates;
    }

    public void setForcedBaseAddress(String s) {
        this.forcedBaseAddress = s;
    }

    public void setServiceListStyleSheet(String serviceListStyleSheet) {
        this.serviceListStyleSheet = serviceListStyleSheet;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    private void init(ServletConfig servletConfig) {
        String configTitle;
        String serviceListPath;
        String serviceListTransform;
        String isForcedBaseAddress;
        String isDisableAddressUpdates;
        if (servletConfig == null) {
            return;
        }
        String hideServiceList = servletConfig.getInitParameter("hide-service-list-page");
        if (!StringUtils.isEmpty((String)hideServiceList)) {
            this.isHideServiceList = Boolean.valueOf(hideServiceList);
        }
        if (!StringUtils.isEmpty((String)(isDisableAddressUpdates = servletConfig.getInitParameter("disable-address-updates")))) {
            this.disableAddressUpdates = Boolean.valueOf(isDisableAddressUpdates);
        }
        if (!StringUtils.isEmpty((String)(isForcedBaseAddress = servletConfig.getInitParameter("base-address")))) {
            this.forcedBaseAddress = isForcedBaseAddress;
        }
        if (!StringUtils.isEmpty((String)(serviceListTransform = servletConfig.getInitParameter("service-list-stylesheet")))) {
            this.serviceListStyleSheet = serviceListTransform;
        }
        if (!StringUtils.isEmpty((String)(serviceListPath = servletConfig.getInitParameter("service-list-path")))) {
            this.serviceListRelativePath = serviceListPath;
        }
        if (!StringUtils.isEmpty((String)(configTitle = servletConfig.getInitParameter("service-list-title")))) {
            this.title = configTitle;
        }
    }

    protected String getBaseURL(HttpServletRequest request) {
        String pathInfo;
        String reqPrefix = request.getRequestURL().toString();
        String string = pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
        if (!"/".equals(pathInfo) || reqPrefix.endsWith("/")) {
            String basePath = request.getContextPath() + request.getServletPath();
            int index = basePath.length() == 0 ? reqPrefix.indexOf(request.getRequestURI()) : reqPrefix.indexOf(basePath);
            reqPrefix = reqPrefix.substring(0, index + basePath.length());
        }
        return reqPrefix;
    }
}

