/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.servlet.ServletTransportFactory;

public class ServletDestination
extends AbstractHTTPDestination {
    static final Logger LOG = LogUtils.getL7dLogger(ServletDestination.class);
    private static final long serialVersionUID = 1L;
    final ServletTransportFactory factory;
    final String path;

    public ServletDestination(Bus b, EndpointInfo ei, ServletTransportFactory fact, String p) throws IOException {
        super(b, ei, false);
        this.factory = fact;
        this.path = p;
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void invoke(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.invoke(null, context, req, resp);
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block4: {
            Message inMessage = this.retrieveFromContinuation(req);
            if (inMessage == null) {
                LOG.fine("Create a new message for processing");
                inMessage = new MessageImpl();
                this.setupMessage(inMessage, config, context, req, resp);
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setInMessage(inMessage);
                exchange.setSession((Session)new HTTPSession(req));
                ((MessageImpl)inMessage).setDestination((Destination)this);
            } else {
                LOG.fine("Get the message from the request for processing");
            }
            try {
                this.incomingObserver.onMessage(inMessage);
            }
            catch (SuspendedInvocationException ex) {
                if (ex.getRuntimeException() == null) break block4;
                throw ex.getRuntimeException();
            }
        }
    }

    protected String getBasePath(String contextPath) throws IOException {
        String address = this.getAddress().getAddress().getValue();
        if (address == null) {
            return contextPath;
        }
        if (address.startsWith("http")) {
            return URI.create(address).getPath();
        }
        return contextPath + address;
    }

    public void shutdown() {
        try {
            this.factory.removeDestination(this.path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.shutdown();
    }
}

