/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.ReferencingAuthenticator;

public class CXFAuthenticator
extends Authenticator {
    static boolean setup;
    private static final CXFAuthenticator INSTANCE;

    public static synchronized void addAuthenticator() {
        if (!setup) {
            Authenticator wrapped = null;
            for (Field f : Authenticator.class.getDeclaredFields()) {
                if (!f.getType().equals(Authenticator.class)) continue;
                ReflectionUtil.setAccessible((AccessibleObject)f);
                try {
                    wrapped = (Authenticator)f.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                InputStream ins = ReferencingAuthenticator.class.getResourceAsStream("ReferencingAuthenticator.class");
                byte[] b = IOUtils.readBytesFromStream((InputStream)ins);
                URLClassLoader loader = new URLClassLoader(new URL[0], ClassLoader.getSystemClassLoader());
                Method m = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)loader, ReferencingAuthenticator.class.getName(), b, 0, b.length);
                Class<?> cls = loader.loadClass(ReferencingAuthenticator.class.getName());
                Authenticator auth = (Authenticator)cls.getConstructor(Authenticator.class, Authenticator.class).newInstance(INSTANCE, wrapped);
                Authenticator.setDefault(auth);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            setup = true;
        }
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        Exchange exchange;
        Conduit conduit;
        PasswordAuthentication auth = null;
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null && (conduit = (exchange = m.getExchange()).getConduit(m)) instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && httpConduit.getProxyAuthorization() != null) {
                String un = httpConduit.getProxyAuthorization().getUserName();
                String pwd = httpConduit.getProxyAuthorization().getPassword();
                if (un != null && pwd != null) {
                    auth = new PasswordAuthentication(un, pwd.toCharArray());
                }
            } else if (this.getRequestorType() == Authenticator.RequestorType.SERVER && httpConduit.getAuthorization() != null) {
                if ("basic".equals(this.getRequestingScheme()) || "digest".equals(this.getRequestingScheme())) {
                    return null;
                }
                String un = httpConduit.getAuthorization().getUserName();
                String pwd = httpConduit.getAuthorization().getPassword();
                if (un != null && pwd != null) {
                    auth = new PasswordAuthentication(un, pwd.toCharArray());
                }
            }
        }
        return auth;
    }

    static {
        INSTANCE = new CXFAuthenticator();
    }
}

