/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.cxf.service.model.EndpointInfo;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JCATransactionalMessageListenerContainer
extends DefaultMessageListenerContainer {
    static final ThreadLocal<MessageEndpoint> ENDPOINT_LOCAL = new ThreadLocal();
    static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpointFactory";
    static final String MDB_TRANSACTED_METHOD = "MDBTransactedMethod";
    private MessageEndpointFactory factory;
    private Method method;

    public JCATransactionalMessageListenerContainer(EndpointInfo ei) {
        this.factory = (MessageEndpointFactory)ei.getProperty(MESSAGE_ENDPOINT_FACTORY, MessageEndpointFactory.class);
        this.method = (Method)ei.getProperty(MDB_TRANSACTED_METHOD, Method.class);
        this.setCacheLevel(1);
    }

    protected boolean receiveAndExecute(Session session, MessageConsumer consumer) throws JMSException {
        boolean messageReceived = false;
        MessageEndpoint ep = null;
        MessageConsumer mc = null;
        XASession xa = null;
        Session s = null;
        try {
            xa = (XASession)this.createSession(this.getSharedConnection());
            XAResource xar = xa.getXAResource();
            s = xa.getSession();
            mc = s.createConsumer(this.getDestination());
            ep = this.factory.createEndpoint(xar);
            ENDPOINT_LOCAL.set(ep);
            ep.beforeDelivery(this.method);
            messageReceived = this.doReceiveAndExecute(s, mc, null);
            ep.afterDelivery();
        }
        catch (Exception ex) {
            try {
                throw new JMSException(ex.getMessage());
            }
            catch (Throwable throwable) {
                ep.release();
                JmsUtils.closeMessageConsumer(mc);
                JmsUtils.closeSession((Session)xa);
                JmsUtils.closeSession(s);
                throw throwable;
            }
        }
        ep.release();
        JmsUtils.closeMessageConsumer((MessageConsumer)mc);
        JmsUtils.closeSession((Session)xa);
        JmsUtils.closeSession((Session)s);
        return messageReceived;
    }
}

