/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.ClientBehaviorPolicyType;
import org.apache.cxf.transport.jms.ClientConfig;
import org.apache.cxf.transport.jms.DestinationStyleType;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSNamingPropertyType;
import org.apache.cxf.transport.jms.JNDIConfiguration;
import org.apache.cxf.transport.jms.ServerBehaviorPolicyType;
import org.apache.cxf.transport.jms.ServerConfig;
import org.apache.cxf.transport.jms.SessionPoolType;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiTemplate;

public class JMSOldConfigHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSOldConfigHolder.class);
    private ClientConfig clientConfig;
    private ClientBehaviorPolicyType runtimePolicy;
    private AddressType address;
    private SessionPoolType sessionPool;
    private JMSConfiguration jmsConfig;
    private ServerConfig serverConfig;
    private ServerBehaviorPolicyType serverBehavior;

    public JMSConfiguration createJMSConfigurationFromEndpointInfo(Bus bus, EndpointInfo endpointInfo, boolean isConduit) {
        this.address = (AddressType)((Object)endpointInfo.getTraversedExtensor((Object)new AddressType(), AddressType.class));
        this.clientConfig = (ClientConfig)((Object)endpointInfo.getTraversedExtensor((Object)new ClientConfig(), ClientConfig.class));
        this.runtimePolicy = (ClientBehaviorPolicyType)((Object)endpointInfo.getTraversedExtensor((Object)new ClientBehaviorPolicyType(), ClientBehaviorPolicyType.class));
        this.serverConfig = (ServerConfig)((Object)endpointInfo.getTraversedExtensor((Object)new ServerConfig(), ServerConfig.class));
        this.sessionPool = (SessionPoolType)((Object)endpointInfo.getTraversedExtensor((Object)new SessionPoolType(), SessionPoolType.class));
        this.serverBehavior = (ServerBehaviorPolicyType)((Object)endpointInfo.getTraversedExtensor((Object)new ServerBehaviorPolicyType(), ServerBehaviorPolicyType.class));
        String name = endpointInfo.getName().toString() + (isConduit ? ".jms-conduit" : ".jms-destination");
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, (Object)this);
        }
        if (this.jmsConfig == null) {
            this.jmsConfig = new JMSConfiguration();
        }
        if (this.jmsConfig.isUsingEndpointInfo()) {
            boolean useJndi;
            JndiTemplate jt = new JndiTemplate();
            jt.setEnvironment(JMSOldConfigHolder.getInitialContextEnv(this.address));
            boolean pubSubDomain = false;
            if (this.address.isSetDestinationStyle()) {
                pubSubDomain = DestinationStyleType.TOPIC == this.address.getDestinationStyle();
            }
            JNDIConfiguration jndiConfig = new JNDIConfiguration();
            jndiConfig.setJndiConnectionFactoryName(this.address.getJndiConnectionFactoryName());
            this.jmsConfig.setJndiTemplate(jt);
            jndiConfig.setConnectionUserName(this.address.getConnectionUserName());
            jndiConfig.setConnectionPassword(this.address.getConnectionPassword());
            this.jmsConfig.setJndiConfig(jndiConfig);
            if (this.address.isSetReconnectOnException()) {
                this.jmsConfig.setReconnectOnException(this.address.isReconnectOnException());
            }
            this.jmsConfig.setDurableSubscriptionName(this.serverBehavior.getDurableSubscriberName());
            this.jmsConfig.setExplicitQosEnabled(true);
            if (this.jmsConfig.getMessageSelector() == null) {
                this.jmsConfig.setMessageSelector(this.serverBehavior.getMessageSelector());
            }
            if (isConduit && this.runtimePolicy.isSetMessageType()) {
                this.jmsConfig.setMessageType(this.runtimePolicy.getMessageType().value());
            }
            this.jmsConfig.setPubSubDomain(pubSubDomain);
            this.jmsConfig.setPubSubNoLocal(true);
            this.jmsConfig.setReceiveTimeout(this.clientConfig.getClientReceiveTimeout());
            if (this.clientConfig.isSetUseConduitIdSelector()) {
                this.jmsConfig.setUseConduitIdSelector(this.clientConfig.isUseConduitIdSelector());
            }
            if (this.clientConfig.isSetConduitSelectorPrefix()) {
                this.jmsConfig.setConduitSelectorPrefix(this.clientConfig.getConduitSelectorPrefix());
            }
            this.jmsConfig.setSubscriptionDurable(this.serverBehavior.isSetDurableSubscriberName());
            this.jmsConfig.setDurableSubscriptionName(this.serverBehavior.getDurableSubscriberName());
            this.jmsConfig.setDurableSubscriptionClientId(this.serverConfig.getDurableSubscriptionClientId());
            if (this.sessionPool.isSetHighWaterMark()) {
                this.jmsConfig.setMaxConcurrentTasks(this.sessionPool.getHighWaterMark());
            }
            long timeToLive = isConduit ? this.clientConfig.getMessageTimeToLive() : this.serverConfig.getMessageTimeToLive();
            this.jmsConfig.setTimeToLive(timeToLive);
            if (this.address.isSetUseJms11()) {
                this.jmsConfig.setUseJms11(this.address.isUseJms11());
            }
            if (this.serverBehavior.isSetTransactional()) {
                this.jmsConfig.setSessionTransacted(this.serverBehavior.isTransactional());
            }
            if (useJndi = this.address.isSetJndiDestinationName()) {
                JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
                jndiDestinationResolver.setJndiTemplate(jt);
                this.jmsConfig.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
                this.jmsConfig.setTargetDestination(this.address.getJndiDestinationName());
                this.jmsConfig.setReplyDestination(this.address.getJndiReplyDestinationName());
            } else {
                this.jmsConfig.setTargetDestination(this.address.getJmsDestinationName());
                this.jmsConfig.setReplyDestination(this.address.getJmsReplyDestinationName());
            }
        }
        return this.jmsConfig;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public ClientBehaviorPolicyType getRuntimePolicy() {
        return this.runtimePolicy;
    }

    public void setRuntimePolicy(ClientBehaviorPolicyType runtimePolicy) {
        this.runtimePolicy = runtimePolicy;
    }

    public AddressType getAddress() {
        return this.address;
    }

    public void setAddress(AddressType address) {
        this.address = address;
    }

    public SessionPoolType getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionPool(SessionPoolType sessionPool) {
        this.sessionPool = sessionPool;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ServerBehaviorPolicyType getServerBehavior() {
        return this.serverBehavior;
    }

    public void setServerBehavior(ServerBehaviorPolicyType serverBehavior) {
        this.serverBehavior = serverBehavior;
    }

    public static Properties getInitialContextEnv(AddressType addrType) {
        Properties env = new Properties();
        ListIterator<JMSNamingPropertyType> listIter = addrType.getJMSNamingProperty().listIterator();
        while (listIter.hasNext()) {
            JMSNamingPropertyType propertyPair = listIter.next();
            if (null == propertyPair.getValue()) continue;
            env.setProperty(propertyPair.getName(), propertyPair.getValue());
        }
        if (LOG.isLoggable(Level.FINE)) {
            Enumeration<?> props = env.propertyNames();
            while (props.hasMoreElements()) {
                String name = (String)props.nextElement();
                String value = env.getProperty(name);
                LOG.log(Level.FINE, "Context property: " + name + " | " + value);
            }
        }
        return env;
    }
}

