/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private EndpointInfo endpointInfo;
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap = new ConcurrentHashMap<String, Exchange>();
    private DefaultMessageListenerContainer jmsListener;
    private DefaultMessageListenerContainer allListener;
    private String conduitId;
    private AtomicLong messageCount;
    private int outstandingAsync;
    private JMSBusLifeCycleListener listener;
    private Bus bus;

    public JMSConduit(EndpointInfo endpointInfo, EndpointReferenceType target, JMSConfiguration jmsConfig, Bus b) {
        super(target);
        this.bus = b;
        this.jmsConfig = jmsConfig;
        this.endpointInfo = endpointInfo;
        this.conduitId = UUID.randomUUID().toString().replaceAll("-", "");
        this.messageCount = new AtomicLong(0L);
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        String name = this.endpointInfo.getName().toString() + ".jms-conduit";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_CONDUIT", LOG, new Object[]{name});
        this.jmsConfig.ensureProperlyConfigured(msg);
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        JMSOutputStream out = new JMSOutputStream(this, message.getExchange(), isTextPayload);
        message.setContent(OutputStream.class, (Object)out);
    }

    private synchronized AbstractMessageListenerContainer getJMSListener() {
        if (this.jmsListener == null) {
            this.jmsListener = JMSFactory.createJmsListener(this.jmsConfig, (MessageListener)this, this.jmsConfig.getReplyDestination(), this.conduitId, false);
            this.addBusListener();
        }
        ++this.outstandingAsync;
        return this.jmsListener;
    }

    private synchronized AbstractMessageListenerContainer getAllListener() {
        if (this.allListener == null) {
            this.allListener = JMSFactory.createJmsListener(this.jmsConfig, (MessageListener)this, this.jmsConfig.getReplyDestination(), null, true);
            this.addBusListener();
        }
        ++this.outstandingAsync;
        return this.allListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendExchange(final Exchange exchange, final Object request) {
        org.apache.cxf.message.Message outMessage;
        LOG.log(Level.FINE, "JMSConduit send message");
        org.apache.cxf.message.Message message = outMessage = exchange.getOutMessage() == null ? exchange.getOutFaultMessage() : exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        if (isTextPayload && MessageUtils.isTrue((Object)outMessage.getContextualProperty("mtom-enabled")) && outMessage.getAttachments() != null && outMessage.getAttachments().size() > 0) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
            throw new ConfigurationException(msg);
        }
        JMSMessageHeadersType headers = this.getOrCreateJmsHeaders(outMessage);
        String replyTo = headers.getJMSReplyTo();
        if (replyTo == null) {
            replyTo = this.jmsConfig.getReplyDestination();
        }
        final JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, headers);
        String userCID = headers.getJMSCorrelationID();
        String correlationId = this.createCorrelationId(exchange, userCID);
        Destination replyToDestination = null;
        if (!exchange.isOneWay() || !this.jmsConfig.isEnforceSpec() && JMSConduit.isSetReplyTo(outMessage) && replyTo != null) {
            replyToDestination = exchange.isSynchronous() || exchange.isOneWay() ? JMSFactory.resolveOrCreateDestination(jmsTemplate, replyTo, this.jmsConfig.isPubSubDomain()) : (userCID == null || !this.jmsConfig.isUseConduitIdSelector() ? this.getJMSListener().getDestination() : this.getAllListener().getDestination());
        }
        final String cid = correlationId;
        final Destination rtd = replyToDestination;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class JMSConduitMessageCreator
        implements MessageCreator {
            private Message jmsMessage;

            JMSConduitMessageCreator() {
            }

            public Message createMessage(Session session) throws JMSException {
                String messageType = JMSConduit.this.jmsConfig.getMessageType();
                Destination destination = rtd;
                String replyToAddress = JMSConduit.this.jmsConfig.getReplyToDestination();
                if (replyToAddress != null) {
                    destination = JMSFactory.resolveOrCreateDestination(jmsTemplate, replyToAddress, JMSConduit.this.jmsConfig.isPubSubDomain());
                }
                this.jmsMessage = JMSUtils.buildJMSMessageFromCXFMessage(JMSConduit.this.jmsConfig, outMessage, request, messageType, session, destination, cid);
                if (!exchange.isSynchronous() && !exchange.isOneWay()) {
                    JMSConduit.this.correlationMap.put(cid, exchange);
                }
                LOG.log(Level.FINE, "client sending request: ", this.jmsMessage);
                return this.jmsMessage;
            }

            public String getMessageID() {
                if (this.jmsMessage != null) {
                    try {
                        return this.jmsMessage.getJMSMessageID();
                    }
                    catch (JMSException e) {
                        return null;
                    }
                }
                return null;
            }
        }
        JMSConduitMessageCreator messageCreator = new JMSConduitMessageCreator();
        if (!exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                jmsTemplate.send(this.jmsConfig.getTargetDestination(), (MessageCreator)messageCreator);
                if (correlationId == null) {
                    correlationId = messageCreator.getMessageID();
                }
                headers.setJMSMessageID(messageCreator.getMessageID());
                String messageSelector = "JMSCorrelationID = '" + correlationId + "'";
                if (exchange.isSynchronous()) {
                    Message replyMessage = jmsTemplate.receiveSelected(replyToDestination, messageSelector);
                    if (replyMessage == null) {
                        throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                    }
                    this.doReplyMessage(exchange, replyMessage);
                    if (replyToDestination instanceof TemporaryQueue) {
                        try {
                            ((TemporaryQueue)replyToDestination).delete();
                        }
                        catch (JMSException e) {
                            throw new RuntimeException("Unable to remove temporary queue", e);
                        }
                    }
                }
            }
        }
        jmsTemplate.send(this.jmsConfig.getTargetDestination(), (MessageCreator)messageCreator);
        headers.setJMSMessageID(messageCreator.getMessageID());
    }

    private String createCorrelationId(Exchange exchange, String userCID) {
        String correlationId = null;
        if (!exchange.isOneWay()) {
            if (userCID != null) {
                correlationId = userCID;
            } else if (!(this.jmsConfig.isSetConduitSelectorPrefix() || !exchange.isSynchronous() && !exchange.isOneWay() || this.jmsConfig.isSetUseConduitIdSelector() && this.jmsConfig.isUseConduitIdSelector())) {
                correlationId = null;
            } else {
                String prefix = this.jmsConfig.isUseConduitIdSelector() ? this.jmsConfig.getConduitSelectorPrefix() + this.conduitId : this.jmsConfig.getConduitSelectorPrefix();
                correlationId = JMSUtils.createCorrelationId(prefix, this.messageCount.incrementAndGet());
            }
        }
        return correlationId;
    }

    private JMSMessageHeadersType getOrCreateJmsHeaders(org.apache.cxf.message.Message outMessage) {
        JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.client.request.headers");
        if (headers == null) {
            headers = new JMSMessageHeadersType();
            outMessage.put((Object)"org.apache.cxf.jms.client.request.headers", (Object)headers);
        }
        return headers;
    }

    private synchronized void addBusListener() {
        BusLifeCycleManager blcm;
        if (this.listener == null && this.bus != null && (blcm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)) != null) {
            this.listener = new JMSBusLifeCycleListener(this, blcm);
        }
    }

    public void onMessage(Message jmsMessage) {
        String correlationId;
        try {
            correlationId = jmsMessage.getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        Exchange exchange = this.correlationMap.remove(correlationId);
        if (exchange == null) {
            LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
            return;
        }
        this.doReplyMessage(exchange, jmsMessage);
        this.maybeShutdownListeners();
    }

    private synchronized void maybeShutdownListenersInternal() {
        if (this.outstandingAsync == 0) {
            this.shutdownListeners();
        }
    }

    private synchronized void maybeShutdownListeners() {
        if (this.outstandingAsync > 0) {
            --this.outstandingAsync;
        }
        if (this.outstandingAsync == 0) {
            ((WorkQueueManager)this.bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue().execute(new Runnable(){

                public void run() {
                    JMSConduit.this.maybeShutdownListenersInternal();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReplyMessage(Exchange exchange, Message jmsMessage) {
        MessageImpl inMessage = new MessageImpl();
        exchange.setInMessage((org.apache.cxf.message.Message)inMessage);
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            JMSUtils.populateIncomingContext(jmsMessage, (org.apache.cxf.message.Message)inMessage, "org.apache.cxf.jms.client.response.headers", this.jmsConfig);
            JMSUtils.retrieveAndSetPayload((org.apache.cxf.message.Message)inMessage, jmsMessage, (String)inMessage.get((Object)org.apache.cxf.message.Message.ENCODING));
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put((Object)CORRELATED, (Object)Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    public synchronized void shutdownListeners() {
        if (this.listener != null) {
            this.listener.unreg();
            this.listener = null;
        }
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
            this.jmsListener = null;
        }
        if (this.allListener != null) {
            this.allListener.shutdown();
            this.allListener = null;
        }
    }

    public synchronized void close() {
        this.shutdownListeners();
        this.jmsConfig.destroyWrappedConnectionFactory();
        LOG.log(Level.FINE, "JMSConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected static boolean isSetReplyTo(org.apache.cxf.message.Message message) {
        Boolean ret = (Boolean)message.get((Object)"org.apache.cxf.jms.client.set.replyto");
        return ret == null || ret != null && ret != false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class JMSBusLifeCycleListener
    implements BusLifeCycleListener {
        final WeakReference<JMSConduit> ref;
        BusLifeCycleManager blcm;

        JMSBusLifeCycleListener(JMSConduit c, BusLifeCycleManager b) {
            this.ref = new WeakReference<JMSConduit>(c);
            this.blcm = b;
            this.blcm.registerLifeCycleListener((BusLifeCycleListener)this);
        }

        public void initComplete() {
        }

        public void postShutdown() {
        }

        public void preShutdown() {
            this.unreg();
            this.blcm = null;
            JMSConduit c = (JMSConduit)this.ref.get();
            if (c != null) {
                c.listener = null;
                c.close();
            }
        }

        public void unreg() {
            if (this.blcm != null) {
                this.blcm.unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }
}

