/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.transport.jms.uri.JMSEndpointType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSEndpoint
extends JMSEndpointType {
    Map<String, String> jndiParameters = new HashMap<String, String>();
    Map<String, String> parameters = new HashMap<String, String>();

    public JMSEndpoint(String endpointUri, String jmsVariant, String destinationName) {
        this.endpointUri = endpointUri;
        this.jmsVariant = jmsVariant;
        this.destinationName = destinationName;
    }

    public JMSEndpoint() {
        this.jmsVariant = "queue";
    }

    public String getRequestURI() {
        String requestUri = "jms:" + (this.jmsVariant == "jndi-topic" ? "jndi" : this.jmsVariant) + ":" + this.destinationName;
        boolean first = true;
        for (String key : this.parameters.keySet()) {
            if ("targetService".equals(key)) continue;
            String value = this.parameters.get(key);
            if (first) {
                requestUri = requestUri + "?" + key + "=" + value;
                first = false;
                continue;
            }
            requestUri = requestUri + "&" + key + "=" + value;
        }
        return requestUri;
    }

    public void putJndiParameter(String key, String value) {
        this.jndiParameters.put(key, value);
    }

    public void putParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, String> getJndiParameters() {
        return this.jndiParameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

