/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.workqueue.WorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSContinuation
implements Continuation {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSContinuation.class);
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Collection<JMSContinuation> continuations;
    private AbstractMessageListenerContainer jmsListener;
    private JMSConfiguration jmsConfig;
    private volatile Object userObject;
    private volatile boolean isNew = true;
    private volatile boolean isPending;
    private volatile boolean isResumed;
    private volatile boolean isCanceled;
    private WorkQueue workQueue;
    private ClassLoader loader;

    public JMSContinuation(Bus b, Message m, MessageObserver observer, Collection<JMSContinuation> cList, AbstractMessageListenerContainer jmsListener, JMSConfiguration jmsConfig) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
        this.jmsListener = jmsListener;
        this.jmsConfig = jmsConfig;
        WorkQueueManager manager = (WorkQueueManager)this.bus.getExtension(WorkQueueManager.class);
        if (manager != null) {
            this.workQueue = manager.getNamedWorkQueue("jms-continuation");
            if (this.workQueue == null) {
                this.workQueue = manager.getAutomaticWorkQueue();
            }
        } else {
            LOG.warning("ERROR_GETTING_WORK_QUEUE");
        }
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
    }

    public Object getObject() {
        return this.userObject;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public boolean isResumed() {
        return this.isResumed;
    }

    public synchronized void reset() {
        this.cancelTimerTask();
        this.isNew = true;
        this.isPending = false;
        this.isResumed = false;
        this.userObject = null;
    }

    public synchronized void resume() {
        if (this.isResumed || !this.isPending) {
            return;
        }
        this.isResumed = true;
        this.cancelTimerTask();
        this.doResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResume() {
        this.updateContinuations(true);
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            this.incomingObserver.onMessage(this.inMessage);
        }
        finally {
            this.isPending = false;
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    public void setObject(Object o) {
        this.userObject = o;
    }

    public synchronized boolean suspend(long timeout) {
        if (this.isPending) {
            return false;
        }
        this.inMessage.getExchange().getInMessage().getInterceptorChain().suspend();
        this.updateContinuations(false);
        this.isNew = false;
        this.isResumed = false;
        this.isPending = true;
        if (timeout > 0L) {
            this.createTimerTask(timeout);
        }
        return true;
    }

    protected void createTimerTask(long timeout) {
        this.workQueue.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JMSContinuation jMSContinuation = JMSContinuation.this;
                synchronized (jMSContinuation) {
                    if (JMSContinuation.this.isPending && !JMSContinuation.this.isCanceled) {
                        JMSContinuation.this.doResume();
                    }
                }
            }
        }, timeout);
    }

    protected synchronized void cancelTimerTask() {
        this.isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContinuations(boolean remove) {
        if (this.jmsConfig.getMaxSuspendedContinuations() < 0 || this.jmsListener instanceof DefaultMessageListenerContainer && ((DefaultMessageListenerContainer)this.jmsListener).getCacheLevel() >= 3) {
            this.modifyList(remove);
            return;
        }
        Collection<JMSContinuation> collection = this.continuations;
        synchronized (collection) {
            this.modifyList(remove);
            if (this.continuations.size() >= this.jmsConfig.getMaxSuspendedContinuations()) {
                this.jmsListener.stop();
            } else if (!this.jmsListener.isRunning()) {
                int limit = this.jmsConfig.getReconnectPercentOfMax();
                if (limit < 0 || limit > 100) {
                    limit = 70;
                }
                limit = limit * this.jmsConfig.getMaxSuspendedContinuations() / 100;
                if (this.continuations.size() <= limit) {
                    this.jmsListener.start();
                }
            }
        }
    }

    protected void modifyList(boolean remove) {
        if (remove) {
            this.continuations.remove(this);
        } else {
            this.continuations.add(this);
        }
    }
}

