/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSMessageUtils;
import org.apache.cxf.transport.jms.MessageStreamUtil;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.ResourceCloser;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap = new ConcurrentHashMap<String, Exchange>();
    private JMSListenerContainer jmsListener;
    private String conduitId;
    private AtomicLong messageCount;
    private JMSBusLifeCycleListener listener;
    private Bus bus;
    private Connection connection;
    private Destination staticReplyDestination;

    public JMSConduit(EndpointReferenceType target, JMSConfiguration jmsConfig, Bus b) {
        super(target);
        this.bus = b;
        this.jmsConfig = jmsConfig;
        this.conduitId = UUID.randomUUID().toString().replaceAll("-", "");
        this.messageCount = new AtomicLong(0L);
    }

    public void prepare(Message message) throws IOException {
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        MessageStreamUtil.prepareStream(message, isTextPayload, this);
    }

    public void close(Message msg) throws IOException {
        MessageStreamUtil.closeStreams(msg);
        super.close(msg);
    }

    private synchronized void getJMSListener(Destination replyTo) {
        if (this.jmsListener == null) {
            this.jmsListener = JMSFactory.createSimpleJmsListener(this.jmsConfig, this.connection, this, replyTo, this.conduitId);
            this.addBusListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendExchange(Exchange exchange, Object request) {
        Message outMessage;
        LOG.log(Level.FINE, "JMSConduit send message");
        Message message = outMessage = exchange.getOutMessage() == null ? exchange.getOutFaultMessage() : exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        this.jmsConfig.ensureProperlyConfigured();
        this.assertIsNotTextMessageAndMtom(outMessage);
        JMSMessageHeadersType headers = this.getOrCreateJmsHeaders(outMessage);
        String userCID = headers.getJMSCorrelationID();
        this.assertIsNotAsyncSyncAndUserCID(exchange, userCID);
        ResourceCloser closer = new ResourceCloser();
        try {
            if (this.connection == null) {
                this.connection = JMSFactory.createConnection(this.jmsConfig);
            }
            Session session = closer.register(this.connection.createSession(this.jmsConfig.isSessionTransacted(), 1));
            Destination targetDest = this.jmsConfig.getTargetDestination(session);
            Destination replyToDestination = null;
            if (!exchange.isOneWay()) {
                if (!exchange.isSynchronous() && this.staticReplyDestination == null) {
                    this.staticReplyDestination = this.jmsConfig.getReplyDestination(session);
                    this.getJMSListener(this.staticReplyDestination);
                }
                replyToDestination = this.jmsConfig.getReplyToDestination(session, headers.getJMSReplyTo());
            }
            this.connection.start();
            String messageType = this.jmsConfig.getMessageType();
            String correlationId = this.createCorrelationId(exchange, userCID);
            if (correlationId != null) {
                this.correlationMap.put(correlationId, exchange);
            }
            javax.jms.Message message2 = JMSMessageUtils.asJMSMessage(this.jmsConfig, outMessage, request, messageType, session, correlationId, "org.apache.cxf.jms.client.request.headers");
            if (replyToDestination != null) {
                message2.setJMSReplyTo(replyToDestination);
            }
            JMSSender sender = JMSFactory.createJmsSender(this.jmsConfig, headers);
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                sender.sendMessage(closer, session, targetDest, message2);
                LOG.log(Level.INFO, "client sending request message " + message2.getJMSMessageID() + " to " + targetDest);
                headers.setJMSMessageID(message2.getJMSMessageID());
                if (correlationId == null) {
                    correlationId = message2.getJMSMessageID();
                    this.correlationMap.put(correlationId, exchange);
                }
            }
            if (!exchange.isOneWay() && exchange.isSynchronous()) {
                Destination replyDestination = this.staticReplyDestination != null ? this.staticReplyDestination : replyToDestination;
                javax.jms.Message replyMessage = JMSUtil.receive(session, replyDestination, correlationId, this.jmsConfig.getReceiveTimeout(), this.jmsConfig.isPubSubNoLocal());
                this.correlationMap.remove(correlationId);
                this.doReplyMessage(exchange, replyMessage);
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            closer.close();
        }
    }

    private void assertIsNotAsyncSyncAndUserCID(Exchange exchange, String userCID) {
        if (!exchange.isSynchronous() && userCID != null) {
            throw new IllegalArgumentException("User CID can not be used for asynchronous exchanges");
        }
    }

    private void assertIsNotTextMessageAndMtom(Message outMessage) {
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        if (isTextPayload && MessageUtils.isTrue((Object)outMessage.getContextualProperty("mtom-enabled")) && outMessage.getAttachments() != null && outMessage.getAttachments().size() > 0) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
            throw new ConfigurationException(msg);
        }
    }

    private void assertIsNotSyncAndTopicReply(Exchange exchange) {
        if (exchange.isSynchronous() && this.jmsConfig.isReplyPubSubDomain()) {
            throw new IllegalArgumentException("Synchronous calls can not be combined with a response on a Topic");
        }
    }

    private String createCorrelationId(Exchange exchange, String userCID) {
        String correlationId = null;
        if (!exchange.isOneWay()) {
            if (userCID != null) {
                correlationId = userCID;
            } else if (!(this.jmsConfig.isSetConduitSelectorPrefix() || this.jmsConfig.isReplyPubSubDomain() || !exchange.isSynchronous() && !exchange.isOneWay() || this.jmsConfig.isSetUseConduitIdSelector() && this.jmsConfig.isUseConduitIdSelector())) {
                correlationId = null;
            } else {
                String prefix = this.jmsConfig.isUseConduitIdSelector() ? this.jmsConfig.getConduitSelectorPrefix() + this.conduitId : this.jmsConfig.getConduitSelectorPrefix();
                correlationId = JMSUtil.createCorrelationId(prefix, this.messageCount.incrementAndGet());
            }
        }
        return correlationId;
    }

    private JMSMessageHeadersType getOrCreateJmsHeaders(Message outMessage) {
        JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.client.request.headers");
        if (headers == null) {
            headers = new JMSMessageHeadersType();
            outMessage.put((Object)"org.apache.cxf.jms.client.request.headers", (Object)headers);
        }
        return headers;
    }

    private synchronized void addBusListener() {
        BusLifeCycleManager blcm;
        if (this.listener == null && this.bus != null && (blcm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)) != null) {
            this.listener = new JMSBusLifeCycleListener(this, blcm);
        }
    }

    public void onMessage(javax.jms.Message jmsMessage) {
        try {
            String correlationId = jmsMessage.getJMSCorrelationID();
            LOG.log(Level.INFO, "Received reply message with correlation id " + correlationId);
            Exchange exchange = null;
            for (int count = 0; exchange == null && count < 100; ++count) {
                exchange = this.correlationMap.remove(correlationId);
                Thread.sleep(100L);
            }
            if (exchange == null) {
                LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
                return;
            }
            this.doReplyMessage(exchange, jmsMessage);
        }
        catch (JMSException e) {
            throw JMSUtil.convertJmsException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while correlating", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReplyMessage(Exchange exchange, javax.jms.Message jmsMessage) throws JMSException {
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            Message inMessage = JMSMessageUtils.asCXFMessage(jmsMessage, "org.apache.cxf.jms.client.response.headers");
            SecurityContext securityContext = JMSMessageUtils.buildSecurityContext(jmsMessage, this.jmsConfig);
            inMessage.put(SecurityContext.class, (Object)securityContext);
            exchange.setInMessage(inMessage);
            Object responseCode = inMessage.get((Object)Message.RESPONSE_CODE);
            exchange.put((Object)Message.RESPONSE_CODE, responseCode);
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put((Object)CORRELATED, (Object)Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    public synchronized void shutdownListeners() {
        if (this.listener != null) {
            this.listener.unreg();
            this.listener = null;
        }
        if (this.jmsListener != null) {
            this.jmsListener.stop();
            this.jmsListener.shutdown();
            this.jmsListener = null;
        }
    }

    public synchronized void close() {
        this.shutdownListeners();
        ResourceCloser.close(this.connection);
        this.connection = null;
        LOG.log(Level.FINE, "JMSConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected static boolean isSetReplyTo(Message message) {
        Boolean ret = (Boolean)message.get((Object)"org.apache.cxf.jms.client.set.replyto");
        return ret == null || ret != false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class JMSBusLifeCycleListener
    implements BusLifeCycleListener {
        final WeakReference<JMSConduit> ref;
        BusLifeCycleManager blcm;

        JMSBusLifeCycleListener(JMSConduit c, BusLifeCycleManager b) {
            this.ref = new WeakReference<JMSConduit>(c);
            this.blcm = b;
            this.blcm.registerLifeCycleListener((BusLifeCycleListener)this);
        }

        public void initComplete() {
        }

        public void postShutdown() {
        }

        public void preShutdown() {
            this.unreg();
            this.blcm = null;
            JMSConduit c = (JMSConduit)this.ref.get();
            if (c != null) {
                c.listener = null;
                c.close();
            }
        }

        public void unreg() {
            if (this.blcm != null) {
                this.blcm.unregisterLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }
}

