/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.jms.JMSConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;
import org.apache.cxf.transport.jms.JMSOldConfigHolder;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@NoJSR250Annotations
public class JMSTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/jms", "http://cxf.apache.org/transports/jms/configuration");
    private static final Set<String> URI_PREFIXES = new HashSet<String>();

    public JMSTransportFactory() {
        super(DEFAULT_NAMESPACES);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, Bus b) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget(), b);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target, Bus bus) throws IOException {
        JMSOldConfigHolder old = new JMSOldConfigHolder();
        JMSConfiguration jmsConf = old.createJMSConfigurationFromEndpointInfo(bus, endpointInfo, target, true);
        return new JMSConduit(target, jmsConf, bus);
    }

    public Destination getDestination(EndpointInfo endpointInfo, Bus bus) throws IOException {
        JMSOldConfigHolder old = new JMSOldConfigHolder();
        JMSConfiguration jmsConf = old.createJMSConfigurationFromEndpointInfo(bus, endpointInfo, null, false);
        return new JMSDestination(bus, endpointInfo, jmsConf);
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    static {
        URI_PREFIXES.add("jms://");
        URI_PREFIXES.add("jms:");
    }
}

