/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.transport.jms.uri.UnsafeUriCharactersEncoder;

final class JMSURIParser {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSURIParser.class);
    String uri;
    int pos;
    private String scheme;
    private String variant;
    private String destination;
    private String query;

    public JMSURIParser(String uri) {
        this.uri = UnsafeUriCharactersEncoder.encode(uri);
        this.scheme = this.parseUntil(":");
        this.variant = this.parseUntil(":");
        this.destination = this.parseUntil("?");
        String rest = this.parseToEnd();
        if (this.destination == null) {
            this.destination = rest;
            this.query = null;
        } else {
            this.query = rest;
        }
        LOG.log(Level.FINE, "Creating endpoint uri=[" + uri + "], destination=[" + this.destination + "], query=[" + this.query + "]");
    }

    private String parseToEnd() {
        return this.uri.substring(this.pos, this.uri.length());
    }

    private String parseUntil(String separator) {
        int separatorPos = this.uri.indexOf(separator, this.pos);
        if (separatorPos != -1) {
            String found = this.uri.substring(this.pos, separatorPos);
            this.pos = separatorPos + 1;
            return found;
        }
        return null;
    }

    public Map<String, String> parseQuery() {
        HashMap<String, String> rc = new HashMap<String, String>();
        if (this.query != null) {
            String[] parameters;
            for (String parameter : parameters = StringUtils.split((String)this.query, (String)"&")) {
                int p = parameter.indexOf("=");
                if (p >= 0) {
                    String name = JMSURIParser.urldecode(parameter.substring(0, p));
                    String value = JMSURIParser.urldecode(parameter.substring(p + 1));
                    rc.put(name, value);
                    continue;
                }
                rc.put(parameter, null);
            }
        }
        return rc;
    }

    private static String urldecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Encoding UTF-8 not supported");
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getDestination() {
        return this.destination;
    }
}

