/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSMessageUtils;
import org.apache.cxf.transport.jms.MessageStreamUtil;
import org.apache.cxf.transport.jms.util.JMSSender;
import org.apache.cxf.transport.jms.util.JMSUtil;
import org.apache.cxf.transport.jms.util.ResourceCloser;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;

class BackChannelConduit
extends AbstractConduit
implements JMSExchangeSender {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    private JMSConfiguration jmsConfig;
    private Message inMessage;
    private Connection connection;

    BackChannelConduit(Message inMessage, JMSConfiguration jmsConfig, Connection connection) {
        super(EndpointReferenceUtils.getAnonymousEndpointReference());
        this.inMessage = inMessage;
        this.jmsConfig = jmsConfig;
        this.connection = connection;
    }

    public void close(Message msg) throws IOException {
        MessageStreamUtil.closeStreams(msg);
        super.close(msg);
    }

    public void setMessageObserver(MessageObserver observer) {
    }

    public void prepare(Message message) throws IOException {
        javax.jms.Message jmsMessage = (javax.jms.Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
        message.put((Object)"org.apache.cxf.jms.request.message", (Object)jmsMessage);
        if (!message.containsKey((Object)"org.apache.cxf.jms.server.response.headers") && this.inMessage.containsKey((Object)"org.apache.cxf.jms.server.response.headers")) {
            message.put((Object)"org.apache.cxf.jms.server.response.headers", this.inMessage.get((Object)"org.apache.cxf.jms.server.response.headers"));
        }
        Exchange exchange = this.inMessage.getExchange();
        exchange.setOutMessage(message);
        boolean isTextMessage = jmsMessage instanceof TextMessage && !JMSMessageUtils.isMtomEnabled(message);
        MessageStreamUtil.prepareStream(message, isTextMessage, this);
    }

    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void sendExchange(Exchange exchange, Object replyObj) {
        if (exchange.isOneWay()) {
            return;
        }
        Message outMessage = exchange.getOutMessage();
        ResourceCloser closer = new ResourceCloser();
        try {
            Session session = closer.register(this.connection.createSession(false, 1));
            JMSMessageHeadersType messageProperties = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.server.response.headers");
            JMSMessageHeadersType inMessageProperties = (JMSMessageHeadersType)this.inMessage.get((Object)"org.apache.cxf.jms.server.request.headers");
            BackChannelConduit.initResponseMessageProperties(messageProperties, inMessageProperties);
            javax.jms.Message request = (javax.jms.Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
            String msgType = JMSMessageUtils.isMtomEnabled(outMessage) && !this.jmsConfig.getMessageType().equals("text") ? this.jmsConfig.getMessageType() : JMSMessageUtils.getMessageType(request);
            if ("text".equals(msgType) && JMSMessageUtils.isMtomEnabled(outMessage)) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
                throw new ConfigurationException(msg);
            }
            if (this.isTimedOut(request)) {
                return;
            }
            Destination replyTo = this.getReplyToDestination(session, this.inMessage);
            if (replyTo == null) {
                throw new RuntimeException("No replyTo destination set");
            }
            this.getLogger().log(Level.FINE, "send out the message!");
            String correlationId = this.determineCorrelationID(request);
            javax.jms.Message reply = JMSMessageUtils.asJMSMessage(this.jmsConfig, outMessage, replyObj, msgType, session, correlationId, "org.apache.cxf.jms.server.response.headers");
            JMSSender sender = JMSFactory.createJmsSender(this.jmsConfig, messageProperties);
            LOG.log(Level.FINE, "server sending reply: ", reply);
            sender.sendMessage(session, replyTo, reply);
        }
        catch (JMSException ex) {
            throw JMSUtil.convertJmsException(ex);
        }
        finally {
            closer.close();
        }
    }

    public static void initResponseMessageProperties(JMSMessageHeadersType messageProperties, JMSMessageHeadersType inMessageProperties) {
        messageProperties.setJMSDeliveryMode(inMessageProperties.getJMSDeliveryMode());
        messageProperties.setJMSPriority(inMessageProperties.getJMSPriority());
        messageProperties.setSOAPJMSRequestURI(inMessageProperties.getSOAPJMSRequestURI());
        messageProperties.setSOAPJMSBindingVersion("1.0");
    }

    private boolean isTimedOut(javax.jms.Message request) throws JMSException {
        if (request.getJMSExpiration() > 0L) {
            SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
            GregorianCalendar cal = new GregorianCalendar(tz);
            long timeToLive = request.getJMSExpiration() - cal.getTimeInMillis();
            if (timeToLive < 0L) {
                this.getLogger().log(Level.INFO, "Message time to live is already expired skipping response.");
                return true;
            }
        }
        return false;
    }

    private Destination getReplyToDestination(Session session, Message inMessage2) throws JMSException {
        javax.jms.Message message = (javax.jms.Message)inMessage2.get((Object)"org.apache.cxf.jms.request.message");
        String replyToName = (String)inMessage2.get((Object)"org.apache.cxf.jms.server.replyto");
        if (replyToName != null) {
            return this.jmsConfig.getReplyDestination(session, replyToName);
        }
        if (message.getJMSReplyTo() != null) {
            return message.getJMSReplyTo();
        }
        return this.jmsConfig.getReplyDestination(session);
    }

    public String determineCorrelationID(javax.jms.Message request) throws JMSException {
        return StringUtils.isEmpty((String)request.getJMSCorrelationID()) ? request.getJMSMessageID() : request.getJMSCorrelationID();
    }
}

