/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.util.AbstractMessageListenerContainer;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class PollingMessageListenerContainer
extends AbstractMessageListenerContainer {
    private static final Logger LOG = LogUtils.getL7dLogger(PollingMessageListenerContainer.class);
    private ExecutorService pollers;
    private int concurrentConsumers = 1;

    public PollingMessageListenerContainer(Connection connection, Destination destination, MessageListener listenerHandler) {
        this.connection = connection;
        this.destination = destination;
        this.listenerHandler = listenerHandler;
    }

    private MessageConsumer createConsumer(Session session) throws JMSException {
        if (this.durableSubscriptionName != null && this.destination instanceof Topic) {
            return session.createDurableSubscriber((Topic)this.destination, this.durableSubscriptionName, this.messageSelector, this.pubSubNoLocal);
        }
        return session.createConsumer(this.destination, this.messageSelector);
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.pollers = Executors.newFixedThreadPool(this.concurrentConsumers);
        for (int c = 0; c < this.concurrentConsumers; ++c) {
            Runnable poller = this.transactionManager != null ? new XAPoller() : new Poller();
            this.pollers.execute(poller);
        }
    }

    @Override
    public void stop() {
        LOG.fine("Shuttting down " + this.getClass().getSimpleName());
        if (!this.running) {
            return;
        }
        this.running = false;
        this.pollers.shutdown();
        try {
            this.pollers.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pollers.shutdownNow();
        this.pollers = null;
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    private class XAPoller
    implements Runnable {
        private XAPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (PollingMessageListenerContainer.this.running) {
                MessageConsumer consumer = null;
                Session session = null;
                try {
                    PollingMessageListenerContainer.this.transactionManager.begin();
                    session = PollingMessageListenerContainer.this.connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode);
                    consumer = PollingMessageListenerContainer.this.createConsumer(session);
                    Message message = consumer.receive(1000L);
                    try {
                        if (message != null) {
                            PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                        }
                        PollingMessageListenerContainer.this.transactionManager.commit();
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", e);
                        this.safeRollBack(session);
                    }
                    finally {
                        ResourceCloser.close(consumer);
                        ResourceCloser.close(session);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unexpected exception. Restarting session and consumer", e);
                }
            }
        }

        private void safeRollBack(Session session) {
            try {
                PollingMessageListenerContainer.this.transactionManager.rollback();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Rollback of XA transaction failed", e);
            }
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (PollingMessageListenerContainer.this.running) {
                MessageConsumer consumer = null;
                Session session = null;
                try {
                    session = PollingMessageListenerContainer.this.connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode);
                    consumer = PollingMessageListenerContainer.this.createConsumer(session);
                    while (PollingMessageListenerContainer.this.running) {
                        Message message = consumer.receive(1000L);
                        try {
                            if (message != null) {
                                PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                            }
                            if (!session.getTransacted()) continue;
                            session.commit();
                        }
                        catch (Throwable e) {
                            if (e instanceof Exception) {
                                LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", (Exception)e);
                            }
                            this.safeRollBack(session, e);
                        }
                    }
                }
                catch (Throwable e) {
                    try {
                        if (!(e instanceof Exception)) continue;
                        LOG.log(Level.WARNING, "Unexpected exception. Restarting session and consumer", (Exception)e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        ResourceCloser.close(consumer);
                        ResourceCloser.close(session);
                        continue;
                    }
                }
                ResourceCloser.close(consumer);
                ResourceCloser.close(session);
            }
        }

        private void safeRollBack(Session session, Throwable e) {
            try {
                if (session.getTransacted()) {
                    session.rollback();
                }
            }
            catch (Throwable e1) {
                LOG.log(Level.WARNING, "Rollback of Local transaction failed", e1);
            }
        }
    }
}

