/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.Transaction;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.util.AbstractMessageListenerContainer;
import org.apache.cxf.transport.jms.util.ResourceCloser;

public class PollingMessageListenerContainer
extends AbstractMessageListenerContainer {
    private static final Logger LOG = LogUtils.getL7dLogger(PollingMessageListenerContainer.class);
    private ExceptionListener exceptionListener;

    public PollingMessageListenerContainer(Connection connection, Destination destination, MessageListener listenerHandler, ExceptionListener exceptionListener) {
        this.connection = connection;
        this.destination = destination;
        this.listenerHandler = listenerHandler;
        this.exceptionListener = exceptionListener;
    }

    private MessageConsumer createConsumer(Session session) throws JMSException {
        if (this.durableSubscriptionName != null && this.destination instanceof Topic) {
            return session.createDurableSubscriber((Topic)this.destination, this.durableSubscriptionName, this.messageSelector, this.pubSubNoLocal);
        }
        return session.createConsumer(this.destination, this.messageSelector);
    }

    protected void handleException(Throwable e) {
        JMSException wrapped;
        this.running = false;
        if (e instanceof JMSException) {
            wrapped = (JMSException)e;
        } else {
            wrapped = new JMSException("Wrapped exception. " + e.getMessage());
            wrapped.addSuppressed(e);
        }
        this.exceptionListener.onException(wrapped);
    }

    @Override
    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        for (int c = 0; c < this.getConcurrentConsumers(); ++c) {
            Runnable poller = this.transactionManager != null ? new XAPoller() : new Poller();
            this.getExecutor().execute(poller);
        }
    }

    @Override
    public void stop() {
        LOG.fine("Shuttting down " + this.getClass().getSimpleName());
        if (!this.running) {
            return;
        }
        this.running = false;
        super.stop();
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    private class XAPoller
    implements Runnable {
        private XAPoller() {
        }

        @Override
        public void run() {
            while (PollingMessageListenerContainer.this.running) {
                try {
                    ResourceCloser closer = new ResourceCloser();
                    Throwable throwable = null;
                    try {
                        closer.register(PollingMessageListenerContainer.this.createInitialContext());
                        Transaction externalTransaction = PollingMessageListenerContainer.this.transactionManager.getTransaction();
                        if (externalTransaction != null && externalTransaction.getStatus() == 0) {
                            LOG.log(Level.SEVERE, "External transactions are not supported in XAPoller");
                            throw new IllegalStateException("External transactions are not supported in XAPoller");
                        }
                        PollingMessageListenerContainer.this.transactionManager.begin();
                        Session session = closer.register(PollingMessageListenerContainer.this.connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode));
                        MessageConsumer consumer = closer.register(PollingMessageListenerContainer.this.createConsumer(session));
                        Message message = consumer.receive(1000L);
                        try {
                            if (message != null) {
                                PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                            }
                            PollingMessageListenerContainer.this.transactionManager.commit();
                        }
                        catch (Throwable e) {
                            LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", e);
                            this.safeRollBack(session);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (closer == null) continue;
                        if (throwable != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        closer.close();
                    }
                }
                catch (Throwable e) {
                    PollingMessageListenerContainer.this.handleException(e);
                }
            }
        }

        protected void safeRollBack(Session session) {
            try {
                PollingMessageListenerContainer.this.transactionManager.rollback();
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Rollback of XA transaction failed", e);
            }
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        @Override
        public void run() {
            Session session = null;
            while (PollingMessageListenerContainer.this.running) {
                try {
                    ResourceCloser closer = new ResourceCloser();
                    Throwable throwable = null;
                    try {
                        closer.register(PollingMessageListenerContainer.this.createInitialContext());
                        session = closer.register(PollingMessageListenerContainer.this.connection.createSession(PollingMessageListenerContainer.this.transacted, PollingMessageListenerContainer.this.acknowledgeMode));
                        MessageConsumer consumer = closer.register(PollingMessageListenerContainer.this.createConsumer(session));
                        while (PollingMessageListenerContainer.this.running) {
                            Message message = consumer.receive(1000L);
                            try {
                                if (message != null) {
                                    PollingMessageListenerContainer.this.listenerHandler.onMessage(message);
                                }
                                if (!session.getTransacted()) continue;
                                session.commit();
                            }
                            catch (Throwable e) {
                                LOG.log(Level.WARNING, "Exception while processing jms message in cxf. Rolling back", e);
                                this.safeRollBack(session);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (closer == null) continue;
                        if (throwable != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        closer.close();
                    }
                }
                catch (Throwable e) {
                    PollingMessageListenerContainer.this.handleException(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void safeRollBack(Session session) {
            try {
                if (session != null && session.getTransacted()) {
                    session.rollback();
                }
            }
            catch (Throwable e1) {
                LOG.log(Level.WARNING, "Rollback of Local transaction failed", e1);
            }
        }
    }
}

