/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.IOException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereWebSocketServletDestination;
import org.apache.cxf.transport.websocket.jetty.JettyWebSocketDestination;
import org.apache.cxf.transport.websocket.jetty.JettyWebSocketServletDestination;

@NoJSR250Annotations
public class WebSocketDestinationFactory
implements HttpDestinationFactory {
    private static final boolean ATMOSPHERE_AVAILABLE = WebSocketDestinationFactory.probeClass("org.atmosphere.cpr.ApplicationConfig");

    private static boolean probeClass(String name) {
        try {
            Class.forName(name, true, WebSocketDestinationFactory.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public AbstractHTTPDestination createDestination(EndpointInfo endpointInfo, Bus bus, DestinationRegistry registry) throws IOException {
        if (endpointInfo.getAddress().startsWith("ws")) {
            JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)bus.getExtension(JettyHTTPServerEngineFactory.class);
            return new JettyWebSocketDestination(bus, registry, endpointInfo, serverEngineFactory);
        }
        registry = WebSocketDestinationFactory.getDestinationRegistry(bus);
        if (ATMOSPHERE_AVAILABLE) {
            return new AtmosphereWebSocketServletDestination(bus, registry, endpointInfo, endpointInfo.getAddress());
        }
        return new JettyWebSocketServletDestination(bus, registry, endpointInfo, endpointInfo.getAddress());
    }

    private static DestinationRegistry getDestinationRegistry(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

