/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

public final class WebSocketUtils {
    static final String URI_KEY = "$uri";
    static final String METHOD_KEY = "$method";
    static final String SC_KEY = "$sc";
    static final String SM_KEY = "$sm";
    static final String FLUSHED_KEY = "$flushed";
    private static final String CRLF = "\r\n";
    private static final String COLSP = ": ";
    private static final String DEFAULT_SC = "200";

    private WebSocketUtils() {
    }

    public static Map<String, String> readHeaders(InputStream in) throws IOException {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String line = WebSocketUtils.readLine(in);
        int del = line.indexOf(32);
        if (del < 0) {
            throw new IOException("invalid request: " + line);
        }
        headers.put(METHOD_KEY, line.substring(0, del).trim());
        headers.put(URI_KEY, line.substring(del + 1).trim());
        while ((line = WebSocketUtils.readLine(in)) != null) {
            if (line.length() <= 0) continue;
            del = line.indexOf(58);
            if (del < 0) {
                headers.put(line.trim(), "");
                continue;
            }
            headers.put(line.substring(0, del).trim(), line.substring(del + 1).trim());
        }
        return headers;
    }

    public static String readLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(128);
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            buffer.append((char)c);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public static byte[] buildResponse(Map<String, String> headers, byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        String v = headers.get(SC_KEY);
        sb.append(v == null ? DEFAULT_SC : v).append(CRLF);
        WebSocketUtils.appendHeaders(headers, sb);
        sb.append(CRLF);
        byte[] longdata = sb.toString().getBytes();
        if (data != null && length > 0) {
            byte[] hb = longdata;
            longdata = new byte[hb.length + length];
            System.arraycopy(hb, 0, longdata, 0, hb.length);
            System.arraycopy(data, offset, longdata, hb.length, length);
        }
        return longdata;
    }

    public static byte[] buildResponse(byte[] data, int offset, int length) {
        byte[] longdata = new byte[length + 2];
        longdata[0] = 13;
        longdata[1] = 10;
        System.arraycopy(data, offset, longdata, 2, length);
        return longdata;
    }

    public static byte[] buildRequest(String method, String url, Map<String, String> headers, byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append(method).append(' ').append(url).append(CRLF);
        WebSocketUtils.appendHeaders(headers, sb);
        sb.append(CRLF);
        byte[] longdata = sb.toString().getBytes();
        if (data != null && length > 0) {
            byte[] hb = longdata;
            longdata = new byte[hb.length + length];
            System.arraycopy(hb, 0, longdata, 0, hb.length);
            System.arraycopy(data, offset, longdata, hb.length, length);
        }
        return longdata;
    }

    private static void appendHeaders(Map<String, String> headers, StringBuilder sb) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey().startsWith("$")) continue;
            sb.append(header.getKey()).append(COLSP).append(header.getValue()).append(CRLF);
        }
    }
}

