/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.WebSocketUtils;

public class WebSocketVirtualServletRequest
implements HttpServletRequest {
    private static final Logger LOG = LogUtils.getL7dLogger(WebSocketVirtualServletRequest.class);
    private WebSocketServletHolder webSocketHolder;
    private InputStream in;
    private Map<String, String> requestHeaders;
    private Map<String, Object> attributes;

    public WebSocketVirtualServletRequest(WebSocketServletHolder websocket, InputStream in) throws IOException {
        this.webSocketHolder = websocket;
        this.in = in;
        this.requestHeaders = WebSocketUtils.readHeaders(in);
        String path = this.requestHeaders.get("$uri");
        String origin = websocket.getRequestURI();
        if (!path.startsWith(origin)) {
            LOG.log(Level.WARNING, "invalid path: {0} not within {1}", new Object[]{path, origin});
            throw new InvalidPathException();
        }
        this.attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Object v = websocket.getAttribute("org.apache.cxf.transport.endpoint.address");
        if (v != null) {
            this.attributes.put("org.apache.cxf.transport.endpoint.address", v);
        }
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public Object getAttribute(String name) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "getAttribute({0})", name);
        }
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        LOG.log(Level.INFO, "getAttributeNames()");
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        LOG.log(Level.INFO, "getCharacterEncoding()");
        return null;
    }

    public int getContentLength() {
        LOG.log(Level.INFO, "getContentLength()");
        return 0;
    }

    public String getContentType() {
        LOG.log(Level.INFO, "getContentType()");
        return this.requestHeaders.get("Content-Type");
    }

    public DispatcherType getDispatcherType() {
        LOG.log(Level.INFO, "getDispatcherType()");
        return this.webSocketHolder.getDispatcherType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return WebSocketVirtualServletRequest.this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return WebSocketVirtualServletRequest.this.in.read(b, off, len);
            }
        };
    }

    public String getLocalAddr() {
        LOG.log(Level.INFO, "getLocalAddr()");
        return this.webSocketHolder.getLocalAddr();
    }

    public String getLocalName() {
        LOG.log(Level.INFO, "getLocalName()");
        return this.webSocketHolder.getLocalName();
    }

    public int getLocalPort() {
        LOG.log(Level.INFO, "getLocalPort()");
        return this.webSocketHolder.getLocalPort();
    }

    public Locale getLocale() {
        LOG.log(Level.INFO, "getLocale()");
        return this.webSocketHolder.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        LOG.log(Level.INFO, "getLocales()");
        return this.webSocketHolder.getLocales();
    }

    public String getParameter(String name) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "getParameter({0})", name);
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LOG.log(Level.INFO, "getParameterMap()");
        return null;
    }

    public Enumeration<String> getParameterNames() {
        LOG.log(Level.INFO, "getParameterNames()");
        return null;
    }

    public String[] getParameterValues(String name) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "getParameterValues({0})", name);
        }
        return null;
    }

    public String getProtocol() {
        LOG.log(Level.INFO, "getProtocol");
        return this.webSocketHolder.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        LOG.log(Level.INFO, "getReader");
        return new BufferedReader(new InputStreamReader(this.in, "utf-8"));
    }

    public String getRealPath(String path) {
        LOG.log(Level.INFO, "getRealPath");
        return null;
    }

    public String getRemoteAddr() {
        LOG.log(Level.INFO, "getRemoteAddr");
        return this.webSocketHolder.getRemoteAddr();
    }

    public String getRemoteHost() {
        LOG.log(Level.INFO, "getRemoteHost");
        return this.webSocketHolder.getRemoteHost();
    }

    public int getRemotePort() {
        LOG.log(Level.INFO, "getRemotePort");
        return this.webSocketHolder.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        LOG.log(Level.INFO, "getRequestDispatcher");
        return null;
    }

    public String getScheme() {
        LOG.log(Level.INFO, "getScheme");
        return this.webSocketHolder.getScheme();
    }

    public String getServerName() {
        return this.webSocketHolder.getServerName();
    }

    public int getServerPort() {
        LOG.log(Level.INFO, "getServerPort");
        return this.webSocketHolder.getServerPort();
    }

    public ServletContext getServletContext() {
        LOG.log(Level.INFO, "getServletContext");
        return this.webSocketHolder.getServletContext();
    }

    public boolean isAsyncStarted() {
        LOG.log(Level.INFO, "isAsyncStarted");
        return false;
    }

    public boolean isAsyncSupported() {
        LOG.log(Level.INFO, "isAsyncSupported");
        return false;
    }

    public boolean isSecure() {
        LOG.log(Level.INFO, "isSecure");
        return this.webSocketHolder.isSecure();
    }

    public void removeAttribute(String name) {
        LOG.log(Level.INFO, "removeAttribute");
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        LOG.log(Level.INFO, "setAttribute");
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        LOG.log(Level.INFO, "setCharacterEncoding");
    }

    public AsyncContext startAsync() {
        LOG.log(Level.INFO, "startAsync");
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        LOG.log(Level.INFO, "startAsync");
        return null;
    }

    public boolean authenticate(HttpServletResponse servletResponse) throws IOException, ServletException {
        LOG.log(Level.INFO, "authenticate");
        return false;
    }

    public String getAuthType() {
        LOG.log(Level.INFO, "getAuthType");
        return this.webSocketHolder.getAuthType();
    }

    public String getContextPath() {
        LOG.log(Level.INFO, "getContextPath");
        return this.webSocketHolder.getContextPath();
    }

    public Cookie[] getCookies() {
        LOG.log(Level.INFO, "getCookies");
        return null;
    }

    public long getDateHeader(String name) {
        LOG.log(Level.INFO, "getDateHeader");
        return 0L;
    }

    public String getHeader(String name) {
        LOG.log(Level.INFO, "getHeader");
        return this.requestHeaders.get(name);
    }

    public Enumeration<String> getHeaderNames() {
        LOG.log(Level.INFO, "getHeaderNames");
        return Collections.enumeration(this.requestHeaders.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        LOG.log(Level.INFO, "getHeaders");
        return Collections.enumeration(Arrays.asList(this.requestHeaders.get(name)));
    }

    public int getIntHeader(String name) {
        LOG.log(Level.INFO, "getIntHeader");
        String v = this.requestHeaders.get(name);
        return v == null ? -1 : Integer.parseInt(v);
    }

    public String getMethod() {
        LOG.log(Level.INFO, "getMethod");
        return this.requestHeaders.get("$method");
    }

    public Part getPart(String name) throws IOException, ServletException {
        LOG.log(Level.INFO, "getPart");
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        LOG.log(Level.INFO, "getParts");
        return null;
    }

    public String getPathInfo() {
        LOG.log(Level.INFO, "getPathInfo");
        String uri = this.requestHeaders.get("$uri");
        String servletpath = this.webSocketHolder.getServletPath();
        return uri.substring(servletpath.length());
    }

    public String getPathTranslated() {
        LOG.log(Level.INFO, "getPathTranslated");
        String path = this.getPathInfo();
        String opathtrans = this.webSocketHolder.getPathTranslated();
        if (opathtrans == null) {
            return null;
        }
        String opathinfo = this.webSocketHolder.getPathInfo();
        int pos = opathtrans.indexOf(opathinfo);
        return opathtrans.substring(0, pos) + path;
    }

    public String getQueryString() {
        LOG.log(Level.INFO, "getQueryString");
        return null;
    }

    public String getRemoteUser() {
        LOG.log(Level.INFO, "getRemoteUser");
        return null;
    }

    public String getRequestURI() {
        LOG.log(Level.INFO, "getRequestURI");
        return this.requestHeaders.get("$uri");
    }

    public StringBuffer getRequestURL() {
        LOG.log(Level.INFO, "getRequestURL");
        StringBuffer sb = this.webSocketHolder.getRequestURL();
        String ouri = this.webSocketHolder.getRequestURI();
        String uri = this.getRequestURI();
        sb.append(uri.substring(ouri.length()));
        return sb;
    }

    public String getRequestedSessionId() {
        LOG.log(Level.INFO, "getRequestedSessionId");
        return null;
    }

    public String getServletPath() {
        LOG.log(Level.INFO, "getServletPath");
        return this.webSocketHolder.getServletPath();
    }

    public HttpSession getSession() {
        LOG.log(Level.INFO, "getSession");
        return null;
    }

    public HttpSession getSession(boolean create) {
        LOG.log(Level.INFO, "getSession");
        return null;
    }

    public Principal getUserPrincipal() {
        LOG.log(Level.INFO, "getUserPrincipal");
        return this.webSocketHolder.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        LOG.log(Level.INFO, "isRequestedSessionIdFromCookie");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        LOG.log(Level.INFO, "isRequestedSessionIdFromURL");
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        LOG.log(Level.INFO, "isRequestedSessionIdFromUrl");
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        LOG.log(Level.INFO, "isRequestedSessionIdValid");
        return false;
    }

    public boolean isUserInRole(String role) {
        LOG.log(Level.INFO, "isUserInRole");
        return false;
    }

    public void login(String username, String password) throws ServletException {
        LOG.log(Level.INFO, "login");
    }

    public void logout() throws ServletException {
        LOG.log(Level.INFO, "logout");
    }
}

