/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.WebSocketUtils;

public class WebSocketVirtualServletResponse
implements HttpServletResponse {
    private static final Logger LOG = LogUtils.getL7dLogger(WebSocketVirtualServletResponse.class);
    private WebSocketServletHolder webSocketHolder;
    private Map<String, String> responseHeaders;
    private ServletOutputStream outputStream;

    public WebSocketVirtualServletResponse(WebSocketServletHolder websocket) {
        this.webSocketHolder = websocket;
        this.responseHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.outputStream = this.createOutputStream();
    }

    public void flushBuffer() throws IOException {
        LOG.log(Level.INFO, "flushBuffer()");
    }

    public int getBufferSize() {
        LOG.log(Level.INFO, "getBufferSize()");
        return 0;
    }

    public String getCharacterEncoding() {
        LOG.log(Level.INFO, "getCharacterEncoding()");
        return null;
    }

    public String getContentType() {
        LOG.log(Level.INFO, "getContentType()");
        return this.responseHeaders.get("Content-Type");
    }

    public Locale getLocale() {
        LOG.log(Level.INFO, "getLocale");
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        LOG.log(Level.INFO, "getWriter()");
        return new PrintWriter((OutputStream)this.getOutputStream());
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
        LOG.log(Level.INFO, "resetBuffer()");
    }

    public void setBufferSize(int size) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setBufferSize({0})", size);
        }
    }

    public void setCharacterEncoding(String charset) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setCharacterEncoding({0})", charset);
        }
    }

    public void setContentLength(int len) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setContentLength({0})", len);
        }
        this.responseHeaders.put("Content-Length", Integer.toString(len));
    }

    public void setContentType(String type) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setContentType({0})", type);
        }
        this.responseHeaders.put("Content-Type", type);
    }

    public void setLocale(Locale loc) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setLocale({0})", loc);
        }
    }

    public void addCookie(Cookie cookie) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "addCookie({0})", cookie);
        }
    }

    public void addDateHeader(String name, long date) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "addDateHeader({0}, {1})", new Object[]{name, date});
        }
    }

    public void addHeader(String name, String value) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "addHeader({0}, {1})", new Object[]{name, value});
        }
        this.responseHeaders.put(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "addIntHeader({0}, {1})", new Object[]{name, value});
        }
        this.responseHeaders.put(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "containsHeader({0})", name);
        }
        return this.responseHeaders.containsKey(name);
    }

    public String encodeRedirectURL(String url) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "encodeRedirectURL({0})", url);
        }
        return null;
    }

    public String encodeRedirectUrl(String url) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "encodeRedirectUrl({0})", url);
        }
        return null;
    }

    public String encodeURL(String url) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "encodeURL({0})", url);
        }
        return null;
    }

    public String encodeUrl(String url) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "encodeUrl({0})", url);
        }
        return null;
    }

    public String getHeader(String name) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "getHeader({0})", name);
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        LOG.log(Level.INFO, "getHeaderNames()");
        return null;
    }

    public Collection<String> getHeaders(String name) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "getHeaders({0})", name);
        }
        return null;
    }

    public int getStatus() {
        LOG.log(Level.INFO, "getStatus()");
        String v = this.responseHeaders.get("$sc");
        return v == null ? 200 : Integer.parseInt(v);
    }

    public void sendError(int sc) throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "sendError{0}", sc);
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
    }

    public void sendError(int sc, String msg) throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "sendError({0}, {1})", new Object[]{sc, msg});
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
        this.responseHeaders.put("$sm", msg);
    }

    public void sendRedirect(String location) throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "sendRedirect({0})", location);
        }
    }

    public void setDateHeader(String name, long date) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setDateHeader({0}, {1})", new Object[]{name, date});
        }
    }

    public void setHeader(String name, String value) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setHeader({0}, {1})", new Object[]{name, value});
        }
        this.responseHeaders.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setIntHeader({0}, {1})", new Object[]{name, value});
        }
    }

    public void setStatus(int sc) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setStatus({0})", sc);
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
    }

    public void setStatus(int sc, String sm) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "setStatus({0}, {1})", new Object[]{sc, sm});
        }
        this.responseHeaders.put("$sc", Integer.toString(sc));
        this.responseHeaders.put("$sm", sm);
    }

    private ServletOutputStream createOutputStream() {
        return new ServletOutputStream(){
            private InternalByteArrayOutputStream buffer = new InternalByteArrayOutputStream();

            public void write(int b) throws IOException {
                byte[] data = new byte[]{(byte)b};
                this.write(data, 0, 1);
            }

            public void write(byte[] data) throws IOException {
                this.write(data, 0, data.length);
            }

            public void write(byte[] data, int offset, int length) throws IOException {
                if (WebSocketVirtualServletResponse.this.responseHeaders.get("$flushed") == null) {
                    this.buffer.write(data, offset, length);
                } else {
                    data = WebSocketUtils.buildResponse(data, offset, length);
                    WebSocketVirtualServletResponse.this.webSocketHolder.write(data, 0, data.length);
                }
            }

            public void close() throws IOException {
                if (WebSocketVirtualServletResponse.this.responseHeaders.get("$flushed") == null) {
                    byte[] data = WebSocketUtils.buildResponse(WebSocketVirtualServletResponse.this.responseHeaders, this.buffer.getBytes(), 0, this.buffer.size());
                    WebSocketVirtualServletResponse.this.webSocketHolder.write(data, 0, data.length);
                    WebSocketVirtualServletResponse.this.responseHeaders.put("$flushed", "true");
                }
                super.close();
            }
        };
    }

    private static class InternalByteArrayOutputStream
    extends ByteArrayOutputStream {
        private InternalByteArrayOutputStream() {
        }

        public byte[] getBytes() {
            return this.buf;
        }
    }
}

