/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.ahc;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.ahc.AhcWebSocketConduitRequest;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class AhcWebSocketConduit
extends URLConnectionHTTPConduit {
    private static final Logger LOG = LogUtils.getL7dLogger(AhcWebSocketConduit.class);
    private AsyncHttpClient ahcclient;
    private WebSocket websocket;
    private String requestIdKey = "requestId";
    private String responseIdKey = "responseId";
    private Map<String, RequestResponse> uncorrelatedRequests = new ConcurrentHashMap<String, RequestResponse>();

    public AhcWebSocketConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(b, ei, t);
        this.ahcclient = new AsyncHttpClient();
    }

    protected void setupConnection(Message message, URI currentURL, HTTPClientPolicy csPolicy) throws IOException {
        String s = currentURL.getScheme();
        if (!"ws".equals(s) && !"wss".equals(s)) {
            throw new MalformedURLException("unknown protocol: " + s);
        }
        message.put((Object)"http.scheme", (Object)currentURL.getScheme());
        String httpRequestMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put((Object)"org.apache.cxf.request.method", (Object)httpRequestMethod);
        }
        AhcWebSocketConduitRequest request = new AhcWebSocketConduitRequest(currentURL, httpRequestMethod);
        int rtimeout = AhcWebSocketConduit.determineReceiveTimeout((Message)message, (HTTPClientPolicy)csPolicy);
        request.setReceiveTimeout(rtimeout);
        message.put(AhcWebSocketConduitRequest.class, (Object)request);
    }

    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        AhcWebSocketConduitRequest entity = (AhcWebSocketConduitRequest)message.get(AhcWebSocketConduitRequest.class);
        AhcWebSocketWrappedOutputStream out = new AhcWebSocketWrappedOutputStream(message, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName(), entity.getUri());
        return out;
    }

    static class RequestResponse {
        private AhcWebSocketConduitRequest request;
        private Response response;

        public RequestResponse(AhcWebSocketConduitRequest request) {
            this.request = request;
        }

        public AhcWebSocketConduitRequest getRequest() {
            return this.request;
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }
    }

    static class Response {
        private Object data;
        private int pos;
        private int statusCode;
        private String contentType;
        private String id;
        private Object entity;

        public Response(String idKey, Object data) {
            this.data = data;
            String line = this.readLine();
            if (line != null) {
                this.statusCode = Integer.parseInt(line);
                while ((line = this.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    int del = line.indexOf(58);
                    String h = line.substring(0, del).trim();
                    String v = line.substring(del + 1).trim();
                    if ("Content-Type".equalsIgnoreCase(h)) {
                        this.contentType = v;
                        continue;
                    }
                    if (!idKey.equals(h)) continue;
                    this.id = v;
                }
            }
            if (data instanceof String) {
                this.entity = ((String)data).substring(this.pos);
            } else if (data instanceof byte[]) {
                this.entity = new byte[((byte[])data).length - this.pos];
                System.arraycopy((byte[])data, this.pos, (byte[])this.entity, 0, ((byte[])this.entity).length);
            }
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getId() {
            return this.id;
        }

        public Object getEntity() {
            return this.entity;
        }

        public String getTextEntity() {
            return this.gettext(this.entity);
        }

        private String readLine() {
            int c;
            StringBuilder sb = new StringBuilder();
            while (this.pos < this.length(this.data) && (c = this.getchar(this.data, this.pos++)) != 10) {
                if (c == 13) continue;
                sb.append((char)c);
            }
            if (sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }

        private int length(Object o) {
            return o instanceof char[] ? ((String)o).length() : (o instanceof byte[] ? ((byte[])o).length : 0);
        }

        private int getchar(Object o, int p) {
            return 0xFF & (o instanceof String ? ((String)o).charAt(p) : (o instanceof byte[] ? ((byte[])o)[p] : -1));
        }

        private String gettext(Object o) {
            return o instanceof String ? (String)o : (o instanceof byte[] ? new String((byte[])o) : null);
        }
    }

    protected class AhcWebSocketListener
    implements WebSocketTextListener,
    WebSocketByteListener {
        protected AhcWebSocketListener() {
        }

        public void onOpen(WebSocket ws) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "onOpen({0})", ws);
            }
        }

        public void onClose(WebSocket ws) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "onCose({0})", ws);
            }
        }

        public void onError(Throwable t) {
            LOG.log(Level.SEVERE, "[ws] onError", t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(byte[] message) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "onMessage({0})", (Object)message);
            }
            Response resp = new Response(AhcWebSocketConduit.this.responseIdKey, message);
            RequestResponse rr = (RequestResponse)AhcWebSocketConduit.this.uncorrelatedRequests.get(resp.getId());
            if (rr != null) {
                RequestResponse requestResponse = rr;
                synchronized (requestResponse) {
                    rr.setResponse(resp);
                    rr.notifyAll();
                }
            }
        }

        public void onFragment(byte[] fragment, boolean last) {
            LOG.log(Level.WARNING, "NOT IMPLEMENTED onFragment({0}, {1})", new Object[]{fragment, last});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(String message) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "onMessage({0})", message);
            }
            Response resp = new Response(AhcWebSocketConduit.this.responseIdKey, message);
            RequestResponse rr = (RequestResponse)AhcWebSocketConduit.this.uncorrelatedRequests.get(resp.getId());
            if (rr != null) {
                RequestResponse requestResponse = rr;
                synchronized (requestResponse) {
                    rr.setResponse(resp);
                    rr.notifyAll();
                }
            }
        }

        public void onFragment(String fragment, boolean last) {
            LOG.log(Level.WARNING, "NOT IMPLEMENTED onFragment({0}, {1})", new Object[]{fragment, last});
        }
    }

    public class AhcWebSocketWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream {
        private AhcWebSocketConduitRequest entity;
        private Response response;

        protected AhcWebSocketWrappedOutputStream(Message message, boolean possibleRetransmit, boolean isChunking, int chunkThreshold, String conduitName, URI url) {
            super((HTTPConduit)AhcWebSocketConduit.this, message, possibleRetransmit, isChunking, chunkThreshold, conduitName, url);
            this.entity = (AhcWebSocketConduitRequest)message.get(AhcWebSocketConduitRequest.class);
            String requri = (String)message.getContextualProperty("org.apache.cxf.request.uri");
            if (requri != null) {
                if (requri.startsWith("ws")) {
                    this.entity.setPath(requri.substring(requri.indexOf(47, 3 + requri.indexOf(58))));
                } else {
                    this.entity.setPath(url.getPath() + requri);
                }
            } else {
                this.entity.setPath(url.getPath());
            }
            this.entity.setId(UUID.randomUUID().toString());
            AhcWebSocketConduit.this.uncorrelatedRequests.put(this.entity.getId(), new RequestResponse(this.entity));
        }

        protected void setupWrappedStream() throws IOException {
            this.connect();
            this.wrappedStream = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("Content-Type", AhcWebSocketWrappedOutputStream.this.entity.getContentType());
                    headers.put(AhcWebSocketConduit.this.requestIdKey, AhcWebSocketWrappedOutputStream.this.entity.getId());
                    AhcWebSocketConduit.this.websocket.sendMessage(WebSocketUtils.buildRequest(AhcWebSocketWrappedOutputStream.this.entity.getMethod(), AhcWebSocketWrappedOutputStream.this.entity.getPath(), headers, b, off, len));
                }

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
        }

        protected void handleNoOutput() throws IOException {
            this.connect();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(AhcWebSocketConduit.this.requestIdKey, this.entity.getId());
            AhcWebSocketConduit.this.websocket.sendMessage(WebSocketUtils.buildRequest(this.entity.getMethod(), this.entity.getPath(), headers, null, 0, 0));
        }

        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            return null;
        }

        protected void setProtocolHeaders() throws IOException {
            Headers h = new Headers(this.outMessage);
            this.entity.setContentType(h.determineContentType());
        }

        protected void setFixedLengthStreamingMode(int i) {
        }

        protected int getResponseCode() throws IOException {
            Response r = this.getResponse();
            return r.getStatusCode();
        }

        protected String getResponseMessage() throws IOException {
            return null;
        }

        protected void updateResponseHeaders(Message inMessage) throws IOException {
            Headers h = new Headers(inMessage);
            String ct = this.getResponse().getContentType();
            inMessage.put((Object)"Content-Type", (Object)ct);
            h.headerMap().put("Content-Type", Collections.singletonList(ct));
        }

        protected void handleResponseAsync() throws IOException {
            this.handleResponseOnWorkqueue(true, false);
        }

        protected void closeInputStream() throws IOException {
        }

        protected boolean usingProxy() {
            return false;
        }

        protected InputStream getInputStream() throws IOException {
            Response r = this.getResponse();
            return new ByteArrayInputStream(r.getTextEntity().getBytes());
        }

        protected InputStream getPartialResponse() throws IOException {
            Response r = this.getResponse();
            return new ByteArrayInputStream(r.getTextEntity().getBytes());
        }

        protected void setupNewConnection(String newURL) throws IOException {
            throw new IOException("not supported");
        }

        protected void retransmitStream() throws IOException {
            throw new IOException("not supported");
        }

        protected void updateCookiesBeforeRetransmit() throws IOException {
        }

        public void thresholdReached() throws IOException {
        }

        protected void connect() {
            LOG.log(Level.INFO, "connecting");
            if (AhcWebSocketConduit.this.websocket == null) {
                try {
                    AhcWebSocketConduit.this.websocket = (WebSocket)AhcWebSocketConduit.this.ahcclient.prepareGet(this.url.toASCIIString()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new AhcWebSocketListener()).build()).get();
                    LOG.log(Level.INFO, "connected");
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "unable to connect", e);
                }
            } else {
                LOG.log(Level.INFO, "already connected");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Response getResponse() throws IOException {
            if (this.response == null) {
                RequestResponse rr;
                String rid = this.entity.getId();
                RequestResponse requestResponse = rr = (RequestResponse)AhcWebSocketConduit.this.uncorrelatedRequests.get(rid);
                synchronized (requestResponse) {
                    try {
                        long timetowait = this.entity.getReceiveTimeout();
                        this.response = rr.getResponse();
                        if (this.response == null) {
                            rr.wait(timetowait);
                            this.response = rr.getResponse();
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.response == null) {
                    throw new SocketTimeoutException("Read timed out while invoking " + this.entity.getUri());
                }
            }
            return this.response;
        }
    }
}

