/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.WebSocketVirtualServletRequest;
import org.apache.cxf.transport.websocket.WebSocketVirtualServletResponse;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereWebSocketServletDestination;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;

public class AtmosphereWebSocketHandler
implements WebSocketProtocol {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereWebSocketHandler.class);
    protected AtmosphereWebSocketServletDestination destination;
    private String requestIdKey = "requestId";
    private String responseIdKey = "responseId";

    public AtmosphereWebSocketServletDestination getDestination() {
        return this.destination;
    }

    public void setDestination(AtmosphereWebSocketServletDestination destination) {
        this.destination = destination;
    }

    public void configure(AtmosphereConfig config) {
        LOG.info("configure(AtmosphereConfig)");
    }

    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String data) {
        LOG.info("onMessage(WebSocket, String)");
        byte[] bdata = null;
        try {
            bdata = data.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return this.onMessage(webSocket, bdata, 0, bdata.length);
    }

    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        return this.invokeService(webSocket, new ByteArrayInputStream(data, offset, length));
    }

    protected List<AtmosphereRequest> invokeService(final WebSocket webSocket, final InputStream stream) {
        LOG.info("invokeService(WebSocket, InputStream)");
        this.destination.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                WebSocketVirtualServletRequest request = null;
                WebSocketVirtualServletResponse response = null;
                try {
                    AtmosphereWebSocketServletHolder webSocketHolder = new AtmosphereWebSocketServletHolder(webSocket);
                    response = AtmosphereWebSocketHandler.this.createServletResponse(webSocketHolder);
                    request = AtmosphereWebSocketHandler.this.createServletRequest(webSocketHolder, stream);
                    if (AtmosphereWebSocketHandler.this.destination != null) {
                        String reqid = request.getHeader(AtmosphereWebSocketHandler.this.requestIdKey);
                        if (reqid != null) {
                            response.setHeader(AtmosphereWebSocketHandler.this.responseIdKey, reqid);
                        }
                        AtmosphereWebSocketHandler.this.destination.invokeInternal(null, webSocket.resource().getRequest().getServletContext(), request, response);
                    }
                }
                catch (InvalidPathException ex) {
                    AtmosphereWebSocketHandler.this.reportErrorStatus(response, 400);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to invoke service", e);
                }
            }
        });
        return null;
    }

    protected void reportErrorStatus(HttpServletResponse response, int status) {
        if (response != null) {
            response.setStatus(status);
            try {
                response.getWriter().write("\r\n");
                response.getWriter().close();
                response.flushBuffer();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void onOpen(WebSocket webSocket) {
        LOG.info("onOpen(WebSocket)");
    }

    public void onClose(WebSocket webSocket) {
        LOG.info("onClose(WebSocket)");
    }

    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        LOG.info("onError(WebSocket, WebSocketException)");
    }

    protected WebSocketVirtualServletRequest createServletRequest(WebSocketServletHolder webSocketHolder, InputStream stream) throws IOException {
        return new WebSocketVirtualServletRequest(webSocketHolder, stream);
    }

    protected WebSocketVirtualServletResponse createServletResponse(WebSocketServletHolder webSocketHolder) throws IOException {
        return new WebSocketVirtualServletResponse(webSocketHolder);
    }

    protected static class AtmosphereWebSocketServletHolder
    implements WebSocketServletHolder {
        private WebSocket webSocket;

        public AtmosphereWebSocketServletHolder(WebSocket webSocket) {
            this.webSocket = webSocket;
        }

        @Override
        public String getAuthType() {
            return this.webSocket.resource().getRequest().getAuthType();
        }

        @Override
        public String getContextPath() {
            return this.webSocket.resource().getRequest().getContextPath();
        }

        @Override
        public String getLocalAddr() {
            return this.webSocket.resource().getRequest().getLocalAddr();
        }

        @Override
        public String getLocalName() {
            return this.webSocket.resource().getRequest().getLocalName();
        }

        @Override
        public int getLocalPort() {
            return this.webSocket.resource().getRequest().getLocalPort();
        }

        @Override
        public Locale getLocale() {
            return this.webSocket.resource().getRequest().getLocale();
        }

        @Override
        public Enumeration<Locale> getLocales() {
            return this.webSocket.resource().getRequest().getLocales();
        }

        @Override
        public String getProtocol() {
            return this.webSocket.resource().getRequest().getProtocol();
        }

        @Override
        public String getRemoteAddr() {
            return this.webSocket.resource().getRequest().getRemoteAddr();
        }

        @Override
        public String getRemoteHost() {
            return this.webSocket.resource().getRequest().getRemoteHost();
        }

        @Override
        public int getRemotePort() {
            return this.webSocket.resource().getRequest().getRemotePort();
        }

        @Override
        public String getRequestURI() {
            return this.webSocket.resource().getRequest().getRequestURI();
        }

        @Override
        public StringBuffer getRequestURL() {
            return this.webSocket.resource().getRequest().getRequestURL();
        }

        @Override
        public DispatcherType getDispatcherType() {
            return this.webSocket.resource().getRequest().getDispatcherType();
        }

        @Override
        public boolean isSecure() {
            return this.webSocket.resource().getRequest().isSecure();
        }

        @Override
        public String getPathInfo() {
            return this.webSocket.resource().getRequest().getServletPath();
        }

        @Override
        public String getPathTranslated() {
            return this.webSocket.resource().getRequest().getPathTranslated();
        }

        @Override
        public String getScheme() {
            return this.webSocket.resource().getRequest().getScheme();
        }

        @Override
        public String getServerName() {
            return this.webSocket.resource().getRequest().getServerName();
        }

        @Override
        public String getServletPath() {
            return this.webSocket.resource().getRequest().getServletPath();
        }

        @Override
        public int getServerPort() {
            return this.webSocket.resource().getRequest().getServerPort();
        }

        @Override
        public ServletContext getServletContext() {
            return this.webSocket.resource().getRequest().getServletContext();
        }

        @Override
        public Principal getUserPrincipal() {
            return this.webSocket.resource().getRequest().getUserPrincipal();
        }

        @Override
        public Object getAttribute(String name) {
            return this.webSocket.resource().getRequest().getAttribute(name);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.webSocket.write(data, offset, length);
        }
    }
}

