/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.IOException;
import java.util.concurrent.Executor;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereWebSocketHandler;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocketProtocol;

public class AtmosphereWebSocketServletDestination
extends ServletDestination
implements WebSocketDestinationService {
    private AtmosphereFramework framework = new AtmosphereFramework(false, true);
    private Executor executor;

    public AtmosphereWebSocketServletDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, String path) throws IOException {
        super(bus, registry, ei, ei.toString());
        this.framework.setUseNativeImplementation(false);
        this.framework.addInitParameter("org.atmosphere.useWebSocket", "true");
        this.framework.addInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL, AtmosphereWebSocketHandler.class.getName());
        this.framework.init();
        WebSocketProtocol wsp = this.framework.getWebSocketProtocol();
        if (wsp instanceof AtmosphereWebSocketHandler) {
            ((AtmosphereWebSocketHandler)wsp).setDestination(this);
        }
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (Utils.webSocketEnabled((HttpServletRequest)req)) {
            try {
                this.framework.doCometSupport(AtmosphereRequest.wrap((HttpServletRequest)req), AtmosphereResponse.wrap((HttpServletResponse)resp));
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
            return;
        }
        super.invoke(config, context, req, resp);
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    Executor getExecutor() {
        return this.executor;
    }
}

