/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.WebSocketVirtualServletRequest;
import org.apache.cxf.transport.websocket.WebSocketVirtualServletResponse;
import org.apache.cxf.transport.websocket.jetty.JettyWebSocketManager;
import org.eclipse.jetty.websocket.WebSocket;

class JettyWebSocket
implements WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyWebSocket.class);
    private JettyWebSocketManager manager;
    private WebSocket.Connection webSocketConnection;
    private WebSocketServletHolder webSocketHolder;
    private String protocol;
    private String requestIdKey = "requestId";
    private String responseIdKey = "responseId";

    public JettyWebSocket(JettyWebSocketManager manager, HttpServletRequest request, String protocol) {
        this.manager = manager;
        this.protocol = protocol;
        this.webSocketHolder = new JettyWebSocketServletHolder(this, request);
    }

    public void onClose(int closeCode, String message) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "onClose({0}, {1})", new Object[]{closeCode, message});
        }
        this.webSocketConnection = null;
    }

    public void onOpen(WebSocket.Connection connection) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "onOpen({0}))", connection);
        }
        this.webSocketConnection = connection;
    }

    public void onMessage(String data) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "onMessage({0})", data);
        }
        try {
            byte[] bdata = data.getBytes("utf-8");
            this.invokeService(bdata, 0, bdata.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void onMessage(byte[] data, int offset, int length) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "onMessage({0}, {1}, {2})", new Object[]{data, offset, length});
        }
        this.invokeService(data, offset, length);
    }

    private void invokeService(final byte[] data, final int offset, final int length) {
        this.manager.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                WebSocketVirtualServletRequest request = null;
                WebSocketVirtualServletResponse response = null;
                try {
                    response = JettyWebSocket.this.createServletResponse();
                    request = JettyWebSocket.this.createServletRequest(data, offset, length);
                    if (JettyWebSocket.this.manager != null) {
                        String reqid = request.getHeader(JettyWebSocket.this.requestIdKey);
                        if (reqid != null) {
                            response.setHeader(JettyWebSocket.this.responseIdKey, reqid);
                        }
                        JettyWebSocket.this.manager.service(request, response);
                    }
                }
                catch (InvalidPathException ex) {
                    JettyWebSocket.this.reportErrorStatus(response, 400);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to invoke service", e);
                    JettyWebSocket.this.reportErrorStatus(response, 500);
                }
            }
        });
    }

    private void reportErrorStatus(HttpServletResponse response, int status) {
        if (response != null) {
            response.setStatus(status);
            try {
                response.getWriter().write("\r\n");
                response.getWriter().close();
                response.flushBuffer();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private WebSocketVirtualServletRequest createServletRequest(byte[] data, int offset, int length) throws IOException {
        return new WebSocketVirtualServletRequest(this.webSocketHolder, new ByteArrayInputStream(data, offset, length));
    }

    private WebSocketVirtualServletResponse createServletResponse() throws IOException {
        return new WebSocketVirtualServletResponse(this.webSocketHolder);
    }

    void write(byte[] data, int offset, int length) throws IOException {
        LOG.log(Level.INFO, "write(byte[], offset, length)");
        this.webSocketConnection.sendMessage(data, offset, length);
    }

    String getProtocol() {
        return this.protocol;
    }

    private static class JettyWebSocketServletHolder
    implements WebSocketServletHolder {
        private JettyWebSocket webSocket;
        private Map<String, Object> requestProperties;
        private Map<String, Object> requestAttributes;

        public JettyWebSocketServletHolder(JettyWebSocket webSocket, HttpServletRequest request) {
            this.webSocket = webSocket;
            this.requestProperties = this.readProperties(request);
            this.requestAttributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            Object v = request.getAttribute("org.apache.cxf.transport.endpoint.address");
            if (v != null) {
                this.requestAttributes.put("org.apache.cxf.transport.endpoint.address", v);
            }
        }

        private <T> T getRequestProperty(String name, Class<T> cls) {
            return (T)this.requestProperties.get(name);
        }

        private Map<String, Object> readProperties(HttpServletRequest request) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("servletPath", request.getServletPath());
            properties.put("requestURI", request.getRequestURI());
            properties.put("requestURL", request.getRequestURL());
            properties.put("contextPath", request.getContextPath());
            properties.put("servletPath", request.getServletPath());
            properties.put("servletContext", request.getServletContext());
            properties.put("pathInfo", request.getPathInfo());
            properties.put("pathTranslated", request.getPathTranslated());
            properties.put("protocol", request.getProtocol());
            properties.put("scheme", request.getScheme());
            properties.put("localAddr", request.getLocalAddr());
            properties.put("localName", request.getLocalName());
            properties.put("localPort", request.getLocalPort());
            properties.put("locale", request.getLocale());
            properties.put("locales", request.getLocales());
            properties.put("remoteHost", request.getRemoteHost());
            properties.put("remotePort", request.getRemotePort());
            properties.put("remoteAddr", request.getRemoteAddr());
            properties.put("serverName", request.getServerName());
            properties.put("serverPort", request.getServerPort());
            properties.put("secure", request.isSecure());
            properties.put("authType", request.getAuthType());
            properties.put("dispatcherType", request.getDispatcherType());
            return properties;
        }

        @Override
        public String getAuthType() {
            return this.getRequestProperty("authType", String.class);
        }

        @Override
        public String getContextPath() {
            return this.getRequestProperty("contextPath", String.class);
        }

        @Override
        public String getLocalAddr() {
            return this.getRequestProperty("LocalAddr", String.class);
        }

        @Override
        public String getLocalName() {
            return this.getRequestProperty("localName", String.class);
        }

        @Override
        public int getLocalPort() {
            return this.getRequestProperty("localPort", Integer.TYPE);
        }

        @Override
        public Locale getLocale() {
            return this.getRequestProperty("locale", Locale.class);
        }

        @Override
        public Enumeration<Locale> getLocales() {
            return CastUtils.cast((Enumeration)this.getRequestProperty("locales", Enumeration.class));
        }

        @Override
        public String getProtocol() {
            return this.getRequestProperty("protocol", String.class);
        }

        @Override
        public String getRemoteAddr() {
            return this.getRequestProperty("remoteAddr", String.class);
        }

        @Override
        public String getRemoteHost() {
            return this.getRequestProperty("remoteHost", String.class);
        }

        @Override
        public int getRemotePort() {
            return this.getRequestProperty("remotePort", Integer.TYPE);
        }

        @Override
        public String getRequestURI() {
            return this.getRequestProperty("requestURI", String.class);
        }

        @Override
        public StringBuffer getRequestURL() {
            return this.getRequestProperty("requestURL", StringBuffer.class);
        }

        @Override
        public DispatcherType getDispatcherType() {
            return this.getRequestProperty("dispatcherType", DispatcherType.class);
        }

        @Override
        public boolean isSecure() {
            return this.getRequestProperty("secure", Boolean.TYPE);
        }

        @Override
        public String getPathInfo() {
            return this.getRequestProperty("pathInfo", String.class);
        }

        @Override
        public String getPathTranslated() {
            return this.getRequestProperty("pathTranslated", String.class);
        }

        @Override
        public String getScheme() {
            return this.getRequestProperty("scheme", String.class);
        }

        @Override
        public String getServerName() {
            return this.getRequestProperty("serverName", String.class);
        }

        @Override
        public String getServletPath() {
            return this.getRequestProperty("servletPath", String.class);
        }

        @Override
        public int getServerPort() {
            return this.getRequestProperty("serverPort", Integer.TYPE);
        }

        @Override
        public ServletContext getServletContext() {
            return this.getRequestProperty("serverContext", ServletContext.class);
        }

        @Override
        public Principal getUserPrincipal() {
            return this.getRequestProperty("userPrincipal", Principal.class);
        }

        @Override
        public Object getAttribute(String name) {
            return this.requestAttributes.get(name);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.webSocket.write(data, offset, length);
        }
    }
}

