/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

public final class WebSocketUtils {
    public static final String URI_KEY = "$uri";
    public static final String METHOD_KEY = "$method";
    public static final String SC_KEY = "$sc";
    public static final String FLUSHED_KEY = "$flushed";
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] COLSP = ": ".getBytes();

    private WebSocketUtils() {
    }

    public static Map<String, String> readHeaders(InputStream in, boolean req) throws IOException {
        int del;
        String line;
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (req) {
            line = WebSocketUtils.readLine(in);
            del = line.indexOf(32);
            if (del < 0) {
                throw new IOException("invalid request: " + line);
            }
            headers.put(METHOD_KEY, line.substring(0, del).trim());
            headers.put(URI_KEY, line.substring(del + 1).trim());
        }
        while ((line = WebSocketUtils.readLine(in)) != null) {
            if (line.length() <= 0) continue;
            del = line.indexOf(58);
            if (del < 0) {
                headers.put(line.trim(), "");
                continue;
            }
            headers.put(line.substring(0, del).trim(), line.substring(del + 1).trim());
        }
        return headers;
    }

    public static Map<String, String> readHeaders(InputStream in) throws IOException {
        return WebSocketUtils.readHeaders(in, true);
    }

    public static String readLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(128);
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            buffer.append((char)c);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public static byte[] readBody(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        int n = in.read(buf);
        while (n > -1) {
            baos.write(buf, 0, n);
            n = in.read(buf);
        }
        return baos.toByteArray();
    }

    public static byte[] buildResponse(Map<String, String> headers, byte[] data, int offset, int length) {
        ByteArrayBuilder sb = new ByteArrayBuilder();
        String v = headers.get(SC_KEY);
        if (v != null) {
            sb.append(v).append(CRLF);
        }
        sb.append(headers);
        if (data != null && length > 0) {
            sb.append(CRLF).append(data, offset, length);
        }
        return sb.toByteArray();
    }

    public static byte[] buildResponse(byte[] headers, byte[] data, int offset, int length) {
        int hlen = headers != null ? headers.length : 0;
        byte[] longdata = new byte[length + 2 + hlen];
        if (hlen > 0) {
            System.arraycopy(headers, 0, longdata, 0, hlen);
        }
        if (data != null && length > 0) {
            System.arraycopy(CRLF, 0, longdata, hlen, CRLF.length);
            System.arraycopy(data, offset, longdata, hlen + CRLF.length, length);
        }
        return longdata;
    }

    public static byte[] buildResponse(byte[] data, int offset, int length) {
        return WebSocketUtils.buildResponse((byte[])null, data, offset, length);
    }

    public static byte[] buildHeaderLine(String name, String value) {
        byte[] hl = new byte[name.length() + COLSP.length + value.length() + CRLF.length];
        System.arraycopy(name.getBytes(), 0, hl, 0, name.length());
        System.arraycopy(COLSP, 0, hl, name.length(), COLSP.length);
        System.arraycopy(value.getBytes(), 0, hl, name.length() + COLSP.length, value.length());
        System.arraycopy(CRLF, 0, hl, name.length() + COLSP.length + value.length(), CRLF.length);
        return hl;
    }

    public static byte[] buildRequest(String method, String url, Map<String, String> headers, byte[] data, int offset, int length) {
        ByteArrayBuilder sb = new ByteArrayBuilder();
        sb.append(method).append(32).append(url).append(CRLF).append(headers);
        if (data != null && length > 0) {
            sb.append(CRLF).append(data, offset, length);
        }
        return sb.toByteArray();
    }

    private static class ByteArrayBuilder {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public ByteArrayBuilder append(byte[] b) {
            try {
                this.baos.write(b);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        public ByteArrayBuilder append(byte[] b, int offset, int length) {
            this.baos.write(b, offset, length);
            return this;
        }

        public ByteArrayBuilder append(String s) {
            try {
                this.baos.write(s.getBytes("utf-8"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        public ByteArrayBuilder append(int c) {
            this.baos.write(c);
            return this;
        }

        public ByteArrayBuilder append(Map<String, String> map) {
            for (Map.Entry<String, String> m : map.entrySet()) {
                if (m.getKey().startsWith("$")) continue;
                this.append(m.getKey()).append(COLSP).append(m.getValue()).append(CRLF);
            }
            return this;
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

