/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.jetty.JettyWebSocket;
import org.apache.cxf.transport.websocket.jetty.JettyWebSocketManager;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class JettyWebSocketServletDestination
extends ServletDestination
implements WebSocketDestinationService,
WebSocketFactory.Acceptor {
    private JettyWebSocketManager webSocketManager = new JettyWebSocketManager();

    public JettyWebSocketServletDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, String path) throws IOException {
        super(bus, registry, ei, path);
        this.webSocketManager.init((AbstractHTTPDestination)this);
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.webSocketManager.acceptWebSocket((ServletRequest)req, (ServletResponse)resp)) {
            return;
        }
        super.invoke(config, context, req, resp);
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    public boolean checkOrigin(HttpServletRequest arg0, String arg1) {
        return true;
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        return new JettyWebSocket(this.webSocketManager, request, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.webSocketManager.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }
}

