/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

public final class WebSocketUtils {
    static final String URI_KEY = "$uri";
    static final String METHOD_KEY = "$method";
    static final String SC_KEY = "$sc";
    static final String SM_KEY = "$sm";
    static final String FLUSHED_KEY = "$flushed";
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] COLSP = ": ".getBytes();
    private static final String DEFAULT_SC = "200";

    private WebSocketUtils() {
    }

    public static Map<String, String> readHeaders(InputStream in) throws IOException {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String line = WebSocketUtils.readLine(in);
        int del = line.indexOf(32);
        if (del < 0) {
            throw new IOException("invalid request: " + line);
        }
        headers.put(METHOD_KEY, line.substring(0, del).trim());
        headers.put(URI_KEY, line.substring(del + 1).trim());
        while ((line = WebSocketUtils.readLine(in)) != null) {
            if (line.length() <= 0) continue;
            del = line.indexOf(58);
            if (del < 0) {
                headers.put(line.trim(), "");
                continue;
            }
            headers.put(line.substring(0, del).trim(), line.substring(del + 1).trim());
        }
        return headers;
    }

    public static String readLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(128);
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            buffer.append((char)c);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public static byte[] buildResponse(Map<String, String> headers, byte[] data, int offset, int length) {
        ByteArrayBuilder sb = new ByteArrayBuilder();
        String v = headers.get(SC_KEY);
        sb.append(v == null ? DEFAULT_SC : v).append(CRLF);
        WebSocketUtils.appendHeaders(headers, sb);
        byte[] longdata = sb.toByteArray();
        if (data != null && length > 0) {
            longdata = WebSocketUtils.buildResponse(longdata, data, offset, length);
        }
        return longdata;
    }

    public static byte[] buildResponse(byte[] headers, byte[] data, int offset, int length) {
        int hlen = headers != null ? headers.length : 0;
        byte[] longdata = new byte[length + 2 + hlen];
        if (hlen > 0) {
            System.arraycopy(headers, 0, longdata, 0, hlen);
        }
        longdata[hlen] = 13;
        longdata[hlen + 1] = 10;
        System.arraycopy(data, offset, longdata, hlen + 2, length);
        return longdata;
    }

    public static byte[] buildResponse(byte[] data, int offset, int length) {
        return WebSocketUtils.buildResponse((byte[])null, data, offset, length);
    }

    static byte[] buildHeaderLine(String name, String value) {
        byte[] hl = new byte[name.length() + COLSP.length + value.length() + CRLF.length];
        System.arraycopy(name.getBytes(), 0, hl, 0, name.length());
        System.arraycopy(COLSP, 0, hl, name.length(), COLSP.length);
        System.arraycopy(value.getBytes(), 0, hl, name.length() + COLSP.length, value.length());
        System.arraycopy(CRLF, 0, hl, name.length() + COLSP.length + value.length(), CRLF.length);
        return hl;
    }

    public static byte[] buildRequest(String method, String url, Map<String, String> headers, byte[] data, int offset, int length) {
        ByteArrayBuilder sb = new ByteArrayBuilder();
        sb.append(method).append(' ').append(url).append(CRLF);
        WebSocketUtils.appendHeaders(headers, sb);
        sb.append(CRLF);
        byte[] longdata = sb.toByteArray();
        if (data != null && length > 0) {
            byte[] hb = longdata;
            longdata = new byte[hb.length + length];
            System.arraycopy(hb, 0, longdata, 0, hb.length);
            System.arraycopy(data, offset, longdata, hb.length, length);
        }
        return longdata;
    }

    private static void appendHeaders(Map<String, String> headers, ByteArrayBuilder sb) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey().startsWith("$")) continue;
            sb.append(header.getKey()).append(COLSP).append(header.getValue()).append(CRLF);
        }
    }

    private static class ByteArrayBuilder {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public ByteArrayBuilder append(byte[] b) {
            try {
                this.baos.write(b);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        public ByteArrayBuilder append(String s) {
            try {
                this.baos.write(s.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        public ByteArrayBuilder append(char c) {
            this.baos.write(c);
            return this;
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

