/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty;

import java.io.IOException;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.eclipse.jetty.websocket.WebSocketFactory;

class JettyWebSocketManager {
    private WebSocketFactory webSocketFactory;
    private AbstractHTTPDestination destination;
    private ServletContext servletContext;
    private Executor executor;

    JettyWebSocketManager() {
    }

    public void init(AbstractHTTPDestination dest) {
        this.destination = dest;
        this.webSocketFactory = new WebSocketFactory((WebSocketFactory.Acceptor)dest, 8192);
        this.executor = ((WorkQueueManager)dest.getBus().getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void destroy() {
        try {
            this.webSocketFactory.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean acceptWebSocket(ServletRequest req, ServletResponse res) throws IOException {
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            if (this.webSocketFactory.acceptWebSocket(request, response) || response.isCommitted()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.destination != null) {
            ((WebSocketDestinationService)this.destination).invokeInternal(null, this.servletContext, request, response);
        }
    }

    Executor getExecutor() {
        return this.executor;
    }
}

