/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereUtils;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.Utils;
import org.eclipse.jetty.server.Request;

public class AtmosphereWebSocketJettyDestination
extends JettyHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereWebSocketJettyDestination.class);
    private AtmosphereFramework framework = new AtmosphereFramework(false, true);
    private Executor executor;

    public AtmosphereWebSocketJettyDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory);
        this.framework.setUseNativeImplementation(false);
        this.framework.addInitParameter("org.atmosphere.useNative", "true");
        this.framework.addInitParameter("org.atmosphere.cpr.sessionSupport", "true");
        this.framework.addInitParameter("org.atmosphere.useWebSocket", "true");
        AtmosphereUtils.addInterceptors(this.framework, bus);
        this.framework.addAtmosphereHandler("/", (AtmosphereHandler)new DestinationHandler());
        this.framework.init();
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("ws")) {
            address = "http" + address.substring(2);
        }
        return address;
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.getAddress(this.endpointInfo)).getPath();
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new AtmosphereJettyWebSocketHandler(jhd, cmExact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.framework.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }

    private void executeHandlerTask(Runnable r) {
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            LOG.warning("Executor queue is full, run the service invocation task in caller thread.  Users can specify a larger executor queue to avoid this.");
            r.run();
        }
    }

    AtmosphereFramework getAtmosphereFramework() {
        return this.framework;
    }

    private class DestinationHandler
    extends AbstractReflectorAtmosphereHandler {
        private DestinationHandler() {
        }

        public void onRequest(final AtmosphereResource resource) throws IOException {
            LOG.fine("onRequest");
            AtmosphereWebSocketJettyDestination.this.executeHandlerTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        AtmosphereWebSocketJettyDestination.this.invokeInternal(null, resource.getRequest().getServletContext(), (HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse());
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Failed to invoke service", e);
                    }
                }
            });
        }
    }

    private class AtmosphereJettyWebSocketHandler
    extends JettyHTTPHandler {
        public AtmosphereJettyWebSocketHandler(JettyHTTPDestination jhd, boolean cmExact) {
            super(jhd, cmExact);
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (Utils.webSocketEnabled((HttpServletRequest)request)) {
                try {
                    AtmosphereWebSocketJettyDestination.this.framework.doCometSupport(AtmosphereRequest.wrap((HttpServletRequest)request), AtmosphereResponse.wrap((HttpServletResponse)response));
                    baseRequest.setHandled(true);
                }
                catch (ServletException e) {
                    throw new IOException(e);
                }
                return;
            }
            super.handle(target, baseRequest, request, response);
        }
    }
}

