/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;

@AtmosphereInterceptorService
public class DefaultProtocolInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultProtocolInterceptor.class);
    private static final String REQUEST_DISPATCHED = "request.dispatched";
    private static final String RESPONSE_PARENT = "response.parent";
    private final AsyncIOInterceptor interceptor = new Interceptor();
    private Pattern includedheaders;
    private Pattern excludedheaders;

    public void configure(AtmosphereConfig config) {
        super.configure(config);
        String p = config.getInitParameter("org.apache.cxf.transport.websocket.atmosphere.transport.includedheaders");
        if (p != null) {
            this.includedheaders = Pattern.compile(p, 2);
        }
        if ((p = config.getInitParameter("org.apache.cxf.transport.websocket.atmosphere.transport.excludedheaders")) != null) {
            this.excludedheaders = Pattern.compile(p, 2);
        }
    }

    public DefaultProtocolInterceptor includedheaders(String p) {
        if (p != null) {
            this.includedheaders = Pattern.compile(p, 2);
        }
        return this;
    }

    public void setIncludedheaders(Pattern includedheaders) {
        this.includedheaders = includedheaders;
    }

    public DefaultProtocolInterceptor excludedheaders(String p) {
        if (p != null) {
            this.excludedheaders = Pattern.compile(p, 2);
        }
        return this;
    }

    public void setExcludedheaders(Pattern excludedheaders) {
        this.excludedheaders = excludedheaders;
    }

    public Action inspect(AtmosphereResource r) {
        LOG.log(Level.FINE, "inspect");
        AtmosphereRequest request = r.getRequest();
        if (request.getAttribute(REQUEST_DISPATCHED) == null) {
            WrappedAtmosphereResponse response = new WrappedAtmosphereResponse(r.getResponse(), request);
            AtmosphereFramework framework = r.getAtmosphereConfig().framework();
            try {
                byte[] data = WebSocketUtils.readBody((InputStream)request.getInputStream());
                if (data.length == 0) {
                    return Action.CANCELLED;
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "inspecting data {0}", new String(data));
                }
                try {
                    AtmosphereRequest ar = this.createAtmosphereRequest(request, data);
                    ar.attributes().put(REQUEST_DISPATCHED, "true");
                    String refid = ar.getHeader("requestId");
                    if (refid != null) {
                        ar.attributes().put("requestId", refid);
                    }
                    request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
                    response.request(ar);
                    this.attachWriter(r);
                    Action action = framework.doCometSupport(ar, (AtmosphereResponse)response);
                    if (action.type() == Action.TYPE.SUSPEND) {
                        ar.destroyable(false);
                        response.destroyable(false);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error during request dispatching", e);
                    if (e instanceof InvalidPathException) {
                        response.setStatus(400);
                    } else {
                        response.setStatus(500);
                    }
                    response.getOutputStream().write(this.createResponse(response, null, true));
                }
                return Action.CANCELLED;
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error during protocol processing", e);
                return Action.CONTINUE;
            }
        }
        request.destroyable(false);
        return Action.CONTINUE;
    }

    private void attachWriter(AtmosphereResource r) {
        LinkedList filters;
        AtmosphereResponse res = r.getResponse();
        AsyncIOWriter writer = res.getAsyncIOWriter();
        if (writer instanceof AtmosphereInterceptorWriter && !(filters = ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).filters()).contains(this.interceptor)) {
            filters.addFirst(this.interceptor);
        }
    }

    protected AtmosphereRequest createAtmosphereRequest(AtmosphereRequest r, byte[] data) throws IOException {
        String origin;
        AtmosphereRequest.Builder b = new AtmosphereRequest.Builder();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        Map<String, String> hdrs = WebSocketUtils.readHeaders(in);
        String path = hdrs.get("$uri");
        if (!path.startsWith(origin = r.getRequestURI())) {
            LOG.log(Level.WARNING, "invalid path: {0} not within {1}", new Object[]{path, origin});
            throw new InvalidPathException();
        }
        String requestURI = path;
        String requestURL = r.getRequestURL() + requestURI.substring(r.getRequestURI().length());
        String contentType = hdrs.get("Content-Type");
        String method = hdrs.get("$method");
        b.pathInfo(path).contentType(contentType).headers(hdrs).method(method).requestURI(requestURI).requestURL(requestURL).request((HttpServletRequest)r);
        byte[] body = WebSocketUtils.readBody(in);
        if (body.length > 0) {
            b.body(body);
        }
        return b.build();
    }

    protected byte[] createResponse(AtmosphereResponse response, byte[] payload, boolean parent) {
        AtmosphereRequest request = response.request();
        String refid = (String)request.getAttribute("requestId");
        HashMap<String, String> headers = new HashMap<String, String>();
        if (refid != null) {
            response.addHeader("responseId", refid);
            headers.put("responseId", refid);
        }
        if (parent) {
            headers.put("$sc", Integer.toString(response.getStatus()));
            if (payload != null && payload.length > 0) {
                headers.put("Content-Type", response.getContentType());
            }
            for (Map.Entry hv : response.headers().entrySet()) {
                if ("Content-Type".equalsIgnoreCase((String)hv.getKey()) || this.includedheaders == null || !this.includedheaders.matcher((CharSequence)hv.getKey()).matches() || this.excludedheaders != null && this.excludedheaders.matcher((CharSequence)hv.getKey()).matches()) continue;
                headers.put((String)hv.getKey(), (String)hv.getValue());
            }
        }
        return WebSocketUtils.buildResponse(headers, payload, 0, payload == null ? 0 : payload.length);
    }

    private class WrappedAtmosphereResponse
    extends AtmosphereResponse {
        public WrappedAtmosphereResponse(AtmosphereResponse resp, AtmosphereRequest req) {
            super((HttpServletResponse)resp.getResponse(), resp.getAsyncIOWriter(), req, resp.isDestroyable());
        }

        public ServletOutputStream getOutputStream() throws IOException {
            final ServletOutputStream delegate = super.getOutputStream();
            return new ServletOutputStream(){
                private boolean written;

                public void write(int i) throws IOException {
                    this.written = true;
                    delegate.write(i);
                }

                public void close() throws IOException {
                    if (!this.written) {
                        delegate.write(DefaultProtocolInterceptor.this.createResponse(WrappedAtmosphereResponse.this, null, true));
                    }
                    delegate.close();
                }

                public void flush() throws IOException {
                    delegate.flush();
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.written = true;
                    delegate.write(b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    this.written = true;
                    delegate.write(b);
                }
            };
        }
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            AtmosphereRequest request;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "transformPayload with draft={0}", new String(responseDraft));
            }
            if ((request = response.request()).attributes().get(DefaultProtocolInterceptor.RESPONSE_PARENT) == null) {
                request.attributes().put(DefaultProtocolInterceptor.RESPONSE_PARENT, "true");
                return DefaultProtocolInterceptor.this.createResponse(response, responseDraft, true);
            }
            return DefaultProtocolInterceptor.this.createResponse(response, responseDraft, false);
        }

        public byte[] error(AtmosphereResponse response, int statusCode, String reasonPhrase) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "status={0}", statusCode);
            }
            response.setStatus(statusCode, reasonPhrase);
            return DefaultProtocolInterceptor.this.createResponse(response, null, true);
        }
    }
}

