/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.websocket.WebSocketDestinationFactory;
import org.apache.cxf.transport.websocket.ahc.AhcWebSocketConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@NoJSR250Annotations
public class WebSocketTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/websocket", "http://cxf.apache.org/transports/websocket/configuration");
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    protected final DestinationRegistry registry;
    protected final HttpDestinationFactory factory = new WebSocketDestinationFactory();

    public WebSocketTransportFactory() {
        this((DestinationRegistry)new DestinationRegistryImpl());
    }

    public WebSocketTransportFactory(DestinationRegistry registry) {
        super(DEFAULT_NAMESPACES);
        if (registry == null) {
            registry = new DestinationRegistryImpl();
        }
        this.registry = registry;
    }

    public DestinationRegistry getRegistry() {
        return this.registry;
    }

    protected void configure(Bus b, Object bean) {
        this.configure(b, bean, null, null);
    }

    protected void configure(Bus bus, Object bean, String name, String extraName) {
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, bean);
            if (extraName != null) {
                configurer.configureBean(extraName, bean);
            }
        }
    }

    public Conduit getConduit(EndpointInfo endpointInfo, Bus b) throws IOException {
        return this.getConduit(endpointInfo, endpointInfo.getTarget(), b);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target, Bus bus) throws IOException {
        HTTPConduitConfigurer c1;
        AhcWebSocketConduit conduit = new AhcWebSocketConduit(bus, endpointInfo, target);
        String address = conduit.getAddress();
        if (address != null && address.indexOf(63) != -1) {
            address = address.substring(0, address.indexOf(63));
        }
        if ((c1 = (HTTPConduitConfigurer)bus.getExtension(HTTPConduitConfigurer.class)) != null) {
            c1.configure(conduit.getBeanName(), address, (HTTPConduit)conduit);
        }
        this.configure(bus, (Object)conduit, conduit.getBeanName(), address);
        conduit.finalizeConfig();
        return conduit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(EndpointInfo endpointInfo, Bus bus) throws IOException {
        if (endpointInfo == null) {
            throw new IllegalArgumentException("EndpointInfo cannot be null");
        }
        DestinationRegistry destinationRegistry = this.registry;
        synchronized (destinationRegistry) {
            AbstractHTTPDestination d = this.registry.getDestinationForPath(endpointInfo.getAddress());
            if (d == null) {
                d = this.factory.createDestination(endpointInfo, bus, this.registry);
                if (d == null) {
                    String error = "No destination available. The CXF websocket transport needs either the Jetty WebSocket or Atmosphere dependencies to be available";
                    throw new IOException(error);
                }
                this.registry.addDestination(d);
                this.configure(bus, d);
                d.finalizeConfig();
            }
            return d;
        }
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    static {
        URI_PREFIXES.add("ws://");
        URI_PREFIXES.add("wss://");
    }
}

