/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;

public class DefaultProtocolInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultProtocolInterceptor.class);
    private static final String REQUEST_DISPATCHED = "request.dispatched";
    private static final String RESPONSE_PARENT = "response.parent";
    private Map<String, AtmosphereResponse> suspendedResponses = new HashMap<String, AtmosphereResponse>();
    private final AsyncIOInterceptor interceptor = new Interceptor();
    private Pattern includedheaders;
    private Pattern excludedheaders;

    public void configure(AtmosphereConfig config) {
        super.configure(config);
        String p = config.getInitParameter("org.apache.cxf.transport.websocket.atmosphere.transport.includedheaders");
        if (p != null) {
            this.includedheaders = Pattern.compile(p, 2);
        }
        if ((p = config.getInitParameter("org.apache.cxf.transport.websocket.atmosphere.transport.excludedheaders")) != null) {
            this.excludedheaders = Pattern.compile(p, 2);
        }
    }

    public DefaultProtocolInterceptor includedheaders(String p) {
        if (p != null) {
            this.includedheaders = Pattern.compile(p, 2);
        }
        return this;
    }

    public void setIncludedheaders(Pattern includedheaders) {
        this.includedheaders = includedheaders;
    }

    public DefaultProtocolInterceptor excludedheaders(String p) {
        if (p != null) {
            this.excludedheaders = Pattern.compile(p, 2);
        }
        return this;
    }

    public void setExcludedheaders(Pattern excludedheaders) {
        this.excludedheaders = excludedheaders;
    }

    public Action inspect(AtmosphereResource r) {
        LOG.log(Level.FINE, "inspect");
        if (AtmosphereResource.TRANSPORT.WEBSOCKET != r.transport() && AtmosphereResource.TRANSPORT.SSE != r.transport() && AtmosphereResource.TRANSPORT.POLLING != r.transport()) {
            LOG.fine("Skipping ignorable request");
            return Action.CONTINUE;
        }
        if (AtmosphereResource.TRANSPORT.POLLING == r.transport()) {
            String saruuid = (String)r.getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
            final AtmosphereResponse suspendedResponse = this.suspendedResponses.get(saruuid);
            LOG.fine("Attaching a proxy writer to suspended response");
            r.getResponse().asyncIOWriter((AsyncIOWriter)new AtmosphereInterceptorWriter(){

                public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
                    suspendedResponse.write(data);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
                    suspendedResponse.write(data);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
                    suspendedResponse.write(data, offset, length);
                    suspendedResponse.flushBuffer();
                    return this;
                }

                public void close(AtmosphereResponse response) throws IOException {
                }
            });
            r.getResponse().destroyable(false);
            return Action.CONTINUE;
        }
        r.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

            public void onSuspend(AtmosphereResourceEvent event) {
                String srid = (String)event.getResource().getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                LOG.log(Level.FINE, "Registrering suspended resource: {}", srid);
                DefaultProtocolInterceptor.this.suspendedResponses.put(srid, event.getResource().getResponse());
                AsyncIOWriter writer = event.getResource().getResponse().getAsyncIOWriter();
                if (writer instanceof AtmosphereInterceptorWriter) {
                    ((AtmosphereInterceptorWriter)writer).interceptor(DefaultProtocolInterceptor.this.interceptor);
                }
            }

            public void onDisconnect(AtmosphereResourceEvent event) {
                super.onDisconnect(event);
                String srid = (String)event.getResource().getRequest().getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
                LOG.log(Level.FINE, "Unregistrering suspended resource: {}", srid);
                DefaultProtocolInterceptor.this.suspendedResponses.remove(srid);
            }
        });
        AtmosphereRequest request = r.getRequest();
        if (request.getAttribute(REQUEST_DISPATCHED) == null) {
            WrappedAtmosphereResponse response = null;
            AtmosphereFramework framework = r.getAtmosphereConfig().framework();
            try {
                byte[] data = WebSocketUtils.readBody((InputStream)request.getInputStream());
                if (data.length == 0) {
                    if (AtmosphereResource.TRANSPORT.WEBSOCKET == r.transport() || AtmosphereResource.TRANSPORT.SSE == r.transport()) {
                        r.suspend();
                        return Action.SUSPEND;
                    }
                    return Action.CANCELLED;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "inspecting data {0}", new String(data));
                }
                try {
                    AtmosphereRequest ar = this.createAtmosphereRequest(request, data);
                    response = new WrappedAtmosphereResponse(r.getResponse(), ar);
                    ar.localAttributes().put(REQUEST_DISPATCHED, "true");
                    String refid = ar.getHeader("requestId");
                    if (refid != null) {
                        ar.localAttributes().put("requestId", refid);
                    }
                    request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
                    response.request(ar);
                    this.attachWriter(r);
                    Action action = framework.doCometSupport(ar, (AtmosphereResponse)response);
                    if (action.type() == Action.TYPE.SUSPEND) {
                        ar.destroyable(false);
                        response.destroyable(false);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error during request dispatching", e);
                    if (response == null) {
                        response = new WrappedAtmosphereResponse(r.getResponse(), request);
                    }
                    if (e instanceof InvalidPathException) {
                        response.setIntHeader("$sc", 400);
                    } else {
                        response.setIntHeader("$sc", 500);
                    }
                    ServletOutputStream out = response.getOutputStream();
                    out.write(this.createResponse(response, null, true));
                    out.close();
                }
                return Action.CANCELLED;
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error during protocol processing", e);
            }
        } else {
            request.destroyable(false);
        }
        return Action.CONTINUE;
    }

    private void attachWriter(AtmosphereResource r) {
        AtmosphereResponse res = r.getResponse();
        AsyncIOWriter writer = res.getAsyncIOWriter();
        if (writer instanceof AtmosphereInterceptorWriter) {
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(this.interceptor, 0);
        }
    }

    protected AtmosphereRequest createAtmosphereRequest(AtmosphereRequest r, byte[] data) throws IOException {
        String origin;
        AtmosphereRequest.Builder b = new AtmosphereRequest.Builder();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        Map<String, String> hdrs = WebSocketUtils.readHeaders(in);
        String path = hdrs.get("$uri");
        if (!path.startsWith(origin = r.getRequestURI())) {
            LOG.log(Level.WARNING, "invalid path: {0} not within {1}", new Object[]{path, origin});
            throw new InvalidPathException();
        }
        String queryString = "";
        int index = path.indexOf("?");
        if (index != -1) {
            queryString = path.substring(index + 1);
            path = path.substring(0, index);
        }
        String requestURI = path;
        String requestURL = r.getRequestURL() + requestURI.substring(r.getRequestURI().length());
        String contentType = hdrs.get("Content-Type");
        String method = hdrs.get("$method");
        b.pathInfo(path).contentType(contentType).headers(hdrs).method(method).requestURI(requestURI).requestURL(requestURL).queryString(queryString).request((HttpServletRequest)r);
        byte[] body = WebSocketUtils.readBody(in);
        if (body.length > 0) {
            b.body(body);
        }
        return b.build();
    }

    protected byte[] createResponse(AtmosphereResponse response, byte[] payload, boolean parent) {
        AtmosphereRequest request = response.request();
        String refid = (String)request.getAttribute("requestId");
        if (AtmosphereResource.TRANSPORT.WEBSOCKET != response.resource().transport()) {
            return payload;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (refid != null) {
            response.addHeader("responseId", refid);
            headers.put("responseId", refid);
        }
        if (parent) {
            String sc = response.getHeader("$sc");
            if (sc == null) {
                sc = Integer.toString(response.getStatus());
            }
            headers.put("$sc", sc);
            if (payload != null && payload.length > 0) {
                headers.put("Content-Type", response.getContentType());
            }
            for (Map.Entry hv : response.headers().entrySet()) {
                if ("Content-Type".equalsIgnoreCase((String)hv.getKey()) || this.includedheaders == null || !this.includedheaders.matcher((CharSequence)hv.getKey()).matches() || this.excludedheaders != null && this.excludedheaders.matcher((CharSequence)hv.getKey()).matches()) continue;
                headers.put((String)hv.getKey(), (String)hv.getValue());
            }
        }
        return WebSocketUtils.buildResponse(headers, payload, 0, payload == null ? 0 : payload.length);
    }

    private static class WrappedAtmosphereResponse
    extends AtmosphereResponse {
        final AtmosphereResponse response;
        ServletOutputStream sout;

        WrappedAtmosphereResponse(AtmosphereResponse resp, AtmosphereRequest req) throws IOException {
            super((HttpServletResponse)resp.getResponse(), null, req, resp.isDestroyable());
            this.response = resp;
            this.response.request(req);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.sout == null) {
                this.sout = new BufferedServletOutputStream(super.getOutputStream());
            }
            return this.sout;
        }

        private final class BufferedServletOutputStream
        extends ServletOutputStream {
            final ServletOutputStream delegate;
            CachedOutputStream out = new CachedOutputStream();

            BufferedServletOutputStream(ServletOutputStream d) {
                this.delegate = d;
            }

            OutputStream getOut() {
                if (this.out == null) {
                    this.out = new CachedOutputStream();
                }
                return this.out;
            }

            void send(boolean complete) throws IOException {
                if (this.out == null) {
                    return;
                }
                if (WrappedAtmosphereResponse.this.response.getStatus() >= 400) {
                    int i = WrappedAtmosphereResponse.this.response.getStatus();
                    WrappedAtmosphereResponse.this.response.setStatus(200);
                    WrappedAtmosphereResponse.this.response.addIntHeader("$sc", i);
                }
                this.out.flush();
                this.out.lockOutputStream();
                this.out.writeCacheTo((OutputStream)this.delegate);
                this.delegate.flush();
                this.out.close();
                this.out = null;
            }

            public void write(int i) throws IOException {
                this.getOut().write(i);
            }

            public void close() throws IOException {
                this.send(true);
                this.delegate.close();
            }

            public void flush() throws IOException {
                this.send(false);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.getOut().write(b, off, len);
            }

            public void write(byte[] b) throws IOException {
                this.getOut().write(b);
            }
        }
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            AtmosphereRequest request;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "transformPayload with draft={0}", new String(responseDraft));
            }
            if ((request = response.request()).attributes().get(DefaultProtocolInterceptor.RESPONSE_PARENT) == null) {
                request.attributes().put(DefaultProtocolInterceptor.RESPONSE_PARENT, "true");
                return DefaultProtocolInterceptor.this.createResponse(response, responseDraft, true);
            }
            return DefaultProtocolInterceptor.this.createResponse(response, responseDraft, false);
        }

        public byte[] error(AtmosphereResponse response, int statusCode, String reasonPhrase) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "status={0}", statusCode);
            }
            response.setStatus(statusCode, reasonPhrase);
            return DefaultProtocolInterceptor.this.createResponse(response, null, true);
        }
    }
}

