/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.jetty.JettyWebSocketHandler;
import org.apache.cxf.transport.websocket.jetty.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletRequest;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletResponse;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class JettyWebSocketDestination
extends JettyHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyWebSocketDestination.class);
    private String requestIdKey = "requestId";
    private String responseIdKey = "responseId";
    private WebSocketFactory webSocketFactory = new WebSocketFactory((WebSocketFactory.Acceptor)new Acceptor(), 8192);
    private final Executor executor;

    public JettyWebSocketDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory);
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.webSocketFactory.acceptWebSocket(request, response)) {
            ((Request)request).setHandled(true);
            return;
        }
        super.invoke(config, context, request, response);
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("ws")) {
            address = "http" + address.substring(2);
        }
        return address;
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new JettyWebSocketHandler(jhd, cmExact, this.webSocketFactory);
    }

    public void shutdown() {
        try {
            this.webSocketFactory.stop();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }

    private static class JettyWebSocketServletHolder
    implements WebSocketServletHolder {
        private JettyWebSocket webSocket;
        private Map<String, Object> requestProperties;
        private Map<String, Object> requestAttributes;

        JettyWebSocketServletHolder(JettyWebSocket webSocket, HttpServletRequest request) {
            this.webSocket = webSocket;
            this.requestProperties = this.readProperties(request);
            this.requestAttributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            Object v = request.getAttribute("org.apache.cxf.transport.endpoint.address");
            if (v != null) {
                this.requestAttributes.put("org.apache.cxf.transport.endpoint.address", v);
            }
        }

        private <T> T getRequestProperty(String name, Class<T> cls) {
            return (T)this.requestProperties.get(name);
        }

        private Map<String, Object> readProperties(HttpServletRequest request) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("servletPath", request.getServletPath());
            properties.put("requestURI", request.getRequestURI());
            properties.put("requestURL", request.getRequestURL());
            properties.put("contextPath", request.getContextPath());
            properties.put("servletPath", request.getServletPath());
            properties.put("servletContext", request.getServletContext());
            properties.put("pathInfo", request.getPathInfo());
            properties.put("pathTranslated", request.getPathTranslated());
            properties.put("protocol", request.getProtocol());
            properties.put("scheme", request.getScheme());
            properties.put("localAddr", request.getLocalAddr());
            properties.put("localName", request.getLocalName());
            properties.put("localPort", request.getLocalPort());
            properties.put("locale", request.getLocale());
            properties.put("locales", request.getLocales());
            properties.put("remoteHost", request.getRemoteHost());
            properties.put("remotePort", request.getRemotePort());
            properties.put("remoteAddr", request.getRemoteAddr());
            properties.put("serverName", request.getServerName());
            properties.put("serverPort", request.getServerPort());
            properties.put("secure", request.isSecure());
            properties.put("authType", request.getAuthType());
            properties.put("dispatcherType", request.getDispatcherType());
            return properties;
        }

        @Override
        public String getAuthType() {
            return this.getRequestProperty("authType", String.class);
        }

        @Override
        public String getContextPath() {
            return this.getRequestProperty("contextPath", String.class);
        }

        @Override
        public String getLocalAddr() {
            return this.getRequestProperty("LocalAddr", String.class);
        }

        @Override
        public String getLocalName() {
            return this.getRequestProperty("localName", String.class);
        }

        @Override
        public int getLocalPort() {
            return this.getRequestProperty("localPort", Integer.TYPE);
        }

        @Override
        public Locale getLocale() {
            return this.getRequestProperty("locale", Locale.class);
        }

        @Override
        public Enumeration<Locale> getLocales() {
            return CastUtils.cast((Enumeration)this.getRequestProperty("locales", Enumeration.class));
        }

        @Override
        public String getProtocol() {
            return this.getRequestProperty("protocol", String.class);
        }

        @Override
        public String getRemoteAddr() {
            return this.getRequestProperty("remoteAddr", String.class);
        }

        @Override
        public String getRemoteHost() {
            return this.getRequestProperty("remoteHost", String.class);
        }

        @Override
        public int getRemotePort() {
            return this.getRequestProperty("remotePort", Integer.TYPE);
        }

        @Override
        public String getRequestURI() {
            return this.getRequestProperty("requestURI", String.class);
        }

        @Override
        public StringBuffer getRequestURL() {
            return this.getRequestProperty("requestURL", StringBuffer.class);
        }

        @Override
        public DispatcherType getDispatcherType() {
            return this.getRequestProperty("dispatcherType", DispatcherType.class);
        }

        @Override
        public boolean isSecure() {
            return this.getRequestProperty("secure", Boolean.TYPE);
        }

        @Override
        public String getPathInfo() {
            return this.getRequestProperty("pathInfo", String.class);
        }

        @Override
        public String getPathTranslated() {
            return this.getRequestProperty("pathTranslated", String.class);
        }

        @Override
        public String getScheme() {
            return this.getRequestProperty("scheme", String.class);
        }

        @Override
        public String getServerName() {
            return this.getRequestProperty("serverName", String.class);
        }

        @Override
        public String getServletPath() {
            return this.getRequestProperty("servletPath", String.class);
        }

        @Override
        public int getServerPort() {
            return this.getRequestProperty("serverPort", Integer.TYPE);
        }

        @Override
        public ServletContext getServletContext() {
            return this.getRequestProperty("serverContext", ServletContext.class);
        }

        @Override
        public Principal getUserPrincipal() {
            return this.getRequestProperty("userPrincipal", Principal.class);
        }

        @Override
        public Object getAttribute(String name) {
            return this.requestAttributes.get(name);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.webSocket.write(data, offset, length);
        }
    }

    private class JettyWebSocket
    implements WebSocket.OnBinaryMessage,
    WebSocket.OnTextMessage {
        private WebSocket.Connection webSocketConnection;
        private WebSocketServletHolder webSocketHolder;

        JettyWebSocket(HttpServletRequest request, String protocol) {
            this.webSocketHolder = new JettyWebSocketServletHolder(this, request);
        }

        public void onClose(int closeCode, String message) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "onClose({0}, {1})", new Object[]{closeCode, message});
            }
            this.webSocketConnection = null;
        }

        public void onOpen(WebSocket.Connection connection) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "onOpen({0}))", connection);
            }
            this.webSocketConnection = connection;
        }

        public void onMessage(String data) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "onMessage({0})", data);
            }
            try {
                byte[] bdata = data.getBytes("utf-8");
                this.invokeService(bdata, 0, bdata.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public void onMessage(byte[] data, int offset, int length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "onMessage({0}, {1}, {2})", new Object[]{data, offset, length});
            }
            byte[] safedata = new byte[length];
            System.arraycopy(data, offset, safedata, 0, length);
            this.invokeService(safedata, 0, safedata.length);
        }

        private void invokeService(final byte[] data, final int offset, final int length) {
            this.executeServiceTask(new Runnable(){

                @Override
                public void run() {
                    WebSocketVirtualServletRequest request = null;
                    WebSocketVirtualServletResponse response = null;
                    try {
                        response = JettyWebSocket.this.createServletResponse();
                        request = JettyWebSocket.this.createServletRequest(data, offset, length);
                        String reqid = request.getHeader(JettyWebSocketDestination.this.requestIdKey);
                        if (reqid != null) {
                            response.setHeader(JettyWebSocketDestination.this.responseIdKey, reqid);
                        }
                        JettyWebSocketDestination.this.invoke(null, null, request, response);
                    }
                    catch (InvalidPathException ex) {
                        JettyWebSocket.this.reportErrorStatus(response, 400);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Failed to invoke service", e);
                        JettyWebSocket.this.reportErrorStatus(response, 500);
                    }
                }
            });
        }

        private void executeServiceTask(Runnable r) {
            try {
                JettyWebSocketDestination.this.executor.execute(r);
            }
            catch (RejectedExecutionException e) {
                LOG.warning("Executor queue is full, run the service invocation task in caller thread.  Users can specify a larger executor queue to avoid this.");
                r.run();
            }
        }

        private void reportErrorStatus(HttpServletResponse response, int status) {
            if (response != null) {
                response.setStatus(status);
                try {
                    response.getWriter().write("\r\n");
                    response.getWriter().close();
                    response.flushBuffer();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        private WebSocketVirtualServletRequest createServletRequest(byte[] data, int offset, int length) throws IOException {
            return new WebSocketVirtualServletRequest(this.webSocketHolder, new ByteArrayInputStream(data, offset, length));
        }

        private WebSocketVirtualServletResponse createServletResponse() throws IOException {
            return new WebSocketVirtualServletResponse(this.webSocketHolder);
        }

        void write(byte[] data, int offset, int length) throws IOException {
            LOG.log(Level.FINE, "write(byte[], offset, length)");
            this.webSocketConnection.sendMessage(data, offset, length);
        }
    }

    private class Acceptor
    implements WebSocketFactory.Acceptor {
        private Acceptor() {
        }

        public boolean checkOrigin(HttpServletRequest request, String protocol) {
            return true;
        }

        public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
            return new JettyWebSocket(request, protocol);
        }
    }
}

