/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty9;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.jetty.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletRequest;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletResponse;
import org.apache.cxf.transport.websocket.jetty9.JettyWebSocketHandler;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class Jetty9WebSocketDestination
extends JettyHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(Jetty9WebSocketDestination.class);
    private static final String REQUEST_ID_KEY = "requestId";
    private static final String RESPONSE_ID_KEY = "responseId";
    private final Executor executor;
    private WebSocketHandler webSockethandler;
    private WebSocketServletFactory webSocketFactory;

    public Jetty9WebSocketDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory);
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebSocketServletFactory wsf = this.getWebSocketFactory(config, context);
        if (wsf.isUpgradeRequest(request, response) && wsf.acceptWebSocket(request, response)) {
            ((Request)request).setHandled(true);
            return;
        }
        super.invoke(config, context, request, response);
    }

    private static String getNonWSAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("ws")) {
            address = "http" + address.substring(2);
        }
        return address;
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return Jetty9WebSocketDestination.getNonWSAddress(endpointInfo);
    }

    Server getServer(ServletConfig config, ServletContext context) {
        WebAppContext.Context c = (WebAppContext.Context)context;
        ContextHandler h = c.getContextHandler();
        return h.getServer();
    }

    private WebSocketServletFactory getWebSocketFactory(ServletConfig config, ServletContext context) {
        if (this.webSocketFactory == null) {
            Server server = this.getServer(config, context);
            return this.getWebSocketFactory(server);
        }
        return this.webSocketFactory;
    }

    public synchronized WebSocketServletFactory getWebSocketFactory(Server server) {
        if (this.webSocketFactory == null) {
            this.webSockethandler = new WebSocketHandler(){

                public void configure(WebSocketServletFactory factory) {
                }
            };
            try {
                this.webSockethandler.setServer(server);
                this.webSockethandler.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.webSocketFactory = this.webSockethandler.getWebSocketFactory();
            this.webSocketFactory.setCreator((WebSocketCreator)new Creator());
        }
        return this.webSocketFactory;
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new JettyWebSocketHandler(jhd, cmExact, this);
    }

    public void shutdown() {
        try {
            this.webSockethandler.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.shutdown();
    }

    private void invoke(final byte[] data, final int offset, final int length, final Session session) {
        this.executeServiceTask(new Runnable(){

            @Override
            public void run() {
                WebSocketVirtualServletRequest request = null;
                WebSocketVirtualServletResponse response = null;
                try {
                    Jetty9WebSocketHolder holder = new Jetty9WebSocketHolder(session);
                    response = Jetty9WebSocketDestination.this.createServletResponse(holder);
                    request = Jetty9WebSocketDestination.this.createServletRequest(data, offset, length, holder);
                    String reqid = request.getHeader(Jetty9WebSocketDestination.REQUEST_ID_KEY);
                    if (reqid != null) {
                        response.setHeader(Jetty9WebSocketDestination.RESPONSE_ID_KEY, reqid);
                    }
                    Jetty9WebSocketDestination.this.invoke(null, null, request, response);
                }
                catch (InvalidPathException ex) {
                    Jetty9WebSocketDestination.this.reportErrorStatus(session, 400, response);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to invoke service", e);
                    Jetty9WebSocketDestination.this.reportErrorStatus(session, 500, response);
                }
            }
        });
    }

    private void executeServiceTask(Runnable r) {
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            LOG.warning("Executor queue is full, run the service invocation task in caller thread.  Users can specify a larger executor queue to avoid this.");
            r.run();
        }
    }

    private void reportErrorStatus(Session session, int i, HttpServletResponse resp) {
        try {
            resp.sendError(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private WebSocketVirtualServletRequest createServletRequest(byte[] data, int offset, int length, WebSocketServletHolder holder) throws IOException {
        return new WebSocketVirtualServletRequest(holder, new ByteArrayInputStream(data, offset, length));
    }

    private WebSocketVirtualServletResponse createServletResponse(WebSocketServletHolder holder) throws IOException {
        return new WebSocketVirtualServletResponse(holder);
    }

    class Jetty9WebSocketHolder
    implements WebSocketServletHolder {
        final Session session;

        Jetty9WebSocketHolder(Session s) {
            this.session = s;
        }

        @Override
        public String getAuthType() {
            return null;
        }

        @Override
        public String getContextPath() {
            return ((ServletUpgradeRequest)this.session.getUpgradeRequest()).getHttpServletRequest().getContextPath();
        }

        @Override
        public String getLocalAddr() {
            return null;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public int getLocalPort() {
            return 0;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public Enumeration<Locale> getLocales() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public String getRemoteAddr() {
            return null;
        }

        @Override
        public String getRemoteHost() {
            return null;
        }

        @Override
        public int getRemotePort() {
            return 0;
        }

        @Override
        public String getRequestURI() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public StringBuffer getRequestURL() {
            return new StringBuffer(this.session.getUpgradeRequest().getRequestURI().toString());
        }

        @Override
        public DispatcherType getDispatcherType() {
            return null;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public String getPathInfo() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public String getPathTranslated() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public String getScheme() {
            return "ws";
        }

        @Override
        public String getServerName() {
            return null;
        }

        @Override
        public String getServletPath() {
            return "";
        }

        @Override
        public ServletContext getServletContext() {
            return null;
        }

        @Override
        public int getServerPort() {
            return this.session.getLocalAddress().getPort();
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public Object getAttribute(String name) {
            return ((ServletUpgradeRequest)this.session.getUpgradeRequest()).getHttpServletRequest().getAttribute(name);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            try {
                this.session.getRemote().sendBytesByFuture(ByteBuffer.wrap(data, offset, length)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    private class Creator
    implements WebSocketCreator {
        private Creator() {
        }

        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return new WebSocketAdapter(){
                Session session;

                public void onWebSocketConnect(Session session) {
                    this.session = session;
                }

                public void onWebSocketBinary(byte[] payload, int offset, int len) {
                    Jetty9WebSocketDestination.this.invoke(payload, offset, len, this.session);
                }

                public void onWebSocketText(String message) {
                    try {
                        byte[] bdata = message.getBytes("utf-8");
                        this.onWebSocketBinary(bdata, 0, bdata.length);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            };
        }
    }
}

